'http://www.thebackshed.com/forum/forum_posts.asp?TID=8118&PN=1

Option explicit
Option default FLOAT
CPU 48
' 3D wire frame graphics demo using quarternions to rotate the coordinates
CLS
Dim integer cl(5)=(RGB(red),RGB(cyan),RGB(yellow),RGB(white),RGB(green),RGB(magenta))
Dim integer vpos=10

Dim q1(4),v(4),vout(4),M_PI=3.14159265359,i%,x1,y1,z1,x2,y2,z2
' define the coordinates of a cube with the z-axis towards the viewer
Dim cube(3,7)=(-100,-100,100,0, -100,100,100,0, 100,-100,100,0, 100,100,100,0, -100,-100,-100,0, -100,100,-100,0, 100,-100,-100,0, 100,100,-100,0 ) 'coordinates of the cube
' define the coordinate pairs that make up the edges of the cube
Dim cubelocation(2)=(MM.HRes/2,MM.VRes/2,-500) 'actual location of the centre of the cube in space
' define the coordinate pairs that make up the edges of the cube
Dim cubelines%(1,11)=(0,1, 0,2, 1,3, 2,3, 4,5, 4,6, 5,7, 6,7, 0,4, 1,5, 2,6, 3,7)
'define the projection plane
Dim viewplane = -200
Dim lines%(3,11),oldlines%(3,11) 'storage for the coordinates for lines drawn
For i%=0 To 7 'convert coordinates to normalised form
  x1=cube(0,i%): y1=cube(1,i%): z1=cube(2,i%)
  create_vector(x1,y1,z1,v())
  cube(0,i%)=v(2): cube(1,i%)=v(3): cube(2,i%)=v(4): cube(3,i%)=v(0)
Next i%
'create a quarternion to rotate 2 degrees about x axis
'play with the x,y,z vector which is the sxis of rotation
create_normalised_quaternion(1,3,3,3,q1())
Do
  For i%=0 To 11 'project the coordinates onto the viewplane
    z1=cube(2,cubelines%(0,i%))*cube(3,cubelines%(0,i%))+cubelocation(2)
    x1=(cube(0,cubelines%(0,i%))*cube(3,cubelines%(0,i%))*viewplane/z1 +cubelocation(0))
    y1=(cube(1,cubelines%(0,i%))*cube(3,cubelines%(0,i%))*viewplane/z1 +cubelocation(1))
    z2=cube(2,cubelines%(1,i%))*cube(3,cubelines%(1,i%))+cubelocation(2)
    x2=(cube(0,cubelines%(1,i%))*cube(3,cubelines%(1,i%))*viewplane/z2 +cubelocation(0))
    y2=(cube(1,cubelines%(1,i%))*cube(3,cubelines%(1,i%))*viewplane/z2 +cubelocation(1))
    lines%(0,i%)=x1 :lines%(1,i%)=y1 :lines%(2,i%)=x2 :lines%(3,i%)=y2
  Next i%
  For i%=0 To 7 'rotate coordinates
    v(2)=cube(0,i%): v(3)=cube(1,i%): v(4)=cube(2,i%): v(0)=cube(3,i%): v(1)=0
    rotate_vector(vout(),v(),q1())
    cube(0,i%)=vout(2): cube(1,i%)=vout(3): cube(2,i%)=vout(4): cube(3,i%)=vout(0)
  Next i%
  For i%=0 To 11 'delete the old lines
    Line oldlines%(0,i%),oldlines%(1,i%),oldlines%(2,i%),oldlines%(3,i%),1,RGB(black)
  Next i%
  For i%=0 To 11 'draw the new lines
    Line lines%(0,i%),lines%(1,i%),lines%(2,i%),lines%(3,i%),1,cl(i%-6*(i%>5))'RGB(green)
    oldlines%(0,i%)=lines%(0,i%):oldlines%(1,i%)=lines%(1,i%):oldlines%(2,i%)=lines%(2,i%):oldlines%(3,i%)=lines%(3,i%)
  Next i%
  cubelocation(1)=cubelocation(1)+vpos

  If cubelocation(1)>MM.VRes/2+60 Then
    vpos=-(10+Rnd()*20)
    If Rnd() >.9 Then create_normalised_quaternion(1,3,3,3,q1())
  EndIf
  If cubelocation(1)<MM.VRes/2-60 Then
    vpos=+10+Rnd()*20
    If Rnd() >.9 Then create_normalised_quaternion(-1,9,9,9,q1())
  EndIf
Loop
End

'
Sub create_normalised_quaternion(theta,x,y,z,q())
  Local radians = theta!/180.0*M_PI
  Local sineterm= Sin(radians!/2)
  q(1)=Cos(radians/2)
  q(2)=x* sineterm!
  q(3)=y* sineterm!
  q(4)=z* sineterm!
  q(0)=Sqr(q!(1)*q(1) + q(2)*q(2) + q(3)*q(3) + q(4)*q(4)) 'calculate the magnitude
  q(1)=q(1)/q(0) 'create a normalised quaternion
  q(2)=q(2)/q(0)
  q(3)=q(3)/q(0)
  q(4)=q(4)/q(0)
  q(0)=1
End Sub
'
Sub invert_quaternion(n(),q())
  n(0)=q(0)
  n(1)=q(1)
  n(2)=-q(2)
  n(3)=-q(3)
  n(4)=-q(4)
End Sub
'
Sub multiply_quaternion(n(),q1(),q2())
  Local a1=q1(1),a2=q2(1),b1=q1(2),b2=q2(2),c1=q1(3),c2=q2(3),d1=q1(4),d2=q2(4)
  n(1)=a1*a2-b1*b2-c1*c2-d1*d2
  n(2)=a1*b2+b1*a2+c1*d2-d1*c2
  n(3)=a1*c2-b1*d2+c1*a2+d1*b2
  n(4)=a1*d2+b1*c2-c1*b2+d1*a2
  n(0)=q1(0)*q2(0)
End Sub
'
Sub create_vector(x,y,z,v())
  v(0)=Sqr(x*x + y*y + z*z)
  v(1)=0
  v(2)=x/v(0)
  v(3)=y/v(0)
  v(4)=z/v(0)
End Sub

Sub rotate_vector(vnew(),v(),q())
  Local n(4),iq(4)
  multiply_quaternion(n(),q(),v())
  invert_quaternion(iq(),q())
  multiply_quaternion(vnew(),n(),iq())
End Sub                                             