? "TEST BIT MANIPULATION FUNCTIONS for CMM2 "
? "----------------------------------------"
?
dim integer a=0, b=0, loops=1000, n
dim integer FLAGS

? "Empty Loop
timer=0
for i = 1 to loops

next
t0=timer
? t0/loops*1000"us"
? bin$(a,64)

? "FlagSet old

timer=0
for i = 1 to loops
a=a or (2^63)
next
t=timer
? (t-t0)/loops*1000"us"
? bin$(a,64)

?
? "FlagSet new

a=0
timer=0
for i = 1 to loops
a=a or (1<<63)
next
t=timer
? (t-t0)/loops*1000"us"
? bin$(a,64)

?
? "FlagRes old

b=a
timer=0
for i = 1 to loops
a=(a OR (2^63)) XOR (2^63)
next
t=timer
? (t-t0)/loops*1000"us"
? bin$(a,64)

?
? "FlagRes new

a=b
timer=0
for i = 1 to loops
a=a AND inv (1<<63)
next
t=timer
? (t-t0)/loops*1000"us"
? bin$(a,64)

?
? "FlagTest old
FLAGS=0
FlagSet(n)
? bin$(FLAGS,64)

timer=0
for i = 1 to loops
a=FlagTest(n)
next
t=timer
? (t-t0)/loops*1000"us"
? a

?
? "FlagTest new
? bin$(FLAGS,64)

timer=0
for i = 1 to loops
a=nFlagTest(n)
next
t=timer
? (t-t0)/loops*1000"us"
? a


SUB FlagSet(bit AS INTEGER)
    FLAGS=FLAGS OR (2^bit)
END SUB  


SUB nFlagSet(bit AS INTEGER)
    FLAGS=FLAGS or (1<<63)
END SUB  


SUB FlagRes(bit AS INTEGER)
    FLAGS=(FLAGS OR (2^bit)) XOR (2^bit)
END SUB 


SUB nFlagRes(bit AS INTEGER)
    FLAGS=FLAGS AND inv (1<<63)
END SUB 


FUNCTION FlagTest(bit AS INTEGER) AS INTEGER
    FlagTest=ABS(SGN(FLAGS AND (2^bit)))
END FUNCTION


FUNCTION nFlagTest(bit AS INTEGER) AS INTEGER
    nFlagTest=(FLAGS AND(1<<bit))<>0
END FUNCTION
