'***************************************************
'* DEMO program for AES128 function 12/2024
'* File_AES128 v0.08
'* PicoMite MMBasic Edition V6.00.01RC10 or later
'*
'* Purpose: encrypts and decrypts files
'* Please use your own 16 Byte password (myKey$)
'*
'* If IV_incl=FALSE
'* the initialization vector is not stored in the
'* encrypted file and must be sent separately.
'*
'* I don't know if encryption in chunks of 224 bytes
'* is a risk, as is storing the file name and
'* file length in plain text.
'***************************************************

Option EXPLICIT
CLS
Const TRUE =1
Const FALSE=TRUE=0
'Dim INTEGER IV_incl=TRUE               ' include the IV in encrypted file
Dim INTEGER IV_incl=FALSE              ' don't include the IV in encrypted file
Dim STRING Fname$  =""
Dim STRING CFname$ ="ENCRYPTED.DAT"
Dim STRING mykey$  ="0123456789ABCDEF" ' Your "Password", 16 Bytes
Dim STRING myIV$   ="ABCDEFGHIJKLMOPQ" ' IV=initialisation vector
                                       ' (something like a second key)
                                       ' For real application the IV$ should
                                       ' be random and 16 bytes long
                                       '
Print "IV_incl is " ;
If IV_incl Then Print "enabled" Else Print "disabled"

'myIV$  =RandomKey$() ' if IV_incl=TRUE
If IV_incl Then
  Open "StoredIV$.dat" For output As #1
  Print #1, myIV$;
  Close #1
EndIf

If Len(mykey$) <>16 Then
  Print "Error: mykey$ too short!"
  End
End If

Input "File to encrypt: ",FName$
If FName$<>"" Then
  If MM.Info(EXISTS FILE FName$) Then
    do_AES_EncryptFile(FName$,mykey$,myIV$,IV_incl)

    If IV_incl Then
      myIV$  ="" ' the sender included the IV
    EndIf

    do_AES_DecryptFile(CFname$,mykey$,myIV$) ' the recipient gets a .out file

    ' compare
    If FIdent%(FName$,FName$+".out") Then
      Print FName$ " and " FName$+".out are identical!"
    Else
      Print FName$+" and "+ FName$+".out are NOT identical!"
    EndIf
  Else
    Print FName$ " File name does not exist"
  EndIf
EndIf
End
'*******************************************************


'**********************************************
'* AES-ENcryption
'* Note:
'* Uses the IV$ but does not store it in the
'* encrypted file
'**********************************************
Sub do_AES_EncryptFile(FileN$,key$,IV$,IV_incl)
Const TRUE   =1
Const FALSE  =0
Const CH_SIZE=224
Const IV_SIZE=16
Local integer f_pos%
Local integer ch1, ch2
Local integer IV_FLAG   ' For future expansion
Local string in$="", out$=""

  Open CFname$ For output As #1
  Open FileN$ For input As #2
  Print #1,"FILE: "+FileN$
  Print #1,MM.Info(FILESIZE FileN$)

  ch1=(Int(MM.Info(FILESIZE FileN$))/CH_SIZE)
  ch2=(MM.Info(FILESIZE FileN$)) Mod CH_SIZE

  Do While ch1>=0
    in$=Input$(CH_SIZE,#2)
    Inc in$,String$((16-Len(in$) Mod 16)Mod 16,0)
    ' encrypt the in$
    Math aes128 encrypt ctr key$,in$,out$,iv$

    ' delete IV-Key
    If IV_incl Then
      IV_incl=FALSE   ' skip the first chunk, retain the VI
    Else
      out$=Mid$(out$,IV_SIZE+1)
    EndIf

    On error skip
    Print #1, out$;
    If MM.Errno<>0 Then
      Print "Error: ";MM.ErrMsg$
      Close #1,#2
      End
    EndIf

    If f_pos% >= 10000 Then Print "#";f_pos%;Chr$(13);

    Inc f_pos%,CH_SIZE
    Inc ch1,-1
  Loop

  Close #1,#2
  If MM.Errno = 0 Then
    Print "File: " + FileN$ + " successfully as "+CFname$+" encrypted!"
  Else
     Print "ERROR @ File: "+ FileN$+" "+MM.ErrMsg$
  EndIf

End Sub '**************** do_AES_EncryptFile *************************


'**********************************************
'* AES_DEcrypt
'* Note:
'* Needs the IV$ to decrypt the encrypted file
'**********************************************
Sub do_AES_DecryptFile(CFileN$,key$,IV$)'
Local integer f_pos% = 0,ch1,ch2,cflen
Local string AFileLen$,outfileN$
Const CH_SIZE=224
Local string in$="",out$=""

  Open CFileN$ For input As #1
  Line Input #1,outfileN$
  Line Input #1,AFileLen$
  If IV$="" Then IV$=Input$(16,#1)
  ' Encrypted file length (the "-4" for 2x chr$(13)+chr$(10))
  cflen=MM.Info(FILESIZE CFileN$)-Len(outfileN$)-Len(AFileLen$)-4
  outfileN$=Mid$(outfileN$,7)+".out" 'overwrites outfileN$

  ch1=Int(cflen/CH_SIZE)
  ch2=cflen Mod CH_SIZE

  Open outfileN$ For output As #2
  Do While ch1>=0
    in$=IV$+Input$(CH_SIZE,#1)
    ' decrypt the in$
    Math aes128 decrypt ctr key$,in$,out$
    If ch1=0 And ch2>0 Then ' last chunk, prune the data
      out$=Left$(out$,(Val(AFileLen$) Mod CH_SIZE))
    EndIf
    Print #2, out$;
    If f_pos% >= 10000 Then Print "#";f_pos%;Chr$(13);

    Inc f_pos%,CH_SIZE
    Inc ch1,-1
  Loop

  On error skip 1
  Close #1,#2
  Print "File: "+CFileN$+" successfully as "+outfileN$+" decrypted."
  If MM.Errno<>0 Then
    Print "Error: ";MM.ErrMsg$
    End
  EndIf

End Sub '****************  do_AES_DecryptFile  ********************


Function FIdent%(File1$,File2$) As integer 'compare files
 Local F_pos%=0
 Local a1$,a2$
 Const TRUE=1
 Const FALSE=0

  Print
  Print "Comparing "+ File1$ +" with "+ File2$
  Open File1$ For random As #1
  Open File2$ For random As #2
  If MM.Info(FILESIZE File1$)<> MM.Info(FILESIZE File2$) Then
    FIdent%=FALSE
    If Lof(#1)>Lof(#2) Then
      Print "File1 is larger than File2!"
    Else
      Print "File2 is larger than File1!"
    EndIf
    Print "Difference: "MM.Info(FILESIZE File1$)-MM.Info(FILESIZE File2$)
    Exit Function
  EndIf

  Do While Not Eof(#1) Or Not Eof(#2)
   a1$=Input$(1,#1)
   a2$=Input$(1,#2)

   Inc F_pos%
   If a1$<>a2$ Then
       Print :Print
       Print "Files are different at "F_pos%,a1$,a2$
       FIdent%=FALSE
       Exit Function
   EndIf
  Loop
  FIdent%=TRUE
' Print "Files are identical! "
End Function


Sub list_file(fileN$) 'List 1000 char. from fileN
  Open fileN$ For input As #1
  i=0
  Do While Not Eof(#1) And i <= 1000
    Inc i
    Print Input$(1,#1);
  Loop
  Close 1
  Print
  Print "Ready!"
  End
End Sub


Function RandomKey$()
Local integer i=0
Math RANDOMIZE Timer
  Do
    Inc RandomKey$, Chr$(Int(Math(rand)*256))
    Inc i
  Loop While i <16
End Function                                                         