' RTTTL Player for PicoMite MMBasic v6.00.03
' RTTTL parsing from DATA statements
Option explicit

Dim String header$      ' header string like "name:d=4,o=5,b=120"
Dim String note$        ' a single note token
Dim Integer defDur= 4   ' default duration (numeric)
Dim Integer defOct= 5   ' default octave (numeric)
Dim Integer bpm   = 120 ' tempo in beats per minute
Dim Integer i, vol= 20

' -------------------------
' Main program: read DATA blocks and play them
' -------------------------
' Data layout: first DATA line is header "Name:d=...,o=...,b=..."
' subsequent DATA lines are comma-separated notes
' an empty DATA line terminates the tune
' -------------------------
' read and play lines until empty DATA
' Example tunes in DATA statements below (replace/add as needed)

Play volume vol,vol

'Restore JingleBells
'Restore Jingle
'Restore Anthem
'Restore Santa
'Restore Rule
Restore Rudolph

Read header$
ParseHeader header$
PlayRTTTLfromDatas
End

' -------------------------
Sub PlayRTTTLfromDatas
' -------------------------
Local integer Dpos
Local string Dline$,token$
Do
  Read Dline$
  If Dline$ = "" Then Exit Do
  ' split comma-separated notes
  i=1
  Do
  Dpos = Instr(i, Dline$, ",")
  If Dpos = 0 Then
    token$ = Mid$(Dline$, i)
  Else
    token$ = Mid$(Dline$, i, DPos - i)
  End If
  If token$ <> "" Then PlayToken token$
    If DPos = 0 Then Exit Do
    i = DPos+1
  Loop
Loop
End Sub


' -------------------------
' Helper: convert note token (e.g. "a#5","c6","p") to frequency (Hz)
' Returns 0 for pause
' -------------------------
Function NoteToFreq(n$) As float
Local integer octave = 4
Local float  baseFreq= 0
Local string octChar, base$= n$

  ' if last char is digit -> extract octave
  octChar = Right$(base$, 1)
  If octChar >= "0" And octChar <= "9" Then
     octave = Val(octChar)
     base$  = Left$(base$, Len(base$) - 1)
  End If
  ' normalize to uppercase
  base$ = UCase$(base$)
  Select Case base$
    Case "C": baseFreq = 261.625565
    Case "C#","DB": baseFreq = 277.182631
    Case "D": baseFreq = 293.664768
    Case "D#","EB": baseFreq = 311.126984
    Case "E": baseFreq = 329.627557
    Case "F": baseFreq = 349.228231
    Case "F#","GB": baseFreq = 369.994423
    Case "G": baseFreq = 391.995436
    Case "G#","AB": baseFreq = 415.304698
    Case "A": baseFreq = 440.0
    Case "A#","BB": baseFreq = 466.163762
    Case "B": baseFreq = 493.883301
    Case "P" ' pause
      NoteToFreq = 0
      Exit Function
    Case Else
      NoteToFreq = 0
      Exit Function
  End Select

  ' adjust for octave (reference base frequencies are for octave 4)
    NoteToFreq = baseFreq * (2 ^ (octave - 4))
    Print base$;Str$(octave,1),Str$(NoteToFreq,4,2);" Hz",
End Function

' -------------------------
' Parse header defaults (d=,o=,b=)
' -------------------------
Sub ParseHeader(h$)
Local integer p
  Print "Name: ";Field$(h$,1,":")
  p = Instr(h$, "d=")
  If p > 0 Then defDur = Val(Mid$(h$, p + 2))

  p = Instr(h$, "o=")
  If p > 0 Then defOct = Val(Mid$(h$, p + 2))

  p = Instr(h$, "b=")
  If p > 0 Then bpm = Val(Mid$(h$, p + 2))
  Print "d:"defDur,"o:"defOct,"b:"bpm
End Sub

' -------------------------
' Play a single RTTTL note token (e.g. "4c#6.","8p")
' -------------------------
Sub PlayToken(tok$)
Local s$, k, durNum, isDotted, notePart$, f, durationMs
Local ch As string, numStr As string
  s$ = tok$
  If s$ = "" Then Exit Sub

  ' detect dotted note (has .)
  isDotted = 0
  If Instr(s$, ".") > 0 Then isDotted = 1

  ' remove dots for parsing
  numStr = ""
  k = 1
  Do
    ch = Mid$(s$, k, 1)
    If ch = "" Then Exit Do
    If ch <> "." Then numStr = numStr + ch
    Inc k
  Loop
  s$ = numStr

  ' extract leading digits as duration (if any)
  k=1
  Do
    ch = Mid$(s$, k, 1)
    If ch < "0" Or ch > "9" Then Exit Do
    Inc k
  Loop
  If k > 1 Then
    durNum = Val(Left$(s$, k - 1))
  Else
    durNum = defDur
  End If
  notePart$ = Mid$(s$, k)

  ' uppercase note letter for comparison, but keep # if present
  notePart$ = UCase$(notePart$)

 ' if note is not pause and has no octave digit append default octave
 If notePart$ <> "P" Then
   ch = Right$(notePart$, 1)
   If ch < "0" Or ch > "9" Then
     notePart$ = notePart$ + Str$(defOct)
   End If
 End If

 ' duration (ms) = (60,000 / bpm) * 4 / durNum
 durationMs = (60000 / bpm) * 4 / durNum
 If isDotted Then durationMs = durationMs * 1.5

 ' compute frequency
 f = NoteToFreq(notePart$)
 If f <= 0 Then
   ' pause
   Pause durationMs
 Else
   ' PLAY TONE runs in background; pause to allow sound to play
   ' Using two identical freq arguments matches documented examples
    Play TONE f, f, durationMs 'obsolet

   ' PLAY SOUND soundno,channelno, type [,frequency][,volume]
'   Play SOUND 1,B,S,f,vol
   Pause durationMs
   Play STOP
   Print Str$(durationMs,4,0);"ms"
 End If
End Sub


' -------------------------
' DATA blocks (example RTTTL tunes)
' Replace or add DATA blocks as needed
' First DATA line is the header (name:d=...,o=...,b=...)
' Terminate a tune with a blank DATA line
' -------------------------

JingleBells:
Data "JingleBells:d=4,o=5,b=105:8g,8e6,8d6,8c6,2g,8g,8e6,8d6,8c6,2a,8a,8f6,8e6"
Data "8d6,8b,8g,8b,8d6,8g.6,16g6,8f6,8d6,2e6,8g,8e6,8d6,8c6,2g,16f#,8g,8e6"
Data "8d6,8c6,2a,8a,8f6,8e6,8d6,8g6,16g6,16f#6,16g6,16f#6,16g6,16g#6,8a.6"
Data "16g6,8e6,8d6,c6,g6,8e6,8e6,8e.6,16d#6,8e6,8e6,8e.6,16d#6,8e6,8g6,8c.6"
Data "16d6,2e6,8f6,8f6,8f.6,16f6,8f6,8e6,8e6,16e6,16e6,8e6,8d6,8d6,8e6,2d6"
Data ""

Jingle:
Data "Jingle Bells:d=4,o=5,b=170"
Data "B,B,B,P,B,B,B,P,B,D6,G.,8A,2B.,8P,C6,C6,C6."
Data "8C6,C6,B,B,8B,8B,B,A,A,B,2A,2D6"
Data ""
Anthem:
Data "USA National Anthem:d=8,o=5,b=120"
Data "E.,D,4C,4E,4G,4C6.,P,E6.,D6,4C6,4E,4F#,4G.,P,4G"
Data "4E6.,D6,4C6,2B,A,4B,C6.,16P,4C6,4G,4E,32P,4C"
Data ""
Santa:
Data "Santa Clause is Coming Tonight:d=4,o=5,b=200"
Data "G,8E,8F,G,G.,8G,8A,8B,C6,2C6,8E,8F,G,G,G,8A,8G,F,2F"
Data "E,G,C,E,D,2F,B4,1C,P,G,8E,8F,G,G.,8G,8A,8B,C6,2C6,8E"
Data "8F,G,G,G,8A,8G,F,F,E,G,C,E,D,2F,B4,1C,P,C6,D6,C6,B,C6,A"
Data "2A,C6,D6,C6,B,C6,2A.,D6,E6,D6,C#6,D6,B,B,B,8B,8C6,D6,C6"
Data "B,A,G,P,G.,8G,8E,8F,G,G.,8G,8A,8B,C6,2C6,8E,8F,G,G,G,8A"
Data "8G,8F,2F,E,G,C,E,D,2F,D6,1C6."
Data ""
Rule:
Data "Rule Britannia:d=8,o=5,b=100"
Data "E.,E,F,4F,E,F.,16E,D.,16C,2B4,4G,4F,16E,16C,16F,16D"
Data "G,F,4E,D.,16C,4C"
Data ""
Rudolph:
Data "Rudolph the Red Nosed Raindeer:d=8,o=5,b=120"
Data "G,4A,G,4E,4C6,4A,2G.,G,A,G,A,4G,4C6,2B.,4P,F,4G,F,4D,4B,4A,2G."
Data "G,A,G,A,4G,4A,2E.,4P,G,4A,A,4E,4C6,4A,2G.,G,A,G,A,4G,4C6,2B.,4P"
Data "F,4G,F,4D,4B,4A,2G.,G,A,G,A,4G,4D6,2C6,4P,4A,4A,4C6,4A,4G,4E,2G,4D,4E"
Data "4G,4A,4B,4B,2B,4C6,4C6,4B,4A,4G,4F,2D,G,4A,G,4E,4C6,4A,2G.,G,A,G,A,4G,4C6"
Data "2B.,4P,F,4G,F,4D,4B,4A,2G.,4G,4A,4G,4A,2G,2D6,1C6."
Data ""                                                                     