
' Load images on page 3
page write 3
cls
load png "spritesheet.png" ,0,0,12
print @(10,500) "Page 3 contains the raw image file."

' Grab some bits of the image as sprites
sprite read 1,85,126,51,118 ' one frame
sprite read 2,350,0,51,51   ' ball
sprite read 3,350,0,51,51   ' another copy for show

' Use page 1 as the drawing buffer
page write 1
cls
print @(10,430) "Page 1 is the drawing buffer. (Press any key to view another page.)"

' Initialize a bunch of stuff
dispage = 1 ' which page does the user want to look at?
im = 0      ' image number in animation sequence
x = 100 : y = 300 ' character position
delta = 9   ' character move distance per frame
wid = 80 : hi = 118 ' character size
' location of each animation frame
dim sourceX(16) = (0,85,170,255,0,85,170,255,0,85,170,255,0,85,170,255,0)
dim sourceY(16) = (1,1,1,1,126,126,126,126,251,251,251,251,375,375,375,375,0)

' ball movement data
ballX = 20 : ballY = 100
ballDX = 4.7 : ballDY = 3.7
' ball image location data
ballSourceX = 300 : ballSourceY = 0 : ballSourceW = 50 : ballSourceH = 50

' draw background aginst which the character can run
box 0,255,MM.HRES,163,1,rgb(white),rgb(white)
for i = 255 to 0 step -1
  line 0,i,MM.HRES-1,i,1,rgb(127+i/2,127+i/2,127+i/2)
next i  ' alas, attempt at grey scale shading performs poorly with this pallet

' Use page 2 for moving (invisible) sprites
page write 2
cls
print @(10,430) "Page 2 is raw sprite page for detecting collisions."

do
  ' move the sprites on page 2 to look for collisions
  page write 2
  sprite show 1,x,y,1,(delta>0) ' move the character with left/right mirroring
  sprite show 2,ballX,ballY,1,0 ' move the ball

  if sprite(C,2) > 0 and sprite(C,2) < 200 then   ' ball and figure have collided
    if ballY < 275 and ballDY > 0 then
      ballDY = -ballDY  ' bounce off head only if moving down
    else
      ' if the figure hits the ball from behind, only the figure changes direction
      delta = -delta    ' figure change direction
      if sgn(delta) = sgn(ballDX) then
        ballDX = -ballDX  ' ball bounce sideways
      endif
    endif
  endif

  ' draw stuff on page 1 for display  
  page write 1
  box x,y,wid,hi,1,rgb(white),rgb(white)  ' erase old image
  BLIT sourceX(im), sourceY(im),x,y,wid,hi,3,4+(delta>0)  ' show next frame
  sprite show 3,ballX,ballY,2,0   ' move ball

  ' wait a while, then display new screen
  pause 50
  page copy dispage to 0 , B

  ' change which page is displayed on key press
  if INKEY$<>"" then
    dispage = dispage + 1
    if dispage > 3 then dispage = 1
  endif

  ' update positions
  im = im + 1 : if im > 15 then im = 0
  x = x + delta : if x > 720 or x < 5 then delta = -delta
  ballX = ballX + ballDX : if ballX < 5 or ballX > 740 then ballDX = -ballDX
  ballY = ballY + ballDY : if ballY < 5 or ballY > 364 then ballDY = -ballDY
loop


