OPTION EXPLICIT

'===================
' required setup for function of getfile routines
CONST DIRCOUNT = 50   ' max number of sub-directories
CONST FILCOUNT = 255  ' max number of files
CONST NAMELENGTH = 64
DIM dir_dirs$(DIRCOUNT) length NAMELENGTH  ' store list of directories
DIM dir_fils$(FILCOUNT) length NAMELENGTH  ' store list of files
DIM dir_hist$(DIRCOUNT) length 8 ' store directory number visited along path
DIM d_cwidth, d_x, d_y, d_lines
DIM d_colours(3) = (&hA0A040,&h101010,&hFFFFFF,&h303030) 'array of 4 colour values
' end of setup for funtion
'===================

' declare, define, dimension other stuff here
dim NameOfFile$(1)  ' place to put chosen filename string, goes in element 0

'===================

' put program stuff here

' now the program wants a file, so
'FileDialog(NameOfFile$())   ' no options so allow any file to be selected
FileDialog(NameOfFile$(), ".txt")   ' allow only txt file to be selected

' now the path of the chosen file is in NameOfFile$(0)

Print @(20,300) NameOfFile$(0)

' more program goes here to do amazing stuff

END

'*****************************************************************
' Sub FileDialog(result$() [,spec$][,x_position][,y_position][,height][,width])
'
' This routine displays a centered dialog box on the screen, allows
' the user to choose a file and returns the full path of the chosen
' file. The underlying screen is restored when the dialog closes.
' UP and DOWN arrows to select, ENTER to choose selection
' ESC to cancel, LEFT arrow to go up directory
'
'   version 1.0    Original release vegipete, Oct 2020
'   version 1.1    all navigation by arrow keys only, can return directory names too
'   version 1.2    remembers selection when moving back up directories, can specify
'                  file criteria, forcing selection type
'   version 1.2b   fixed variable declarations so OPTION EXPLICIT works
'
' Input:  result$(): array to hold results, dim(1) for single result, more for multi
'         spec$: optional - wildcard matching, plus following
'           standard functions:
'             "*"        show all files, allow any file to be selected - default
'             "*.BAS"    show only request file types, standard MMBasic wildcard matching
'             "<DIR>"    show all files, allow only selection of directories
'           multi-select functions (only if result$ is an array, otherwise defaults to standard):
'             "<M>*"     show and multi-select all file types
'             "<M>*.BAS" show and multi-select specified file types
'             "<MDIR>"   show all, multi-select only directories
'             "<MALL>"   show all, multi-select files and directories
'           save file function:
'             "<SAVE>["starting value"]" show all, returns path of displayed directory + string
'                        from text box, which is initialized with the optional string.
'         x_position:  optional, default = centered dialog
'         y_position:  optional, default = centered dialog
'         height:      optional, height in characters of directory/file list, default 15
'         width:       optional, width in characters of directory/file list, default 32
'
' Output: result$(0) contains full path of [first] item chosen, or "" if nothing
'         result$(1-n) contain full path of remaining items chosen, or "" if nothing
'         Note: the directory part of the path will be capitalized. This is just
'         how the CWD$ function works. Fortunately, MMBasic is case insensitive.
'
' The following global variables should be declared before use:
' CONST DIRCOUNT = 50   ' max number of sub-directories
' CONST FILCOUNT = 255  ' max number of files
' CONST NAMELENGTH = 64
' DIM dir_dirs$(DIRCOUNT) length NAMELENGTH  ' store list of directories
' DIM dir_fils$(FILCOUNT) length NAMELENGTH  ' store list of files
' DIM dir_hist$(DIRCOUNT) length 8 ' store directory number visited along path
' DIM d_cwidth, d_x, d_y, d_lines
' DIM d_colours(3) = (&hA0A040,&h101010,&hFFFFFF,&h303030) 'array of 4 colour values
'    'd_colours(0)  frame               (&hA0A040 sort-of gold     )
'    'd_colours(1)  body                (&h101010 really dark grey )
'    'd_colours(2)  text                (&hFFFFFF white            )
'    'd_colours(3)  shadow              (&h303030 dark sort-of gold)
'
' Routines Used:  (included below)
'   sub ReadDir(d_spec$,d_top_item,d_sel_item,d_top_last) ' reads current directory into the above arrays
'   sub ListDir(first, nlines, hilite)  ' shows a portion of the current directory
'
Sub FileDialog(result$(), p_spec$, p_x, p_y, p_height, p_width)
  local d_spec$, d_startdir$, d_height, d_mode, d_width
  local d_framec, d_backc, d_textc, d_shadowc, d_k, d_changed
  local d_top_item, d_sel_item, d_top_last, d_chosen

  ' dialog box dimensions
  ' test parameters, fill in defaults if needed
  d_spec$ = p_spec$ : if d_spec$ = "" then d_spec$ = "*"
  d_lines = p_height : if d_lines = 0 then d_lines = 15     ' height in characters
  d_height = 50 + (d_lines - 1) * MM.INFO(FONTHEIGHT)       ' height in pixels
  d_mode = 0      ' getfile mode
  if ucase$(left$(d_spec$,6)) = "<SAVE>" then
    d_height = d_height + MM.INFO(FONTHEIGHT) + 3           ' make room for filename text line
    d_mode = 1    ' savefile mode
  endif
  d_cwidth = p_width : if d_cwidth = 0 then d_cwidth = 32   ' width in characters
  d_width = 44 + d_cwidth * MM.INFO(FONTWIDTH)              ' width in pixels
  d_x = p_x : if d_x = 0 then d_x = (MM.HRES - d_width)/2   ' location of top left corner
  d_y = p_y : if d_y = 0 then d_y = (MM.VRES - d_height)/2  '    of dialog box

  d_startdir$ = cwd$      ' save starting directory
  for d_k = 1 to DIRCOUNT ' set all elements to 1 - 1st item selected
    dir_hist$(d_k) = "1,1"
  next d_k
  dir_hist$(0) = "1"      ' initially at top directory level
  if d_startdir$ <> "A:/" then  ' determine starting directory depth
    d_startdir$ = d_startdir$ + "/"
    for d_k = 1 to len(d_startdir$)
      if mid$(d_startdir$,d_k,1) = "/" then
        dir_hist$(0) = str$(val(dir_hist$(0)) + 1) ' another level deeper
      endif
    next d_k
  endif

  ' save underlying screen image in buffer #64
  blit read 64, d_x, d_y, d_width, d_height
  ' draw dialog box
  rbox d_x + 7, d_y +  7, d_width -  8, d_height -  8, 10, d_colours(3), d_colours(3) ' shadow
  rbox d_x    , d_y     , d_width -  8, d_height -  8, 10, d_colours(0), d_colours(0) ' frame
  rbox d_x + 5, d_y + 22, d_width - 18, d_height - 34,  5, d_colours(1), d_colours(1) ' text area
  if ucase$(d_spec$) = "<DIR>" then
    text d_x+10,d_y+6,"Select Directory...", "LT", 1, 1, 0, -1
  else
    text d_x+10,d_y+6,"Select File...", "LT", 1, 1, 0, -1
  endif
  text d_x+d_width-12,d_y+1,"1", "RT", 11, 1, 0, -1  ' Arrow/Ent/Esc/space

  '--------------------
  ReadDir(d_spec$,d_top_item,d_sel_item,d_top_last)
  ListDir(d_top_item, d_lines, d_sel_item)  ' populate the dialog box

  do
    d_k = asc(inkey$)
    d_changed = 0
    select case d_k
      case  27  ' ESC
        result$(0) = ""  ' Cancel so return blank
        exit do
      case 128  ' UP arrow
        if d_sel_item = 1 then  ' is the top item selected?
          if d_top_item > 1 then  ' at top of list?
            d_top_item = d_top_item - 1  ' no so shift list up one
            d_changed = 1
          endif
        else
          d_sel_item = d_sel_item - 1  ' shift selection up one
          d_changed = 1
        endif
      case 129  ' DOWN arrow
        if d_sel_item = d_lines then  ' is the bottom item selected?
          if d_top_item < d_top_last then  ' at bottom of list?
            d_top_item = d_top_item + 1  ' no so shift list down one
            d_changed = 1
          endif
        else if d_sel_item < val(dir_dirs$(0)) + val(dir_fils$(0)) then
          ' don't shift down past last item
          d_sel_item = d_sel_item + 1  ' shift selection down one
          d_changed = 1
        endif
      case 130  ' LEFT Arrow - directory up if not root
        if cwd$ <> "A:/" then ' in a sub-directory?
          chdir ".."     'directory up chosen
          ReadDir(d_spec$,d_top_item,d_sel_item,d_top_last)
          dir_hist$(0) = str$(val(dir_hist$(0)) - 1)
          d_top_item = val(field$(dir_hist$(val(dir_hist$(0))),1,","))
          d_sel_item = val(field$(dir_hist$(val(dir_hist$(0))),2,","))
          d_changed = 1
        endif
      case 131  ' RIGHT Arrow - directory down if directory selected
        d_chosen = d_top_item + d_sel_item - 1
        if d_chosen <= val(dir_dirs$(0)) then ' item number in directory range?

          dir_hist$(val(dir_hist$(0))) = str$(d_top_item) + "," + str$(d_sel_item)
          'dir_hist$(dir_hist$(0)) = d_chosen    ' save selection number if we come back up
          dir_hist$(0) = str$(val(dir_hist$(0)) + 1)

          if right$(cwd$,1) = "/" then
            chdir cwd$ + dir_dirs$(d_chosen)  ' tunnel down a directory from root
          else
            chdir cwd$ + "/" + dir_dirs$(d_chosen)  ' tunnel down a directory
          endif
          ReadDir(d_spec$,d_top_item,d_sel_item,d_top_last)
          d_changed = 1
        endif

      case  13  ' ENTER - something has been selected
        d_chosen = d_top_item + d_sel_item - 1
        if d_chosen <= val(dir_dirs$(0)) then ' item number in directory range?
          if ucase$(d_spec$) = "<DIR>" then   ' was directory selection chosen?
            if right$(cwd$,1) = "/" then
              result$(0) = cwd$ + dir_dirs$(d_chosen) + "/"  ' directory at root level
            else
              result$(0) = cwd$ + "/" + dir_dirs$(d_chosen) + "/"   ' directory deeper
            endif     ' Note: cwd$ returns all uppercase
            exit do
          endif
        else    ' Yahoo! A filename has been chosen
          if ucase$(d_spec$) <> "<DIR>" then   ' was other than directory selection chosen?
            d_chosen = d_chosen - val(dir_dirs$(0))
            if dir_fils$(d_chosen) <> "" then  ' in case directory has no (specified) file
              if right$(cwd$,1) = "/" then
                result$(0) = cwd$ + dir_fils$(d_chosen)  ' filename at root level
              else
                result$(0) = cwd$ + "/" + dir_fils$(d_chosen)  ' filename deeper
              endif     ' Note: cwd$ returns all uppercase
              exit do
            endif
          endif
        endif
    end select
    if d_changed then   ' something changed so redisplay directory list
      ListDir(d_top_item, d_lines, d_sel_item)
    endif
  loop
  '--------------------

  ' restore original screen image  (box not needed with  f/w v5.05.06+)
  box d_x, d_y, d_width, d_height, 1, 0, 0 ' must clear to black first
  blit write 64, d_x, d_y ', 0   ' now restore all non-black pixels
  blit close 64

  ' restore starting directory
  chdir d_startdir$

  do : loop until inkey$ = ""   ' clear the keyboard buffer
end sub

'*****************************************************************
' Read directories and specified files in the current directory
sub ReadDir(spec$,d_top_item,d_sel_item,d_top_last)
  local item_cnt, i

  for i = 1 to DIRCOUNT
    dir_dirs$(i) = ""   ' clear the array
  next i
  for i = 1 to FILCOUNT
    dir_fils$(i) = ""   ' clear the array
  next i

  ' read directories first
  dir_dirs$(0) = ""  ' 0 items to begin
  item_cnt = 1
  dir_dirs$(item_cnt) = left$(Dir$("*", DIR),NAMELENGTH) ' WARNING - possible truncation
  Do While dir_dirs$(item_cnt) <> "" and item_cnt < DIRCOUNT - 1
    If dir_dirs$(item_cnt) <> "." Then item_cnt = item_cnt + 1 ' ignore "."
    dir_dirs$(item_cnt) = Dir$()
  Loop
  if dir_dirs$(item_cnt) = "" then item_cnt = item_cnt - 1

  ' Sort directories
  Sort dir_dirs$()    ' note:  "" < "A"
  ' shift non-blank entries to front of array
  for i = 1 to item_cnt
    dir_dirs$(i) = dir_dirs$(DIRCOUNT-item_cnt+i)
  next i
  dir_dirs$(0) = str$(item_cnt)   ' store number of items

  ' now read files
  dir_fils$(0) = ""  ' 0 items to begin
  item_cnt = 1
  if ucase$(spec$) = "<DIR>" then
    dir_fils$(item_cnt) = left$(Dir$("*", FILE),NAMELENGTH) ' WARNING - possible truncation
  else
    dir_fils$(item_cnt) = left$(Dir$(spec$, FILE),NAMELENGTH) ' WARNING - possible truncation
  endif
  Do While dir_fils$(item_cnt) <> "" and item_cnt < FILCOUNT - 1
    If dir_fils$(item_cnt) <> "." Then item_cnt = item_cnt + 1 ' ignore "."
    dir_fils$(item_cnt) = Dir$()
  Loop
  if dir_fils$(item_cnt) = "" then item_cnt = item_cnt - 1

  ' Sort files and shift non-blank entries to front of array
  Sort dir_fils$()
  for i = 1 to item_cnt
    dir_fils$(i) = dir_fils$(FILCOUNT-item_cnt+i)
  next i
  dir_fils$(0) = str$(item_cnt)   ' store number of items

  d_top_item = 1
  d_sel_item = 1
  d_top_last = val(dir_dirs$(0)) + val(dir_fils$(0)) - d_lines + 1

end sub

'*****************************************************************
' Display (part of) directory
' Show 'nlines' number of items, starting with item 'first',
' hilite given item
sub ListDir(first, nlines, hilite)
  local i, item, d_txt$

  for i = 0 to nlines - 1
    item = first + i
    if item > val(dir_dirs$(0)) then
      d_txt$ = dir_fils$(item - val(dir_dirs$(0)))
    else
      d_txt$ = "<DIR> " + dir_dirs$(item)
    endif
    if len(d_txt$) > d_cwidth then d_txt$ = left$(d_txt$,d_cwidth-1) + chr$(148)
    d_txt$ = left$(d_txt$ + space$(d_cwidth),d_cwidth)

    if i = hilite - 1 then
      text d_x+17, d_y+24+i*MM.INFO(FONTHEIGHT), d_txt$,"LT",1,1,d_colours(1),d_colours(0)
    else
      text d_x+17, d_y+24+i*MM.INFO(FONTHEIGHT), d_txt$,"LT",1,1,d_colours(2),d_colours(1)
    endif
  next i

end sub

'*****************************************************************
' a small gliph showing arrow keys, tab/ent/space
DefineFont #11
  04301538
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000 00000000 00000000 FF3F0000 FFC1FF1F
  B0FF43F0 FCFBE7FF FEB7FF5F 5FFCF1E7 2FACB718 F746FEE0 FBEF96B1 B7375FFE
  FEFBEFB6 B6B7D75F 42FEFBEF 6EB7B038 FF3FEEFB FFCCFF1F 000000E6 020E0800
  00000000 00E6FF0C 0E000000 0000EEFB FB0F0000 000000FE FEFB0F00 00000000
  00FEFB0F 0F000000 0000FEE0 F1070000 000000FC FCFB0700 00000000 00F0FF01
  00000000 00000000 00000000 1FFF3F00 F0FFC1FF FFB0FF43 5FFCFBE7 E7FEB7FF
  185FFCF1 E02FACB7 B1F746FE FEFBEF96 B6B7375F 5FFEFBEF EFB6B7D7 3842FEFB
  FB6EB7B0 1FFF3FEE E6FFCCFF 00000000 3F020E08 CCFFFFFF FF7FE6FF FBEEFFFF
  8C237EEE FEFBEF67 DB6BED7D 7EFEFBEF EFC36B6D AD7FFEFB E0EFDF4B AC637CFE
  FCF1E763 FFFFEF7F 3FFCFBE7 C1FFFFEF 0000F0FF 00000000 00000000 00000000
  FF1FFF3F 43F0FFC1 E7FFB0FF FF5FFCFB F1E7FEB7 B7185FFC FEE02FAC 96B1F746
  5FFEFBEF EFB6B737 D75FFEFB FBEFB6B7 B03842FE EEFB6EB7 FF1FFF3F 00E6FFCC
  08000000 FF3F020E FFCCFFFF FFFF7FE6 EEFBEEFF 678C237E 7DFEFBEF EFDB6BED
  6D7EFEFB FBEFC36B 4BAD7FFE FEE0EFDF 63AC637C 7FFCF1E7 E7FFFFEF EF3FFCFB
  FFC1FFFF 000000F0 00000000
End DefineFont
'*****************************************************************
