mode 1,16
cls
print @(0,0) " 0/1000    "
page write 1 : cls
print @(125,580) "Press [space] to start/stop, any other key to step when stopped."
pause 3000  ' wait for monitor to sync

timer = 0
'======================================
d = 800    ' distance to view plane
rho = 1000    ' distance to object (center)
cx = MM.HRES/2
cy = MM.VRES/2
pmode = 0

dim f_cols(50)      ' colour of each face
dim s_verts(50,2)   ' all the vertices
dim s_faces(50,2)   ' faces, composed of 3 vertices in couererlolowiwi o oerer
dim proj_x(50)      ' projected coordinates
dim proj_y(50)      ' \  of each vertex
dim light(2)=(0,2,10)   ' direction of light source (not distance!)

dim v1tmp(2), v2tmp(2), fnorm(2)

restore facecolours
' read in face colours
for i = 0 to 49
  read f_cols(i)
next i

' build rotation matrix
ct = cos(rad(2)) : st = sin(rad(2))
dim xrot(2,2) : math set 0, xrot()
xrot(0,0) = 1 : xrot(1,1) = ct : xrot(1,2) = st : xrot(2,1) = -st : xrot(2,2) = ct

ct = cos(rad(1)) : st = sin(rad(1))
dim yrot(2,2) : math set 0, yrot()
yrot(0,0) = ct : yrot(0,2) = -st : yrot(1,1) = 1 : yrot(2,0) = st : yrot(2,2) = ct

ct = cos(rad(.5)) : st = sin(rad(.5))
dim zrot(2,2) : math set 0, zrot()
zrot(0,0) = ct : zrot(0,1) = -st : zrot(1,0) = st : zrot(1,1) = ct : zrot(2,2) = 1

dim trot(2,2) ' total rotation matrix - order matters
math scale xrot(),1,trot()
math m_mult trot(),yrot(),trot()
math m_mult trot(),zrot(),trot()

restore octashape
ReadShape
SpinIt

page write 0
'print timer
print "Press a key for more sides..."
do : loop until inkey$ <> ""

restore icosashape
ReadShape
SpinIt

page write 0
'print timer
print "Press a key to end..."
do : loop until inkey$ <> ""
end

sub SpinIt
  page write 1
  ' draw iteration 0
  DrawSolid  ' erase box = 0 at start

  for iter = 1 to 1000

    ' rotate the vertex cloud in 3 dimensions
    for i = 0 to nverts-1
      v1tmp(0) = s_verts(i,0) : v1tmp(1) = s_verts(i,1) : v1tmp(2) = s_verts(i,2)
      math v_mult trot(),v1tmp(),v2tmp()
      s_verts(i,0) = v2tmp(0) : s_verts(i,1) = v2tmp(1) : s_verts(i,2) = v2tmp(2)
    next i

    DrawSolid

    print @(0,0) iter "/1000    "
    page copy 1,0,B
    k = asc(inkey$)
    if pmode then
      do
        if k = 32 then pmode = 0
        if k <> 0 then exit do
        k = asc(inkey$)
      loop
    else
      if k = 32 then pmode = 1
    endif
  next iter
end sub

sub DrawSolid
  ' calculate erasing box
  bx = math(min proj_x())+cx : bh = math(max proj_x())+cx+&h2
  by = math(min proj_y())+cy : bv = math(max proj_y())+cy+&h2

  ' project all vertices to viewing plane
  for i = 0 to nverts-1
    ze = rho - s_verts(i,2)
    proj_x(i) = -d * s_verts(i,0) / ze
    proj_y(i) =  d * s_verts(i,1) / ze
  next i

  ' erase previous image
  box bx,by,bh-bx,bv-by,,&h0,&h0

  ' draw the faces
  for i = 0 to nfaces-1
    x0 = proj_x(s_faces(i,0)) : y0 = proj_y(s_faces(i,0))
    x1 = proj_x(s_faces(i,1)) : y1 = proj_y(s_faces(i,1))
    x2 = proj_x(s_faces(i,2)) : y2 = proj_y(s_faces(i,2))

    if (x0-x1)*(y0-y2)<(x0-x2)*(y0-y1) then ' face visible?
      v1tmp(0) = s_verts(s_faces(i,0),0) - s_verts(s_faces(i,1),0)
      v1tmp(1) = s_verts(s_faces(i,0),1) - s_verts(s_faces(i,1),1)
      v1tmp(2) = s_verts(s_faces(i,0),2) - s_verts(s_faces(i,1),2)
      v2tmp(0) = s_verts(s_faces(i,0),0) - s_verts(s_faces(i,2),0)
      v2tmp(1) = s_verts(s_faces(i,0),1) - s_verts(s_faces(i,2),1)
      v2tmp(2) = s_verts(s_faces(i,0),2) - s_verts(s_faces(i,2),2)
      math v_cross v1tmp(),v2tmp(),fnorm()  ' calculate face normal
      c = math(magnitude light()) * math(magnitude fnorm())
      if c then
        c = math(dotproduct light(), fnorm()) / c
        if c < 0 then c = 0
      else
        c = 1
      endif
      rc = ((f_cols(i) and &hFF0000) >> 16) * c
      gc = ((f_cols(i) and &h00FF00) >>  8) * c
      bc = ((f_cols(i) and &h0000FF)      ) * c
      triangle x0+cx,y0+cy,x1+cx,y1+cy,x2+cx,y2+cy,,rgb(rc,gc,bc)
    endif
  next i
end sub

' read shape data set by rtoto c cmamand
sub ReadShape
  math set 0, s_faces()
  math set 0, s_verts()
  math set 0, proj_x()
  math set 0, proj_y()

  ' read in vertices
  read nverts
  for i = 0 to nverts-1
    read s_verts(i,0) : read s_verts(i,1) : read s_verts(i,2)
  next i
  ' read in faces
  read nfaces
  for i = 0 to nfaces-1
    read s_faces(i,0) : read s_faces(i,1) : read s_faces(i,2)
  next i
end sub

sub ShowVerts
  for i = 0 to nverts-1
    print s_verts(i,0), s_verts(i,1), s_verts(i,2)
  next i
end sub

octashape:
' vertices (first value is count)
data  6, 0,250,0, 250,0,0, -250,0,0, 0,-250,0, 0,0,250, 0,0,-250
' faces (first value is count)
data  8, 4,2,3, 4,3,1, 4,1,0, 4,0,2, 5,3,2, 5,1,3, 5,0,1, 5,2,0

icosashape:
data 12
data 0,150,243, 0,-150,243, 0,150,-243, 0,-150,-243  ' (0, 1,  f)      Where f =
data 150,243,0, -150,243,0, 150,-243,0, -150,-243,0  ' (1,  f, 0)     (1 + v5) / 2
data 243,0,150, 243,0,-150, -243,0,150, -243,0,-150  ' ( f, 0, 1)  golden ratio  1.618

data 20
data  1, 6, 8,    1, 8, 0,    1, 0,10,    1,10, 7    ' vertices for
data  1, 7, 6,    6, 7, 3,    6, 3, 9,    6, 9, 8    '  each face in
data  8, 9, 4,    8, 4, 0,    0, 4, 5,    0, 5,10    '  counter-clockwise
data 10, 5,11,   10,11, 7,    7,11, 3,    3,11, 2    '  order
data  2,11, 5,    2, 5, 4,    2, 4, 9,    2, 9, 3

facecolours:
data  &hFF0000,&h00FF00,&h0000FF,&hFFFF00,&hFF00FF,&h00FFFF,&hFFFFFF,&h404040
data  &hFF4000,&h80FF00,&h4040FF,&hFFFF40,&hFF00FF,&hC0FFFF,&hFFFFFF,&h404040
data  &hFF8000,&hC0FF40,&hC000FF,&hFFFF80,&hFF80FF,&h00FFFF,&hFFFFFF,&h404040
data  &hFFC000,&h40FF00,&h0080FF,&hFFC000,&hFF00FF,&h80FFFF,&hFFFFFF,&h404040
data  &hFF0000,&h00FF00,&h4000FF,&hFF8000,&hFF40FF,&h00FFFF,&hFFFFFF,&h404040
data  &hFF0000,&h00FF00,&h0000FF,&h80FF00,&hFF00FF,&h00FFFF,&hFFFFFF,&h404040
data  &hFF0000,&h00FF00,&h0000FF,&hFFFF00,&hFF00FF,&h00FFFF,&hFFFFFF,&h404040
