'OPTION EXPLICIT  ' all variables must be defined before use - HAH! Bite me.
'
' ChemiChaos
' by vegipete, December 2020
'
' Sort the Chemical Balls in the Test Tubes
' Move with the arrow keys
' Pick and place with the space bar
' Restart level with R
' Quit with Esc
'
'   version 1.0b  slight change, but I'm not telling
'   version 1.0   Original release, graphics tweaks, more levels + counter, intro text
'   version <     development
'
'===========================================
mode 1,16 : cls

dim keypress
dim fname$
dim levelnum
dim movingball
dim vials(9,4)     ' 9 vials, each can hold 4 balls
dim vialsbak(9,4)  ' 9 vials, restore copy
dim ballcols(6) = (0,1,2,3,4,5,6) ' allow shuffling of ball colours
dim m$

sp = 1    ' sprite page
page write sp : cls
load png "ChemiChaosSprites.png"
sprite read 1,36,180,36,36,sp    ' up arrow

pause 2000    ' screen sync time
page write 0 : cls rgb(white)

levelnum = 1
restore gamelevels
nvials = 3
nballs = 2
ShuffleBCols
xpos = 1
gameover = 0

charx = 245 : chary = 10
PutString("CHEMICAL CHAOS")
line 240,37,545,37,4,0
text 585,20,"by vegipete, December 2020","LT",1,1,0,rgb(white)
charx = 0 : chary = 50
'          12345678901234567890123456789012345678
PutString("There is chaos and confusion all")
charx = 0 : chary = chary + 30
PutString("through the chemistry lab! The")
charx = 0 : chary = chary + 30
PutString("chemicals have been mixed. Your task")
charx = 0 : chary = chary + 30
PutString("is to combat the chaos and restore")
charx = 0 : chary = chary + 30
PutString("order by sorting the chemicals.")
charx = 0 : chary = chary + 30
PutString("Move the coloured balls one by one")
charx = 0 : chary = chary + 30
PutString("until each test tube contains a single")
charx = 0 : chary = chary + 30
PutString("colour. However, you can not drop a")
charx = 0 : chary = chary + 30
PutString("ball on a different coloured one!")
charx = 0 : chary = chary + 30
PutString("Use the arrow keys to move. Select and")
charx = 0 : chary = chary + 30
PutString("drop with the space bar. Press R to")
charx = 0 : chary = chary + 30
PutString("restart if you get stuck.")
charx = 0 : chary = chary + 55
PutString("Press Esc to quit and call HazMat.")
charx = 0 : chary = 500
PutString("Press a key to begin...")
'PutString("")
pause 500
do while inkey$ <> "" : loop    ' clear any key presses
do : loop until inkey$ <> ""    ' wait for key press
cls rgb(white)

do
  if MixVials() = 0 then exit do  ' no more levels
  ShowLevel
  do
    i = GetBall()
    if i then PutBall(i)
    if TestDone() then exit do  ' this level has been defused
    if gameover then exit do    ' player quit
  loop
  sprite hide 1
  if gameover then exit do      ' player quit
  ShowSafe
  ShuffleBCols
  levelnum = levelnum + 1
'  pause 2500
  do : loop until inkey$ <> ""  ' wait for keypress
  do : loop until inkey$ = ""   ' clear any keypresses
loop

charx = 20
chary = 400
if gameover then      ' player quit
  PutString("Send in the HazMat team...")
else
  PutString("All is well. Chaos has been tamed.")
endif
pause 2500

mode 1,8
print "Type 'RUN' to play again."

end

'===========================================
' Draw the pth vial, erasing anything that might be there already
' p = [1,nvials]
sub ShowVial(p)
  blit 36,0,80*p-40,200,66,168,sp
end sub

'===========================================
' Draw ball number n at yth level in xth vial
' n = [1-7] colour
' x = [1-9] vial
' y = [0-4] level (0 = above)
sub DrawBall(n,x,y)
  local ypos
  if y then
    ypos = 397-36*y   ' ball in vial
  else
    ypos = 120        ' ball above vial
  endif
  if n then
    blit 0,ballcols(n-1)*36,80*x-25,ypos,36,36,sp,4 ' coloured ball
  else
    blit 36,216,80*x-25,ypos,36,36,sp,4  ' blank ball
  endif
end sub

'===========================================
' Shuffle the ball colours around for variety
sub ShuffleBCols
  local i, tmp, n
  for i = 0 to 6
    n = int(rnd * 7)
    tmp = ballcols(i)
    ballcols(i) = ballcols(n)
    ballcols(n) = tmp
  next i
end sub

'===========================================
' Show current level
' nvials is of interest, as is vials(9,4)
sub ShowLevel
  local i,j

  charx = 245 : chary = 10
  PutString("CHEMICAL CHAOS")
  line 240,37,545,37,4,0
  text 585,20,"by vegipete, December 2020","LT",1,1,0,rgb(white)

  box 40,120,720, 36,1,rgb(white),rgb(white)  ' erase any ball taken from vial
  box 40,200,720,168,1,rgb(white),rgb(white)  ' erase any previous vials
  for i = 1 to nvials
    ShowVial(i)
    for j = 1 to 4
      DrawBall(vials(i,j),i,j+1)
    next j
  next i
  charx = 100 : chary = 400
  PutString("Level " + str$(levelnum) + "   ")

end sub

'===========================================
function TestDone()
  local i,j

  TestDone = 0
  for i = 1 to nvials
    for j = 2 to 4
      if vials(i,j) <> vials(i,1) then exit function
    next j
  next i
  TestDone = 1
end function

'===========================================
' return number of ball selected,
' return 0 if no ball selected
function GetBall()
  local k,j,res

  sprite show 1,80*xpos-25,160,1,0  ' arrow up
  GetBall = 0
  do
    k = asc(ucase$(inkey$))
    select case k
      case 130    ' left arrow
        if xpos > 1 then
          xpos = xpos - 1
          sprite show 1,80*xpos-25,160,1,0    ' draw up arrow
        endif
      case 131    ' right arrow
        if xpos < nvials then
          xpos = xpos + 1
          sprite show 1,80*xpos-25,160,1,0    ' draw up arrow
        endif
      case  27    ' [ESC]
        gameover = 1
        exit do
      case  32    ' [SPACE] - select top ball from this vial
        j = 4
        res = 0
        do
          if vials(xpos,j) > 0 then ' found a ball
            res = xpos
            movingball = vials(xpos,j)    ' actual ball colour
            exit do
          endif
          j = j - 1
        loop until j = 0
        if res then
          vials(xpos,j) = 0   ' clear location
          DrawBall(0,res,j+1)   ' erase ball from vial
          GetBall = res
          exit do
        endif
      case 82     ' "R"   restart
        math scale vialsbak(),1,vials()  ' restore starting configuration
        ShowLevel
        exit do
    end select
  loop
end function

'===========================================
' take top ball from src and put it somewhere
sub PutBall(src)
  local j,k

  sprite show 1,80*xpos-25,160,1,2  ' arrow down
  DrawBall(movingball,src,0)   ' coloured ball above vial
  do
    k = asc(ucase$(inkey$))
    select case k
      case 130    ' left arrow
        if xpos > 1 then
          DrawBall(0,xpos,0)            ' erase coloured ball above vial
          xpos = xpos - 1
          DrawBall(movingball,xpos,0)   ' draw coloured ball above vial
          sprite show 1,80*xpos-25,160,1,2    ' draw down arrow
        endif
      case 131    ' right arrow
        if xpos < nvials then
          DrawBall(0,xpos,0)            ' erase coloured ball above vial
          xpos = xpos + 1
          DrawBall(movingball,xpos,0)   ' draw coloured ball above vial
          sprite show 1,80*xpos-25,160,1,2    ' draw down arrow
        endif
      case  90    ' [Z/z]   'undocumented' undo command - replace wrongly selected ball
        DrawBall(0,xpos,0)  ' erase coloured ball above pointer
        for j = 1 to 4
          if vials(src,j) = 0 then     ' find top spot
            vials(src,j) = movingball  ' put the ball back
            DrawBall(movingball,src,j+1) ' re-draw coloured ball in vial
            exit do
          endif
        next j
      case  27    ' [ESC]
        gameover = 1
        exit do
      case  32    ' [SPACE] - place ball
        if vials(xpos,4) = 0 then     ' there is room in this vial
          top = 0
          for j = 1 to 4
            if vials(xpos,j) = 0 then   ' found a spot
              if (top = 0) or (top = movingball) then
                vials(xpos,j) = movingball    ' move the ball
                DrawBall(0,xpos,0)            ' erase coloured ball above vial
                DrawBall(movingball,xpos,j+1) ' draw coloured ball in vial
                exit do
              endif
            else
              top = vials(xpos,j)
            endif
          next j
        endif
      case 82     ' "R"   restart
        math scale vialsbak(),1,vials()  ' restore starting configuration
        ShowLevel
        exit do
    end select
  loop
end sub

'===========================================
sub PutChar(c$)
  local cn = asc(c$) - 32

  if cn < 0 then exit sub
  if cn > 95 then exit sub
  blit 102+(cn mod 16)*21,int(cn/16)*30,charx,chary,21,30,sp
  charx = charx + 21
  if charx > MM.HRES then
    charx = 0
    chary = chary + 30
  endif
end sub

'===========================================
sub PutString(s$)
  local i

  for i = 1 to len(s$)
    PutChar(mid$(s$,i,1))
  next i
end sub

'===========================================
sub ShowSafe
  rbox MM.HRES/2-220,225,360,100,50,&h00FF21,&h00FF21   ' greenish frame
  rbox MM.HRES/2-210,235,340, 80,40,rgb(white),rgb(white)
  blit 180,180,MM.HRES/2-170,245,260,70,sp
end sub

'===========================================
' Read another level from the data
function MixVials()
  local i,j,mix
  local c$

  math set 0,vials()    ' start with empty vials
  read nballs
  if nballs = 0 then
    MixVials = 0
    exit function
  endif
  read nvials
  if nvials = -1 then
    nvials = nballs + 2
    m$ = ""
    for i = 1 to nballs
      m$ = m$ + string$(4,str$(i))
    next i
    for i = 1 to len(m$)  ' scramble m$
      c$ = mid$(m$,i,1)
      j = int(rnd * len(m$)) + 1
      mid$(m$,i,1) = mid$(m$,j,1)
      mid$(m$,j,1) = c$
    next i
    for i = 1 to nvials   ' fill with data from m$
      for j = 1 to 4
        vials(i,j) = val(left$(m$,1))
        m$ = mid$(m$,2)
      next j
    next i

  else
    for i = 1 to nvials   ' fill with data
      read mix
      for j = 1 to 4
        vials(i,j) = mix mod 10
        mix = mix \ 10
      next j
    next i
  endif
  math scale vials(),1,vialsbak()  ' save starting configuration
  MixVials = 1
end function

'===========================================
' data format:
' #balls, #vials, ball pattern for each vial
' if #vials = -1 then fill (#balls + 2) vials randomly
gamelevels:
data 2,3,1221,2112,0
data 2,3,1212,2121,0
data 3,5,1231,3321,2231,0,0   ' this one can't be done in only 4 vials
data 3,-1
data 3,-1
data 3,-1
data 3,4,1213,2231,3213,0
data 3,4,2313,2123,2311,0
data 3,4,2313,2232,1113,0
data 3,4,1211,3323,1232,0
data 3,4,2132,3221,3311,0
data 3,4,2221,2133,1133,0
data 3,4,1233,1212,2133,0
data 3,4,1232,3121,1323,0
data 4,-1
data 4,-1
data 4,-1
data 4,-1
data 4,5,2321,1412,4412,4333,0
data 4,5,4232,1231,2443,3114,0
data 4,5,3124,2121,2444,3331,0
data 4,5,1224,4232,4311,4133,0
data 4,5,2141,4333,3242,4121,0
data 5,-1
data 5,-1
data 5,-1
data 6,-1
data 6,-1
data 6,-1
data 6,-1
data 6,7,1324,4636,5413,6132,5562,5241,0
data 7,-1
data 7,-1
data 7,-1
data 7,-1

data 0,0  ' indicate end of data
