'=============================================================================
' GridSlide   v1.0
' by Vegipete
' Feb 14, 2022
'
' Inspired by Sebastion Coddington's 4x4 Colour Dot Puzzle
' www.instructables.com/4x4-Colour-Dot-Puzzle/
'
' Sebastion's puzzle is 3D printed.
' I took the basic concept and quickly programmed
' up this version to run on a Colour Maximite 2.
'
' The user interface is by PS2 mouse. If you don't have one,
' you really should get one. 
'=============================================================================
' Initialize a (ps2) mouse
dim click(2)
on error skip
controller mouse open 0,MouseClick  ' change here for other mouse port
if MM.ERRNO then
  mode 1,8
  cls
  print @(0,50) "This game requires a mouse."
  print "None was detected."
  end
endif
click(0) = 0
click(1) = mouse(X,0)
click(2) = mouse(Y,0)

' Initialize graphics
mode 1,16 : cls
page write 2 : cls
load png MM.INFO$(PATH) + "GSTiles.png"
sprite read 1,750,0,50,50 ' used for mouse pointer

' Display some info
page write 0
blit 228,55,170,10,460,80,2   ' display title
text 799,85,"v1.0  by Vegipete",RB,4,1,rgb(YELLOW)
text 799,102,"multimite.strongedge.net",RB,1,1,rgb(YELLOW)
text 50,500,"GOAL",CB,3,1,rgb(ORANGE)
text 400,510,"Click the arrows to",CT,3,1,rgb(ORANGE)
text 400,535,"slide rows and columns.",CT,3,1,rgb(ORANGE)
text 400,560,"Match the goal pattern to win!",CT,3,1,rgb(ORANGE)
for i = 0 to 5
  blit 0,100+i*40,0,150+i*45,120,40,2  ' display buttons
next i

' Initialize success tune
restore NoteData
dim notes(11,8)
for j = 0 to 8
  for i = 0 to 11
    read notes(i,j)
  next i
next j

oc = 5
tn$ = "5g-F-e-e-FF-------4a-5g-F-e-e--F---d--e-4a"
tn$ = tn$ + "--------a-5e---F-g-----e-C--d----e--4a-a---5F----"
tn$ = tn$ + "-----g-F-e-e-F--------4a-5g-F-e-e-"
tn$ = tn$ + "----F-d-----e-4a--------5e---F-g-----e-C-----d-e--"
tn$ = tn$ + "-4a-5d-e-f-e-d-c"

' Initialize the game board
SIZE = 5
dim brd(SIZE,SIZE)
dim gol(SIZE,SIZE)
dim rst(SIZE,SIZE)

InitBoard
DrawBoard
DrawMiniBoard   ' show solved state

do ' Play forever. Or until 'QUIT' is pressed
  do ' Pre-game loop
    ' only redraw mouse pointer if it has moved
    if click(1) <> mouse(X,0) or click(2) <> mouse(Y,0) then
      click(1) = mouse(X,0)   ' save new position
      click(2) = mouse(Y,0)
      DrawHand(click(1),click(2))
    endif
    
    if click(0) then  ' mouse has been clicked
      click(0) = 0    ' clear click flag
      if click(1) < 115 then  ' might be button click
        select case click(2)
          case 150 to 184   ' RESTART
            math scale rst(),1,brd()  ' restore starting board
            exit do   ' done with pre-game loop
          case 195 to 229   ' EASY
            ScrambleBoard(5)
            exit do
          case 240 to 274   ' MEDIUM
            ScrambleBoard(10)
            exit do
          case 285 to 319   ' HARD
            ScrambleBoard(20)
            exit do
          case 330 to 364   ' NUTS
            ScrambleBoard(100)
            exit do
          case 375 to 409   ' QUIT
            mode 1,8
            cls
            print "Good bye."
            end
        end select
      endif
    endif
  loop

  DrawHand(click(1),click(2))
  update = 1
  ' Main game loop
  do
    if update then  ' only redraw board if something moved
      sprite hide 1
      DrawBoard
      if TestSolve() then
        text 400,300,"SOLVED!",CM,3,1,rgb(ORANGE)
        PlaySong
        exit do ' solution found!
      endif
      DrawHand(click(1),click(2))
      update = 0
    endif
    
    if click(0) then  ' mouse has been clicked
      click(0) = 0    ' clear click flag
      if click(1) < 115 then  ' might be button click
        select case click(2)
          case 150 to 184   ' RESTART
            math scale rst(),1,brd()  ' restore starting board
            update = 1
          case 195 to 229   ' EASY
            ScrambleBoard(5)
          case 240 to 274   ' MEDIUM
            ScrambleBoard(10)
          case 285 to 319   ' HARD
            ScrambleBoard(20)
          case 330 to 364   ' NUTS
            ScrambleBoard(100)
          case 375 to 409   ' QUIT
            mode 1,8
            cls
            print "Good bye."
            end
        end select
      else    ' maybe game board click
        select case click(2)
          case 100 to 140, 450 to 490 ' test if y is above or below
            select case click(1)  ' test x to figure out if column clicked
              case 302 to 340
                SlideVertical(1)
              case 352 to 390
                SlideVertical(2)
              case 402 to 440
                SlideVertical(3)
              case 452 to 490
                SlideVertical(4)
            end select
          case 202 to 240         ' test if y is on a particular row
            select case click(1)
              case 200 to 240, 550 to 590 ' test if x is left or right
                SlideHorizontal(1)
            end select
          case 252 to 290
            select case click(1)
              case 200 to 240, 550 to 590
                SlideHorizontal(2)
            end select
          case 302 to 340
            select case click(1)
              case 200 to 240, 550 to 590
                SlideHorizontal(3)
            end select
          case 352 to 390
            select case click(1)
              case 200 to 240, 550 to 590
                SlideHorizontal(4)
            end select
        end select
      endif
    endif
    
    ' only redraw mouse pointer if it has moved
    if click(1) <> mouse(X,0) or click(2) <> mouse(Y,0) then
      click(1) = mouse(X,0)   ' save new position
      click(2) = mouse(Y,0)
      DrawHand(click(1),click(2))
    endif

  loop
loop

' Slide requested column
sub SlideVertical(d)
  local i
  if d > 0 and d < 5 then
    if brd(d,0) = -1 then ' slide up
      for i = 0 to 4
        brd(d,i) = brd(d,i+1)   ' shift each coloured tile
      next i
      brd(d,5) = -1   ' move empty space to other end
    else if brd(d,5) = -1 then ' slide down
      for i = 5 to 1 step -1
        brd(d,i) = brd(d,i-1)
      next i
      brd(d,0) = -1
    endif
    update = 1
    play sound 1,b,n,20:pause 20:play stop
  endif
end sub

' Slide requested row
sub SlideHorizontal(d)
  local i
  if d > 0 and d < 5 then
    if brd(0,d) = -1 then ' slide left
      for i = 0 to 4
        brd(i,d) = brd(i+1,d)
      next i
      brd(5,d) = -1
    else if brd(5,d) = -1 then ' slide right
      for i = 5 to 1 step -1
        brd(i,d) = brd(i-1,d)
      next i
      brd(0,d) = -1
    endif
    update = 1
    play sound 1,b,n,20:pause 20:play stop
  endif
end sub

' Draw the entire board
sub DrawBoard
  local i,j
  page write 1    ' draw image on page 1
  box 0,0,400,400,0,0,0   ' erase old
  for i = 0 to 5
    for j = 0 to 5
      if j = 0 and i = 0 then continue for  ' nothing in corners
      if j = 5 and i = 0 then continue for
      if j = 0 and i = 5 then continue for
      if j = 5 and i = 5 then continue for
      if brd(i,j) > 0 then
        blit 200+(brd(i,j)-1)*50,0,50+i*50,50+j*50,50,50,2 ' copy coloured tile
      endif
    next j
  next i
  box 98,98,204,204,3,rgb(WHITE)  ' box around central region
  
  ' draw the pushing tabs
  for i = 1 to 4
    if brd(i,0) < 0 then
      blit 150,0,50+i*50,350,50,50,2  ' UP arrow
      box 51+i*50,100,48,250
    else
      blit 100,0,50+i*50,0,50,50,2    ' DOWN arrow
      box 51+i*50,50,48,250
    endif
    if brd(0,i) < 0 then
      blit 50,0,350,50+i*50,50,50,2   ' LEFT arrow
      box 100,51+i*50,250,48
    else
      blit 0,0,0,50+i*50,50,50,2      ' RIGHT arrow
      box 50,51+i*50,250,48
    endif
  next i

  page write 0
  blit 0,0,200,100,400,400,1  ' copy to page 0 - hopefully clean
end sub

' Draw the goal in the bottom left
sub DrawMiniBoard
  local i,j
  for i = 1 to 4
    for j = 1 to 4
      if gol(i,j) > 0 then
        blit (gol(i,j)-1)*25,50,(i-1)*25,500+(j-1)*25,25,25,2
      endif
    next j
  next i
end sub

' Scramble the board by making n random moves
sub ScrambleBoard(n)
  local i,mv,mvold
  InitBoard
  mvold = 0
  for i = 1 to n
    DrawBoard
    do
      mv = 1 + int(rnd * 8)
    loop until mvold <> mv
    mvold = mv
    if mv < 5 then
      SlideHorizontal(mv)
    else
      SlideVertical(mv-4)
    endif
  next i
  math scale brd(),1,rst()  ' make copy for restart
end sub

' Test if solution pattern has been found
function TestSolve()
  local i,j
  TestSolve = 0   ' assume not solved to start
  for i = 1 to 4
    for j = 1 to 4
      if gol(i,j) <> brd(i,j) then exit function
    next j
  next i
  TestSolve = 1   ' YEAH! Solved!
end function

' Initialize the game board in the solved state
sub InitBoard
math set 0,brd()
  brd(1,1)=1 : brd(1,2)=1 : brd(2,1)=1 : brd(2,2)=1   ' start with solved board
  brd(1,3)=2 : brd(1,4)=2 : brd(2,3)=2 : brd(2,4)=2   ' because I don't know if
  brd(3,1)=3 : brd(3,2)=3 : brd(4,1)=3 : brd(4,2)=3   ' all positions are solvable.
  brd(3,3)=4 : brd(3,4)=4 : brd(4,3)=4 : brd(4,4)=4

  brd(5,1)=-1 : brd(5,2)=-1 : brd(5,3)=-1 : brd(5,4)=-1   ' mark movement spots
  brd(1,5)=-1 : brd(2,5)=-1 : brd(3,5)=-1 : brd(4,5)=-1
  
  math scale brd(),1,gol()  ' make copy to test if solved
  math scale brd(),1,rst()  ' no restart position yet
end sub

' Draw the pointer, preventing over travel right or down
sub DrawHand(x,y)
  sprite show 1,min(x,775),min(y,575),1
end sub

' Interrupt when mouse click detected - save position and set flag
sub MouseClick
  click(0) = 1
  click(1) = mouse(X,0)
  click(2) = mouse(Y,0)
end sub

' Play the victory song
sub PlaySong
  do while inkey$ <> "" : loop  ' clear any key presses
  for i = 1 to len(tn$)
    if click(0) then exit for   ' quit tune if mouse clicked
    if inkey$ <> "" then exit for ' quit tune if key pressed
    c$ = mid$(tn$,i,1)
    select case c$
      case "0" to "8"   ' set octave
        oc = val(c$)
      case "A" to "G", "a" to "g"
        play sound 1,B,T,notes(instr("cCdDefFgGaAb",c$)-1,oc)
        pause 150
      case "-"          ' rest
        play stop
        pause 100
      case else
    end select
  next i
  play stop
end sub

' Table of note frequencies
NoteData:
'     0      1      2      3      4      5      6      7      8      9      10     11
'     C      C#     D      D#/Eb  E      F      F#     G      G#     A      A#/Bb  B
data 16.35, 17.32, 18.35, 19.45, 20.60, 21.83, 23.12, 24.50, 25.96, 27.50, 29.14, 30.87
data 32.70, 34.65, 36.71, 38.89, 41.20, 43.65, 46.25, 49.00, 51.91, 55.00, 58.27, 61.74
data 65.41, 69.30, 73.42, 77.78, 82.41, 87.31, 92.50, 98.00, 103.8, 110.0, 116.5, 123.5
data 130.8, 138.6, 146.8, 155.6, 164.8, 174.6, 185.0, 196.0, 207.7, 220.0, 233.1, 246.9
data 261.6, 277.2, 293.7, 311.1, 329.6, 349.2, 370.0, 392.0, 415.3, 440.0, 466.2, 493.9
data 523.3, 554.4, 587.3, 622.3, 659.3, 698.5, 740.0, 784.0, 830.6, 880.0, 932.3, 987.8
data 1047 , 1109 , 1175 , 1245 , 1319 , 1397 , 1480 , 1568 , 1661 , 1760 , 1865 , 1976
data 2093 , 2217 , 2349 , 2489 , 2637 , 2794 , 2960 , 3136 , 3322 , 3520 , 3729 , 3951
data 4186 , 4435 , 4699 , 4978 , 5274 , 5588 , 5920 , 6272 , 6645 , 7040 , 7459 , 7902
