'autosave
' LodeRunner Level Display Demo
'
' written by Vegipete, Oct 2023
'
' needs:
' OPTION CPUSPEED 252000 (KHz)
OPTION DEFAULT INTEGER
MODE 2
const MAXLEVELS = 10
const NUMENEMY = 8
const NUMEXLAD = 19
sp1 = Peek(cfunaddr Lode)

dim enmy(NUMENEMY,1)  ' enemy coords
dim exla(NUMEXLAD,1)  ' exit ladders
dim re(3,1)    ' re-entry posns
dim cl(27,15)  ' current level
dim levaddr(10)
levaddr( 1) = Peek(cfunaddr Level001)
levaddr( 2) = Peek(cfunaddr Level002)
levaddr( 3) = Peek(cfunaddr Level003)
levaddr( 4) = Peek(cfunaddr Level004)
levaddr( 5) = Peek(cfunaddr Level005)
levaddr( 6) = Peek(cfunaddr Level006)
levaddr( 7) = Peek(cfunaddr Level007)
levaddr( 8) = Peek(cfunaddr Level008)
levaddr( 9) = Peek(cfunaddr Level009)
levaddr(10) = Peek(cfunaddr Level010)

'Init all
scor = 0
men = 5
lev = 1

'FRAMEBUFFER Create  ' create hidden buffer to draw each image

FRAMEBUFFER Layer 13 ' colour 13 (lilac) is transparent

' prep layers for iris effect
FRAMEBUFFER Write L
cls rgb(lilac)         ' clear all to transparent
box 19,11,282,186,1,0,0 ' hide playing area
FRAMEBUFFER Write N

do
  DecodeLevel(levaddr(lev))
  DrawTitleBox
  DrawCurLevel(0)  ' play view
  Iris(1,15)  ' open the iris to view new level
  text 40,239,"Press a key...",LB,8
  do : loop until inkey$ <> ""
  text 40,239,"              ",LB,8
  Iris(0,15)  ' hide it
  
  inc lev
loop until lev > MAXLEVELS

end

' open or close the iris
' d=0 to close, else open
' t=speed (ms delay between circles)
sub Iris(d,t)
  local i
  FRAMEBUFFER Write L
  if d then ' open iris
    for i = 2 to 200  ' expanding circles of transparency
      circle MM.HRES/2,MM.VRES/2-15,i,2,,rgb(lilac)
      pause t
    next i
  else  ' close iris
    FRAMEBUFFER COPY N, L, B  ' copy display to front layer
    box 19,11,282,186,1,rgb(lilac),rgb(lilac) ' transp playing area
    FRAMEBUFFER Write N ' erase back layer
    for i = 200 to 2 step -1  ' shrinking circles of opaque
      circle MM.HRES/2,MM.VRES/2-15,i,2,,0
      pause t
    next i
    cls
    DrawTitleBox  ' redraw on back layer
    FRAMEBUFFER Write L
    cls rgb(lilac)         ' clear all to transparent
    box 19,11,282,186,1,0,0 ' hide playing area
  endif
  FRAMEBUFFER Write N
end sub

' draw the play area frame and bottom text on the active layer
sub DrawTitleBox
  cls
  box 14,6,292,196,5,rgb(cobalt),0
  text 70,206,"SCORE",RT,9,,rgb(cobalt)
  text 72,206,str$(scor,7,0,"0"),LT,9,,rgb(brown)
  text 180,206,"MEN",RT,9,,rgb(cobalt)
  text 182,206,str$(men,3,0,"0"),LT,9,,rgb(brown)
  text 270,206,"LEVEL",RT,9,,rgb(cobalt)
  text 272,206,str$(lev,3,0,"0"),LT,9,,rgb(brown)
end sub

' Draw current level
' If e=1 then show in edit mode
sub DrawCurLevel(e)
  local integer x,y,t
  
  if e then e = 1 ' only 0 and 1 are valid
  for y = 0 to 15
    for x = 0 to 27
      t = cl(x,y)
      if t > 9 then t = 0
      if t = 7 then t = 7*e ' hide level end ladder
      if t then
        if t = 5 then t = 1+4*e ' don't show trap door
        blit memory sp1+(t-1)*60,20+x*10,21+y*11
      endif
    next x
  next y
end sub

DefineFont #9
  40200C0A
  00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000
  00000000 00000000 00000000 00000000
  00000000 00000000 F0C00300 030F3C30
  030CF0C0 0000F0C0 30C0030F F0C0030F
  030F0C3C 000000C0 00000000 00000000
  00000000 00000000 00000000 00000000
  00000000 00000000 00000000 07000000
  0018E081 00000000 F0C30F00 00000000
  00000000 00000000 00000000 E0810700
  00000000 00000000 00000000 00000000
  19E61F00 66986186 99679E79 0000F8E7
  30C0030F C000030C C30F0C30 1F0000F0
  010618E6 8001E69F F8E71960 E61F0000
  87010618 010618E0 00F86798 99671E00
  E09F79E6 80010618 00001860 8001E61F
  78E01F60 E781071E 1F0000F8 608019E6
  9EF90718 F8E79967 E01F0000 81071E78
  1860E0E1 00800106 98E10700 E69F1966
  98618619 0000F867 8619E61F 78E09F61
  E081071E 01000078 06186080 78000000
  0080071E 80010000 00061860 1E780000
  10608007 18000000 071E1E1E 80077880
  00000060 FEF90700 00000000 E09F7F00
  00000000 1EE00106 7878E001 00001878
  E61F0000 81010618 070078E0 0078E081
  09E61F00 A69A6E82 1960BEA9 0000F8E7
  6698E107 19E69F19 E6996186 1F000078
  66986186 8619E61F F8679861 E61F0000
  18608019 78E08107 00F8671E 19861F00
  67986186 9E79E699 0000E067 E081E71F
  01861F78 07186080 1F0000F8 78E081E7
  8001861F 00061860 E61F0000 18608019
  609E7906 00F82798 19661800 E79F6186
  9E79E699 00009867 60800106 E0810718
  81071E78 010000E0 06186080 1E78E001
  F8E79907 66180000 1F669879 79E6F987
  0098679E 01061800 07186080 1E78E081
  0000F807 FE396718 19669B7F 679E7986
  1C000098 6FF69967 8639E699 98679E79
  E61F0000 98679E79 61861966 00F86798
  19E61F00 67986186 1E78E0F9 00008007
  9E79E61F 19669867 87996186 1F000098
  410619E4 F881E79F 98671E7E E61F0000
  1F608019 071E78E0 00F8E799 80E11F00
  01061860 071E78E0 0000E081 86196618
  99679861 679E79E6 1E0000F8 79E69967
  E699679E 8081877F 671C0000 9D71C619
  3FFE5967 0030C30C 19661800 81876186
  986186E1 00001866 9E79E619 E0E19F67
  81071E78 1F0000E0 068C19E6 C0800103
  F8E79967 C30F0000 0C30C000 3CF0C003
  00F0030F 01060000 000738C0 80031CE0
  00000060 0C30C00F F0C00003 C3030F3C
  030000F0 61CCE001 00000080 00000000
  00000000 00000000 00000000 FE010000
End DefineFont

' Read level data starting at addr
sub DecodeLevel(addr)
  local px,py,nn,i,enc,dat,blk,rle,cur
  
  math set 0,cl() ' clear it
  ' read player position
  px = RdNext(addr)
  py = RdNext(addr)

  ' read enemy positions
  nn = RdNext(addr)
  math set 99,enmy()
  for i = 0 to nn-1
    enmy(i,0) = RdNext(addr)
    enmy(i,1) = RdNext(addr)
  next i

  ' read exit ladders
  nn = RdNext(addr)
  math set 99,exla()
  for i = 0 to nn-1
    exla(i,0) = RdNext(addr)
    exla(i,1) = RdNext(addr)
  next i

  ' read reentry point - what are these?
  for i = 0 to 3
    re(i,0) = RdNext(addr) ' reentry x
    re(i,1) = RdNext(addr) ' reentry y
  next i

  ' read encrypted level layout
  enc = RdNext(addr) ' encription type
  if enc = 2 then ' grid - each nibble is one block
    ' not implemented yet
  else
    cur = 0
    do
      dat = RdNext(addr,1) ' don't move pointer
      blk = (dat and &hE0) >> 5
      rle = dat and &h1F
      
      'if blk = GOLD then inc goldcount
      if rle > 0 then
        inc addr    ' now advance pointer
        for i = 1 to rle
          if enc = 0 then ' row encoded
            x = cur mod 28
            y = cur \ 28
            cl(x,y) = blk
          else  ' enc = 1: column encoded
            x = cur \ 16
            y = cur mod 16
            cl(x,y) = blk
          endif
          inc cur
        next i
      else
        exit do
      endif
    loop
  endif

  ' enter data into level array
  cl(px,py) = 9 ' player start

  for i = 0 to NUMENEMY
    if enmy(i,0) < 99 then
      cl(enmy(i,0),enmy(i,1)) = 8
    endif
  next i

  for i = 0 to NUMEXLAD
    if exla(i,0) < 99 then
      cl(exla(i,0),exla(i,1)) = 7
    endif
  next i
end sub

' read next byte, advance pointer if i = 0
function RdNext(a,i)
  RdNext = peek(byte a\4*4 + 3 - a mod 4)
  if i then exit function
  inc a
end function

CSub Level001
00000000
0E0E0305 0617060E 09041200 12011202
12030101 09011006 1B06001F 01C11727
61271461 8A05C10B 61042261 03276122
07610422 610A6109 61042261 07C10261
02226125 04286127 02611161 09611161
0729612A 6110610A 610EC101 618A6103
C1076126 09276104 610CC109 613C0000
end csub

CSub Level002
00000000
0C0E0304 03140504 08021B04 1B051301
19020103 09080003 C1176242 2142610B
C1086205 61046129 6101C103 6201C103
61046109 6124A162 21412141 21610461
09610661 05618461 86036106 61056104
61056123 46620561 046102C1 02610962
056101C1 02612561 09614123 41224122
41610961 23612241 23410661 09610361
0241C102 41066103 86610361 01C12861
23440561 02240861 0C610E61 0C61063C
00000000
end csub

CSub Level003
00000000
0A0E0307 040F0713 09031B00 1B011B02
0C011301 0102190B 001C8A05 C10C6101
C106612A 61072561 03610A61 47056103
6106C103 610C6126 61256122 09C10261
06610561 02820524 61210661 05610482
07610461 26612206 82C10461 84610661
0A210461 07612961 09610761 29610523
612A03C1 03256124 612A0161 23610125
61210361 0B612361 02C10361 013C0000
end csub

CSub Level004
00000000
120E0306 0616060E 0A020000 00010D02
030E0D0E 180E001D 8B106105 61052101
C1012105 61056101 C1026302 C1012501
C1026302 C1016101 62026102 62076202
61026201 61016101 65016107 61016501
61016101 6102C101 C1026103 61036102
C101C102 61016102 61256103 63036125
61026103 65016202 61026201 65036109
61016501 61096104 C1046102 C101C102
6105C103 61266103 61256102 61276106
61046503 61076106 610C6107 61066107
C1046107 3C000000
end csub

CSub Level005
00000000
0F0E0418 01010504 080F0B08 09000901
09020903 09040905 09060907 00011201
04030E03 001F0EC1 0A230D24 61270222
0B220361 0A220922 046107C1 022306C1
23046103 C1032261 24052461 23612702
61032203 2203610D 61C10322 61220461
05C10561 23610461 05216122 61230561
03610E61 08610361 04C10961 08610361
27612661 25612261 0B610C61 02610B61
0C61023C 00000000
end csub

CSub Level006
00000000
0D0B0515 010A0413 08020E14 0E031200
12011202 04011801 0B040E08 0032012A
01C11021 03C10322 A1236124 61082761
22A12361 2E012302 61220461 02C10724
01230261 22612961 28012302 61226103
266125C2 210123C1 01612261 0326612E
61226103 2104C161 04C106C1 01216122
61032361 27612761 21612261 02C12361
07612761 21612261 22A12102 61076102
22036121 61226122 A1216125 6128C201
61216122 6122A121 61256126 C1266122
61046122 C1226104 C108613D 00000000
end csub

CSub Level007
00000000
090E040D 02130302 05170E03 02000201
02020B02 16030705 180E001F 11881461
06612561 21042161 23046104 C1016105
61066104 23612705 6103C102 61076107
25612402 6107610C 61066107 6109C102
6103C102 61076107 22612C61 04610124
01610261 0C6101C1 02610124 01610261
02C10961 84610121 01C12101 6127610C
61012561 07610C61 06610761 0AC10161
06613C00
end csub

CSub Level008
00000000
0E0E0605 02160202 0B0F0B19 0B080E12
0B001000 0B011001 0B021002 0B031003
0B041004 0B051005 0B061006 0B071007
0B081008 02021902 0D08040B 01036C21
032A0221 03210321 04210221 02C12102
C12103C1 A1022103 21032104 21022103
2A022103 6703A101 21038105 8104A121
03810581 05210262 05816521 022B0221
09634102 21092102 41022109 21024102
21092101 C1410221 09210241 02210963
41022102 2B022102 62058165 21038105
81052103 81058104 A1210367 03A10121
032A0221 03210321 04210221 02C12102
C12103C1 A1022103 21032104 21022103
2A022103 6C210000
end csub

CSub Level009
00000000
070F0503 0208050D 05140513 0F040000
0001010D 070D0402 06021702 1902001D
9B612105 210D2105 21610125 0F250161
01210123 0F21C123 01610125 0F250161
01230121 A1310121 01610125 A12301C1
2201C128 61210161 0125A131 61210161
0125A131 61210161 0125A124 04296121
01610125 A1240429 61210161 0125A124
03C16128 61210161 01850184 24618861
02610A45 0C610945 0D000000
end csub

CSub Level010
00000000
'      \/       \/       \/    \
090E0200 05130607 19001901 19021903
11041105 11060D00 01050F06 1906000A
C1196127 02C10DC1 03610626 072A6109
C1116126 01256122 0C610C61 042A610C
6103C12A 61274203 612E610C 61042A61
07C10183 61042206 22610722 03610422
02C20222 6105C106 61042B61 27610361
0F610728 6104C106 610F613C 00000000
end csub

' all tiles are 10 wide x 11 high
CSub Lode
00000000
000B000A ' 1 brick floor
00333333 33333333 33333300 33330033
33003333 00000000 33003300 00333333
33333333 33333300 33330033 33003333
00003333 00000000

000B000A ' 2 solid floor
33333333 33333333 33333333 33333333
33333333 33333333 33333333 33333333
33333333 33333333 33333333 33333333
00003333 00000000

000B000A ' 3 ladder
F0000FF0 000FF00F FFF00FF0 F00FFFFF
0FF0000F F0000FF0 000FF00F 0FF00FF0
F00FF000 0FFFFFFF F0000FF0 000FF00F
0FF00FF0 000FF000

000B000A ' 4 monkey bar
00000000 FFFFFF00 0000FFFF 00000000
00000000 00000000 00000000 00000000
00000000 00000000 00000000 00000000
00000000 00000000

000B000A ' 5 trap door
33333333 33333333 00003333 00000000
00FFFFFF 00FF0000 FF000000 00000000
000000FF 0000FF00 33333333 33333333
00003333 00000000

000B000A ' 6 barrel
00000000 00000000 00000000 00000000
00000000 00000000 FFF00000 C00000FF
0000CCCC 00FFFFF0 CCCCC000 FFF00000
000000FF 00000000

000B000A ' 7 exit ladder
00000FF0 000FF000 FFF00000 F00FFFFF
0FF0000F F0000000 0000000F 00000FF0
F00FF000 0FF0000F FFFFFFF0 000FF00F
0FF00000 00000000

000B000A ' 8 enemy
00010000 88800000 80000000 00000088
00008000 88888000 80088000 00008800
00000880 000FFF00 FF0FF000 0FF000FF
F0000000 0000000F

000B000A ' 9 our hero
00F00000 FF000000 0000000F 00000FFF
0000FFF0 0FFF0FF0 0FF0FF00 F0000FF0
0000000F 0000FFF0 0FF00FFF F0000000
0000000F 00000FF0
end csub

' end
