mode 1
autosave
'=============================================================================|
' PicoLander
'
' written by Vegipete, Mar 2024
'
' See below for moonscape data source
'
' needs:
' OPTION CPUSPEED 252000 (KHz)
' OPTION SYSTEM I2C GP0,GP1     ' to use Wii controller on controller port

Option DEFAULT INTEGER
Option LCDPANEL NOCONSOLE   ' print output to CDC only
MODE 1
CLS 0

' Prepare layers
FRAMEBUFFER Create   ' hidden layer to draw stuff
FRAMEBUFFER Write F : CLS 0

Device wii open

'Const LANDH = 100
Const MOONW = 948
Const HRES2 = MM.HRes/2   ' half screen width

Dim float high
Dim float moonx(MOONW),moony(MOONW),viewx(MOONW),viewy(MOONW)
For i = 0 To MOONW : moonx(i) = i : Next i

MoonRead

plax = 400
zm = 100
Do
  MoonDraw(zm/100,plax)
  FRAMEBUFFER copy F,N,B  ' copy hidden to overlay during vbl
  bp = DEVICE(wii B)
  If 4 = bp Then End
  bp = DEVICE(wii RY)
  If bp < 120 And zm > 100 Then Inc zm,-1
  If bp > 136 And zm < 999 Then Inc zm
  bp = DEVICE(wii LX)
  If bp < 120 Then
    Inc plax,-1
    If plax < 0 Then plax = MOONW
  EndIf
  If bp > 136 Then
    Inc plax
    If plax > MOONW Then plax = 0
  EndIf
Loop

' Read the moon elevation data into an array
Sub MoonRead
  Local i,h
  Restore TERAIN
  For i = 0 To MOONW
    Read moony(i)
  Next i
  h = -Math(min moony())   ' find lowest point
  Math add moony(),h,moony()  ' shift so lowest = 0

  h = Math(max moony())
  Math window moony(),h,0,moony()

  high = 350 / (2 * Math(max moony()))   ' find highest point
End Sub

'  no zoom if zoom = 1
'  zoom in if zoom > 1
Sub MoonDraw(zoom As float, xpos As float)
  Local i,xl,xr,adds,addd
  Local float x,xo,y,yo

  If zoom < 1 Then zoom = 1

  i = HRES2/zoom
  xl = xpos - i
  xr = xpos + i

  addd = Peek(VARADDR viewy())
  ' deal with source data wrap
  If xl < 0 Then  ' left edge of view from right edge of data
    Math set moony(xr),viewy()  ' initialize (right edge) of array data
    adds = Peek(VARADDR moony()) + 8 * (MOONW + xl)
    Memory COPY FLOAT adds,addd,-xl
    Inc addd,-8*xl
    adds = Peek(VARADDR moony())
    Memory COPY FLOAT adds,addd,2*i+xl
  ElseIf xr > MOONW Then  ' right edge of view from left edge of data
    Math set moony(xr-MOONW),viewy()  ' initialize (right edge) of array data
    adds = Peek(VARADDR moony()) + 8*xl
    Memory COPY FLOAT adds,addd,MOONW-xl
    Inc addd,8*(MOONW-xl)
    adds = Peek(VARADDR moony())
    Memory COPY FLOAT adds,addd,xr-MOONW
  Else
    Math set moony(xr),viewy()  ' initialize (right edge) of array data
    adds = Peek(VARADDR moony()) + 8*xl
    Memory COPY FLOAT adds,addd,2*i
  EndIf

  Math scale viewy(),zoom*high,viewy()
  y = Math(max viewy())
  Math add viewy(),400 - y,viewy()
  Math scale moonx(),zoom,viewx()

  CLS
  Line GRAPH viewx(), viewy(), RGB(white)
  Text HRES2-4,MM.VRes,"Position  Zoom",CB
  Text HRES2,MM.VRes-16,Str$(xpos,4)+"  "+Str$(zoom,4,2),CB
End Sub

' The following data table is taken from the source code for the
' original MOONLANDER game, written by Jack Burness, Feb 25, 1973
'
' For more information, visit
' <https://www.acriticalhit.com/moonlander-one-giant-leap-for-game-design/>
'
' Full source code can be found at
' <http://www.brouhaha.com/~eric/retrocomputing/
'         dec/gt40/software/moonlander/rtlem.mac>
'
' THIS TABLE HOLDS THE TERAIN OF THE MOON IN
' FEET ABOVE THE MEAN HEIGHT. IT GOES SOMEEWHAT FORWARD AND
' BACKWARD BECAUSE THE PROGRAM MAY "SCAN" A LITTLE BIT.
'
'  718 'X=-10
'  718 'X= -9
'  718 'X= -8
'  750 'X= -7
'  750 'X= -6
'  750 'X= -5
'  782 'X= -4
'  782 'X= -3
'  782 'X= -2
'  814 'X= -1
TERAIN:
Data   780,  750,  703,  650,  620,  575,  500,  420,  400,  350
Data   270,  246,  200,  180,  107,   24,   54,   53,   51,   82
Data    80,   78,  109,  107,   74,   72,   70,   69,   99,   98
Data   128,  126,  125,  123,  122,  152,  182,  174,  166,  158
Data   181,  173,  165,  156,  148,  140,  131,   91,   83,   75
Data   182,  161,  236,  120,   67,  174,  153,  197,   80,   59
Data   866,  123,  201,  250,  275,  300,  375,  410,  579,  926
Data  1832, 1907, 2013, 2119, 2257, 2395, 2533, 2639, 2745, 2883
Data  3021, 3128, 3226, 3197, 3231, 3170, 3140, 3143, 3145, 3180
Data  3246, 3153, 3252, 3286, 3353, 3387, 3390, 3424, 3523, 3429
Data  3440, 3450, 3429, 3407, 3386, 3396, 3375, 3321, 3300, 3246
Data  3257, 3203, 3182, 3128, 3107, 3085, 3064, 3074, 3085, 3095
Data  3195, 3167, 3139, 3239, 2954, 2926, 2834, 2710, 2746, 2718
Data  2753, 2469, 2569, 2509, 2513, 2580, 2584, 2620, 2720, 2820
Data  2919, 2859, 2703, 2739, 2967, 2906, 3134, 3042, 2918, 2858
Data  2759, 2468, 2498, 2399, 2396, 2362, 2071, 1940, 1970, 2063
Data  2028, 1930, 1799, 1668, 1762, 1823, 1660, 1626, 1527, 1428
Data  1650, 1615, 1676, 1770, 1703, 1636, 1666, 1599, 1436, 1402
Data  1431, 1332, 1426, 1647, 1516, 1354, 1319, 1380, 1090, 1055
Data  1148, 1146, 1207, 1172, 1202, 1071,  780,  746,  711,  933
Data  1092, 1348, 1539, 1827, 1858, 2114, 2337, 2497, 2624, 2752
Data  2847, 3007, 3166, 3422, 3581, 3709, 3964, 4124, 4315, 4443
Data  4449, 4711, 4845, 4883, 4985, 5055, 5061, 5260, 5362, 5592
Data  5726, 5860, 5994, 6160, 6259, 6422, 6584, 6715, 6877, 7008
Data  7138, 7301, 7432, 7562, 7693, 7791, 7954, 8084, 8215, 8345
Data  8400, 8678, 8765, 8851, 9033, 9152, 9366, 9388, 9539, 9945
Data 10191,10377,10659,10781,11063,11312,11370,11396,11646,11768
Data 11985,12203,12357,12607,12857,12965,13073,13117,13193,13238
Data 13282,13358,13434,13478,13555,13631,13707,13815,13923,13967
Data 14029,13996,14121,14215,14308,14466,14591,14749,14874,15000
Data 14754,14604,14326,14176,14090,13940,13662,13480,13394,13116
Data 12548,11469,10582,10015, 9160, 8960, 8696, 8432, 8200, 7936
Data  7770, 7509, 7375, 7210, 7076, 6911, 6745, 6644, 6478, 6185
Data  6019, 5758, 5656, 5491, 5261, 5096, 4867, 4712, 4398, 4020
Data  3834, 3296, 3014, 2668, 2642, 2424, 2398, 2212, 2186, 1840
Data  1828, 2008, 2156, 2272, 2356, 2312, 2268, 2224, 2276, 2328
Data  2413, 2511, 2673, 2836, 2998, 3129, 3227, 3390, 3488, 3586
Data  3717, 3879, 4010, 4108, 4239, 4369, 4531, 4694, 4824, 4987
Data  5117, 5216, 5314, 5445, 5543, 5705, 5804, 5966, 6097, 6195
Data  6294, 6392, 6522, 6685, 6815, 6914, 7076, 7239, 7337, 7436
Data  7074, 6809, 6448, 6118, 5629, 5268, 5002, 4769, 4535, 4270
Data  3909, 3515, 3108, 2796, 2389, 2077, 1509, 1326, 1078,  895
Data   583,  144,   64,  -15, -127, -114, -101,  -56,  -10,    2
Data   -15,   29,   74,   56,   69,   82,   95,   88,   49,   73
Data    34,   59,   51,   44,   68,   29,   22,   14,    7,   32
Data    85,  171,  256,  310,  460,  555,  618,  681,  776,  839
Data   870,  933,  996, 1092, 1187, 1250, 1345, 1408, 1471, 1566
Data  1597, 1628, 1692, 1755, 1818, 1881, 1944, 2007, 2070, 2133
Data  2196, 2260, 2323, 2386, 2481, 2544, 2607, 2670, 2733, 2764
Data  2828, 2859, 2922, 2985, 3080, 3111, 3174, 3237, 3300, 3396
Data  3356, 3252, 2957, 3173, 3390, 3446, 3406, 3303, 3231, 3448
Data  3142, 3156, 3107, 3089, 2944, 2835, 2726, 2617, 2476, 2367
Data  2373, 2410, 2511, 2580, 2618, 2719, 2724, 2793, 2798, 2772
Data  2740, 2709, 2645, 2614, 2582, 2551, 2519, 2488, 2456, 2425
Data  2393, 2362, 2362, 2363, 2363, 2296, 2228, 2224, 2092, 2153
Data  2032, 2072, 2144, 2248, 2128, 1976, 2016, 1864, 1936, 1912
Data  1856, 1704, 1616, 1496, 1344, 1320, 1232,  952,  992, 1032
Data  1136, 1048, 1056,  968,  688,  792,  768,  744,  624,  343
Data   298,  444,  494,  289,  211,  165,  152,   74,  156,  174
Data   225,  147,  -58,  -39,  -85, -163,  143,  449,  755,  934
Data   787,  673,  654,  636,  618,  471,  325,  403,  416,  270
Data   220,  105,   87,  101,  -13,  -63,   46,  155,  137,  183
Data   164,   50,   31,   13,  123,  104,  214,  228,  273,  287
Data   141,  250,  328,  278,  323,  401,  511,  364,  218,  200
Data   212,  160,  172,  152,  132,  112,   92,   72,   52,   63
Data    94,   93,   92,   90,   89,  120,  119,  117,  116,   83
Data    81,   80,   79,  110,  108,  139,  138,  136,  103,  134
Data   165,  131,  162,  193,  159,  185,  179,  140,  102,  128
Data   153,  147,  172,  134,  160,  153,  179,  204,  166,  160
Data   153,  179,  172,  166,  160,  153,  125,  110,   95,   80
Data    85,   82,   87,   84,   81,   86,  103,  125,  140,  152
Data   135,  130,  125,   88,   83,   46,   40,   35,   30,   25
Data    52,   47,   42,   37,   63,   61,   90,  120,  117,  115
Data   112,   78,   75,  104,   70,   67,   33,   62,   60,   57
Data    55,   52,   81,  111,  140,  138,  167,  165,  162,  192
Data   137,  179,  124,  230,  336,  377,  387,  301,  406,  288
Data   426,  467,  541,  423,  528,  506,  452,  365,  311,  193
Data   298,  436,  510,  487,  465,  347,  260,  334,  440,  417
Data   427,  341,  318,  232,  146,   27,   69,  175,  280,  258
Data   204,  277,  415,  425,  466,  412,  326,  463,  537,  547
Data   798,  665,  660,  592,  555,  646,  514,  765,  760,  755
Data   875,  994, 1081, 1136, 1223, 1311, 1398, 1485, 1604, 1691
Data  1747, 1834, 1921, 1976, 2095, 2183, 2238, 2357, 2412, 2468
Data  2422, 2440, 2523, 2381, 2336, 2380, 2392, 2404, 2449, 2493
Data  2505, 2517, 2562, 2574, 2586, 2598, 2643, 2687, 2731, 2775
Data  2849, 2890, 2932, 2781, 2759, 2832, 2810, 2787, 2509, 2742
Data  2752, 2825, 2899, 2844, 2822, 2543, 2777, 2882, 2892, 2773
Data  2879, 2792, 2770, 2747, 2629, 2670, 2391, 2497, 2570, 2804
Data  2781, 2823, 2544, 2490, 2435, 2477, 2518, 2368, 2313, 2419
Data  2524, 2502, 2479, 2553, 2562, 2540, 2549, 2591, 2664, 2386
Data  2455, 2428, 2145, 2119, 2156, 2001, 1974, 2204, 2145, 2374
Data  2476, 2456, 2425
' data added to 'smoothly' match left and right edges
Data  2393, 2362, 2362, 2363, 2363, 2296, 2228, 2224, 2092, 2153
Data  2032, 2072, 2144, 2248, 2128, 1976, 2016, 1864, 1936, 1912
Data  1856, 1704, 1616, 1496, 1344, 1320, 1232,  952,  992, 1032
Data  1136, 1048, 1056,  968,  688,  792
' mark end of data
Data  0,    0
