  '
  OPTION EXPLICIT
  OPTION DEFAULT NONE
  
  'serial line com1, 256000 baud
  const s_comspec = "com1:256000"
  const s_chan = 1                        'serial channel number
  
  'record specs
  const rec_len = 30      'length of record from radar
  const hdr_len = 4       'offset for 1st data byte in record
  const synb1 = chr$(&haa), synb2 = chr$(&hff)    'header bytes to synch on
  const syne1 = chr$(&h55), syne2 = chr$(&hcc)    'trailer bytes to synch on
  
  dim string inchar
  dim integer idx, chval, inlen, x_val_1, y_val_1, vel_1, res_1
  
  setpin gp0,gp1,com1
  open s_comspec as s_chan
  
  'synch to begin of message
  do while input$(1,s_chan) <> synb1      'synch to first char
  loop
  
  do while input$(1,s_chan) <> synb2      'synch to 2nd char
  loop
  
  do while loc(s_chan) < rec_len-2        'wait for rec_len-2 chars received
  loop
  inchar = input$(rec_len-2,s_chan)       'and throw away the rest of this message
  
  'read record by record
  do
    'wait for rec_len chars to be received
    do while loc(s_chan) < rec_len
    loop
    
    'process record
    inchar = input$(rec_len,s_chan)         'get record
    
    'calculate values
    x_val_1 = asc(mid$(inchar, hdr_len+1, 1)) + (asc(mid$(inchar, hdr_len+2, 1))<<8)    'x-value
    y_val_1 = asc(mid$(inchar, hdr_len+3, 1)) + (asc(mid$(inchar, hdr_len+4, 1))<<8)    'y-value
    vel_1 = asc(mid$(inchar, hdr_len+5, 1)) + (asc(mid$(inchar, hdr_len+6, 1))<<8)      'velocity
    res_1 = asc(mid$(inchar, hdr_len+7, 1)) + (asc(mid$(inchar, hdr_len+8, 1))<<8)      'resolution
    
    'correction of x-value to pos/neg values
    if (asc(mid$(inchar, hdr_len+2, 1)) and &h80) then
      x_val_1 = &h8000 - x_val_1
    end if
    
    'correction of y-value
    y_val_1 = y_val_1 - &h8000
    
    'correction of velocity value
    if (asc(mid$(inchar, hdr_len+6, 1)) and &h80) then
      vel_1 = &h8000 - vel_1
    end if
    
    if x_val_1 <> 0 then
      print x_val_1, y_val_1, vel_1, res_1
    end if
    
  loop
