#include <mcp_can.h>
#include <SPI.h>

long unsigned int rxId;
unsigned char len = 0;
unsigned char rxBuf[8];

unsigned long lastpoll=0;

char buffer[150];
char pointer=0;

unsigned char hb[3] = {0, 0, 0};

unsigned char stmp[8] = {0, 1, 2, 3, 4, 5, 6, 7};

MCP_CAN CAN0(10);                               // Set CS to pin 10

unsigned int txBuf[9];
unsigned char txPtr = 0;

void setup()
{
  Serial.begin(115200);
  Serial.println("CAN to Serial interface (115,200 baud)");
  // init can bus, baudrate: 500k
  if(CAN0.begin(CAN_500KBPS) == CAN_OK) Serial.println("MCP2515 init ok");
  else Serial.println("MCP2515 init failed");
  pinMode(2, INPUT);                            // Setting pin 2 for /INT input
}

// Should return 0-f; returns 255 if invalid character
unsigned char hextoval(char hexchar) {
  if (hexchar > 47 && hexchar < 58) return hexchar-48;
  if (hexchar > 64 && hexchar < 71) return hexchar-55;
  if (hexchar > 96 && hexchar < 103) return hexchar-87;
  return 255;
}

void loop()
{
  if (Serial.available() > 0) {
    char inp = Serial.read();
    if (inp==0x0d || inp==0x0a) {
      buffer[pointer]=0; // null terminate buffer
      // process line buffer here...
      bool valid=true;
      pointer=0;
      txPtr=0;
      for (int i=0; i<9; i++) {
        txBuf[i]=0;
      }
      while (buffer[pointer] != 0 && valid) {
        if (buffer[pointer]==',') {
          txPtr++;
        } else {
          int nextval = hextoval(buffer[pointer]);
          if (nextval==255) {
            valid=false;
          } else {
            txBuf[txPtr]=txBuf[txPtr]*16;
            txBuf[txPtr]=txBuf[txPtr]+hextoval(buffer[pointer]);
          }
        }
        pointer++;
      }
      if (txBuf[0]>0x7ff) valid=false;
      for (int i=1; i<=txPtr; i++) {
        stmp[i-1]=txBuf[i];
        if (txBuf[i]>0xff) valid=false;
      }
      if (valid) {
        CAN0.sendMsgBuf(txBuf[0], 0, txPtr, stmp);
        Serial.print("S");
        Serial.print(txBuf[0], HEX);
        for (int i=1; i<=txPtr; i++) {
          Serial.print(",");
          if (txBuf[i]<0x10) Serial.print("0");
          Serial.print(txBuf[i], HEX);
        }
        Serial.println();
      } else {
        Serial.println("Error");
      }
      pointer=0; // reset pointer
    } else {
      if (pointer<100) { // if pointer < buffer size, save next character otherwise ignore
        buffer[pointer]=inp;
        pointer++;
      }
    }
  }
  if(!digitalRead(2)) {                        // If pin 2 is low, read receive buffer
    CAN0.readMsgBuf(&len, rxBuf);              // Read data: len = data length, buf = data byte(s)
    rxId = CAN0.getCanId();                    // Get message ID
    Serial.print("R");
    Serial.print(rxId, HEX);
    for(int i = 0; i<len; i++) {              // Print each byte of the data
      Serial.print(",");
      if(rxBuf[i] < 0x10) {                   // If data byte is less than 0x10, add a leading zero
        Serial.print("0");
      }
      Serial.print(rxBuf[i], HEX);
    }
    Serial.println();
  }
  if (millis()-lastpoll>10000) {              // Send heartbeat approx every 10 seconds
    CAN0.sendMsgBuf(0x7ff, 0, 3, hb);
    hb[2]++;
    lastpoll = millis();
  }
}

