'
' 4 State Linear Cellular Automata Explorer for the Color Maximite 2
' By yock1960   November 2020
'
' Inspired by an article/program for Commodore 64/128 in Transactor Magazine, 
' Volume 8, Issue 6 (May 1988)
'
'

#include "chirps.inc"
#include "getfile.inc"


mode 1,8



CONST BLACK = RGB(BLACK)
CONST BLUE = RGB(BLUE)
CONST GREEN = RGB(GREEN)
CONST CYAN = RGB(CYAN)
CONST RED = RGB(RED)
CONST GREY = RGB(128,128,128)
CONST SHADOW = RGB(61,54,61)

CONST SIZE_X = 499
CONST SIZE_Y = 299
dim colors(3) = (BLACK,RED,GREEN,BLUE)
dim row%(SIZE_X), newrow%(SIZE_X), px%(SIZE_X),py%(SIZE_X),rowcode%(SIZE_X),nrcode%(SIZE_X)
dim code%(9) = (2,2,2,1,1,3,0,3,0,3)
dim seed% = 222
dim position% = SIZE_X/2
dim xofs% = 70
dim yofs% = 70
DIM xp%,yp%,oldxp%,oldyp%
DIM HaveMouse = 0
DIM p$
DIM STATE$ = "R"   'R or S for random 1st row or seed/position 1st row
dim files_flag% = 0
dim modfilename$ = ""

askmouse
setup

random
draw
splash
 

do    'main loop

  do while k$ = ""
   if HaveMouse then
    xp% = mouse(x)
    yp% = mouse(y)
    wb% = mouse(w)
    if xp% <> oldxp% or yp% <> oldyp% then
      GUI CURSOR xp%,yp%
    end if
    oldxp% = xp%
    oldyp% = yp%
    if files_flag% then
      loadsave
    end if
  end if


    k$ = inkey$ 

    if k$ = "a" or k$ = "A" then
      auto
      seedrow
      draw
    end if
    if k$ = "r" or k$ = "R" then
      random
      draw
      k$ = ""
    end if
    if k$ = "f" or k$ = "F" then
      seedrow
      draw
      k$ = ""
    end if
    if k$ = "i" or k$ = "I" then
        flash_BUTTON (mm.hres-130,425,80,25,"fIles",2)
        files_flag% = not files_flag%
    end if

    if havemouse = 0 then
      if k$ = "h" or k$ = "H" then
        text 8,MM.VRES-26,"HELP MODE - Press accelerator key or any other key to exit"+FileName$,L,,,BLACK,RGB(102,51,51)
        kh$ = ""
        do while kh$ = ""
          kh$ = inkey$

          if kh$ = "q" or kh$ = "Q" then
            RBOX 475,520,175,30,5,BLACK,BLUE
            text 485,530,"Terminates program.",L,,,BLACK,BLUE
          end if

          if kh$ = "a" or kh$ = "A" then
            autohelp
          end if

          if kh$ = "f" or kh$ = "F" then
            refreshhelp
          end if

          if kh$ = "r" or kh$ = "R" then 
            randomhelp
          end if

          if kh$ = "m" or kh$ = "M" then
            morehelp
          end if


          if kh$ = "p" or kh$ = "P" then
            positionhelp
          end if


          if kh$ = "s" or kh$ = "S" then
            seedhelp
          end if


          if kh$ = "c" or kh$ = "C" then
            codehelp
          end if

          if kh$ = "i" or kh$ = "I" then
            fileshelp
          end if

          if kh$ = "h" or kh$ = "H" then
            exit do
          end if
        loop
        text 8,MM.VRES-26,"                                                           "+FileName$,L,,,BLACK,RGB(102,51,51)
      end if
    end if

    if k$ = "c" or k$ = "C" then
      type_in_codes
    end if
    if k$ = "p" or k$ = "P" then
      type_in_position
    end if
    if k$ = "s" or k$ = "S" then
      type_in_seed
    end if
    if k$ = "m" or k$ = "M" then
      flash_BUTTON (mm.hres-130,325,80,25,"More",1)
      draw
    end if      
    if k$ = "q" or K$ = "Q" then
      if havemouse then
        GUI CURSOR OFF
        CONTROLLER MOUSE CLOSE
      end if
      credits
      CLS
      end      
    end if
    if k$ = "z" or k$ = "Z" then
      zoom
    end if
    if files_flag% then
      loadsave
    end if
  loop
  k$ = ""

loop


' Draw a pleasant box on the screen. Background is not saved!
sub MakeBox(x,y,w,h)
  rbox x    , y    , w     , h     , 10,  &h4040E0, &h4040E0  ' frame
  rbox x + 5, y + 5, w - 10, h - 10,  5,  &h202080, &h202080  ' text area
end sub


sub askmouse
  CLS
  MakeBox(120,95,550,55)
  text 290,115,"Use mouse for control (Y/N)",L,,,RGB(WHITE), &h202080
  
  do while control$ = ""
    control$ = inkey$ 
  loop 
  
  if control$ = "n" or control$ = "N" then
    Havemouse = 0
  else
    Havemouse = 1
  end if
end sub


sub random
  local i%

    for i% = 0 to SIZE_X
     rowcode%(i%) = rnd * 3
     row%(i%) = colors(rowcode%(i%))
    next

    STATE$ = "R"
end sub

sub seedrow
  local i%,tc%

  if code%(0) = 2 then
    tc% = 0
  else
    tc% = 2
  end if

  
  for i%=0 to SIZE_X
    row%(i%) = colors(code%(0))
    rowcode%(i%) = code%(0)
  next

  'erase old boxes
    box xofs%-50,150,SIZE_X+100,12,,RGB(88,70,70),RGB(88,70,70)

  if (seed% and 128) <> 0 then
    row%(position%-7) = colors(tc%)
    rowcode%(position%-7) = tc%
    box xofs%+SIZE_X*(position%/SIZE_X)-55+0*10,155,7,7,,RGB(64,64,64),colors(tc%)
  else
    box xofs%+SIZE_X*(position%/SIZE_X)-55+0*10,155,7,7,,RGB(64,64,64),colors(code%(0))
  end if

  if (seed% and 64) <> 0 then
    row%(position%-6) = colors(tc%)
    rowcode%(position%-6) = tc%
    box xofs%+SIZE_X*(position%/SIZE_X)-55+1*10,155,7,7,,RGB(64,64,64),colors(tc%)
  else
    box xofs%+SIZE_X*(position%/SIZE_X)-55+1*10,155,7,7,,RGB(64,64,64),colors(code%(0))
  end if


  if (seed% and 32) <> 0 then
    row%(position%-5) = colors(tc%)
    rowcode%(position%-5) = tc%
    box xofs%+SIZE_X*(position%/SIZE_X)-55+2*10,155,7,7,,RGB(64,64,64),colors(tc%)
  else
    box xofs%+SIZE_X*(position%/SIZE_X)-55+2*10,155,7,7,,RGB(64,64,64),colors(code%(0))
  end if

  if (seed% and 16) <> 0 then
    row%(position%-4) = colors(tc%)
    rowcode%(position%-4) = tc%
    box xofs%+SIZE_X*(position%/SIZE_X)-55+3*10,155,7,7,,RGB(64,64,64),colors(tc%)
  else
    box xofs%+SIZE_X*(position%/SIZE_X)-55+3*10,155,7,7,,RGB(64,64,64),colors(code%(0))
  end if

  if (seed% and 8) <> 0 then
    row%(position%-3) = colors(tc%)
    rowcode%(position%-3) = tc%
    box xofs%+SIZE_X*(position%/SIZE_X)-55+4*10,155,7,7,,RGB(64,64,64),colors(tc%)
  else
    box xofs%+SIZE_X*(position%/SIZE_X)-55+4*10,155,7,7,,RGB(64,64,64),colors(code%(0))
  end if

  if (seed% and 4) <> 0 then
    row%(position%-2) = colors(tc%)
    rowcode%(position%-2) = tc%
    box xofs%+SIZE_X*(position%/SIZE_X)-55+5*10,155,7,7,,RGB(64,64,64),colors(tc%)
  else
    box xofs%+SIZE_X*(position%/SIZE_X)-55+5*10,155,7,7,,RGB(64,64,64),colors(code%(0))
  end if

  if (seed% and 2) <> 0 then
    row%(position%-1) = colors(tc%)
    rowcode%(position%-1) = tc%
    box xofs%+SIZE_X*(position%/SIZE_X)-55+6*10,155,7,7,,RGB(64,64,64),colors(tc%)
  else
    box xofs%+SIZE_X*(position%/SIZE_X)-55+6*10,155,7,7,,RGB(64,64,64),colors(code%(0))
  end if

  if (seed% and 1) <> 0 then
    row%(position%) = colors(tc%)
    rowcode%(position%) = tc%
    box xofs%+SIZE_X*(position%/SIZE_X)-55+7*10,155,7,7,,RGB(64,64,64),colors(tc%)
  else
    box xofs%+SIZE_X*(position%/SIZE_X)-55+7*10,155,7,7,,RGB(64,64,64),colors(code%(0))
  end if

'  tc% = seed% and 3
'  row%(position%+2) = tc% and 3

'  tc% = seed% and 12
'  row%(position%+1) = (tc% and 12) >> 2

'  tc% = seed% and 48
'  row%(position%) = (tc% and 48) >> 4

'  tc% = seed% and 192
'  row%(position%-1) = (tc% and 192) >> 6

  STATE$ = "S"

end sub


sub draw
  local i!,j!

  if modfilename$ <> "" then
    modfilename$ = "./assets/"+modfilename$
    play modfile modfilename$,22050
  end if

   GUI CURSOR HIDE

   timer = 0
   
    math set 165,py%()
    pixel px%(),py%(),row%()


    for j! = 166 to yofs%+95+SIZE_Y-1
      nextrow
      math set j!,py%()
      pixel px%(),py%(),row%()
    next


  t2 = timer
  text 547,MM.VRES-26,LEFT$(str$(t2/1000),4)+" seconds",L,,,BLACK,RGB(102,51,51)

  if havemouse then
    GUI CURSOR SHOW
  end if

  if modfilename$ <> "" then
    play stop
  end if

end sub

sub auto
  local x%

  for x% = 0 to 9
    code%(x%) = rnd * 3
    text xofs%+7+x%*40,18,str$(code%(x%)),L,3,,colors(code%(x%)),rgb(96,96,96)
  next

end sub


sub nextrow
  local al%,aa%,ar%,idx%,x%


  nrcode%(0) = code%(rowcode%(0)+rowcode%(1))
  newrow%(0) = colors(nrcode%(0))
  

  for x% = 1 to SIZE_X-&h1
     nrcode%(x%) = code%(rowcode%(x%-1)+rowcode%(x%)+rowcode%(x%+1))
     newrow%(x%) = colors(nrcode%(x%))
  next


  nrcode%(SIZE_X) = code%(rowcode%(SIZE_X-1)+rowcode%(SIZE_X))
  newrow%(SIZE_X) = colors(nrcode%(SIZE_X))



  math scale newrow%(),1,row%()
  math scale nrcode%(),1,rowcode%()
end sub        
  
sub setup
  local x%,y%,y1%

  ' zoom box cursor
  CLS
  box 1,1,SIZE_X/2,SIZE_Y/2,,RGB(255,255,255)
  
  Sprite Read #4,0,0,SIZE_X/2+1,SIZE_Y/2+1
  CLS

  ' window background
  box 0,0,mm.hres-1,mm.vres-1,3,GREY,RGB(88,70,70)

  y% = yofs%-10
  
'  frame of plot area
'  rbox xofs%-10-15,yofs%-10+95,SIZE_X+20,SIZE_Y+20,5,&h202040,&h202040
   rbox xofs%-10,yofs%-10+95+15,SIZE_X+5,SIZE_Y+4,1,RGB(51,51,51),RGB(3,3,33)

  ' frame and text for code boxes
  rbox xofs%-10,10,412,41,5,RGB(58,77,152),GREY
  text xofs%-10,55,"Code Value",L,7,,BLACK,RGB(88,70,70)
  text xofs%-10,55,"C",L,7,,RED,RGB(88,70,70)

    
   ' code boxes with values 
  for x% = 0 to 9
    box xofs%+x%*40,15,30,30,,RGB(64,64,64),RGB(96,96,96)

    text xofs%+7+x%*40,18,str$(code%(x%)),L,3,,colors(code%(x%)),rgb(96,96,96)
  next 

 
  
  ' seed value
  rbox xofs%+9*40+30+50-5,10,70,41,5,RGB(58,77,152),GREY
  box xofs%+9*40+30+50,15,60,30,,RGB(64,64,64),RGB(96,96,96)
  text xofs%+9*40+30+55,18,str$(seed%),L,3,,BLACK,RGB(96,96,96)
  text xofs%+9*40+30+50-5,55,"Seed Value (0-255)",L,7,,BLACK,RGB(88,70,70)
  text xofs%+9*40+30+50-5,55,"S",L,7,,RED,RGB(88,70,70)




  triangle xofs%+515,28,xofs%+515+15,10,xofs%+515+30,28,RGB(129,29,29),RGB(129,29,29)
  triangle xofs%+515,32,xofs%+515+15,50,xofs%+515+30,32,RGB(129,29,29),RGB(129,29,29)

  ' position value
  rbox xofs%+9*40+30+50-5,70,70,41,5,RGB(58,77,152),GREY
  box xofs%+9*40+30+50,75,60,30,,RGB(64,64,64),RGB(96,96,96)
  text xofs%+9*40+30+55,78,str$(position%),L,3,,BLACK,RGB(96,96,96)
  text xofs%+9*40+30+50-5,115,"Seed Position (7-492)",L,7,,BLACK,RGB(88,70,70)
  text xofs%+9*40+30+50-5+5*6,115,"P",L,7,,RED,RGB(88,70,70)


  ' boxes for seed value in bits
  for x% = 0 to 7
    box xofs%+SIZE_X*(position%/SIZE_X)-55+x%*10,155,7,7,,RGB(64,64,64),RGB(96,96,96)
  next
  
   box mm.hres-154,0,150,599,3,GREY,&h202080
   BUTTON (mm.hres-130,25,80,25,"Auto",1) 
   button (mm.hres-130,125,80,25,"reFresh",3)
   BUTTON (mm.hres-130,225,80,25,"Random",1)
   BUTTON (mm.hres-130,325,80,25,"More",1)
   BUTTON (mm.hres-130,425,80,25,"fIles",2)
   BUTTON (mm.hres-130,525,80,25,"Quit",1)
  
  if HaveMouse then
    controller mouse open 2,lbutton,rbutton  
    GUI CURSOR ON
    wb% = 0
  end if

    ' setup arrays of x-positions and y-positions
    y% = 0
    for x% = xofs%-15 to xofs%-15+SIZE_X
        px%(y%)= x%
        inc y%
    next

  text 200,mm.vres-120,"~~~Press -Z- to zoom in.~~~",L,,,BLACK,RGB(88,70,70)

  ' banner
  rbox 25,mm.vres-60,550,20,5,RGB(58,77,152),GREY
  text 31,mm.vres-56,"4 State Linear Cellular Automata Explorer for the Color Maximite 2",L,1,,BLUE,GREY


  box 4,mm.vres-35,642,30,3,BLACK,RGB(102,51,51)

end sub


sub zoom
    
   
    xp% = xofs%-15+SIZE_X/4
    yp% = yofs%+95+SIZE_Y/4


    if havemouse then
      text 10,mm.vres-26,"Use middle button to select",L,,,BLACK,RGB(102,51,51)
    else
      text 10,mm.vres-26,"Use arrow keys to move, 'o' to select",L,,,BLACK,RGB(102,51,51)
    end if

      sprite show #4,xp%,yp%,1

    if havemouse then
      GUI CURSOR HIDE
      do while wb% = 0
        xp% = mouse(x)
        yp% = mouse(y)
        wb% = mouse(w) 
        if xp% > xofs%-13 and xp% < xofs%-15+SIZE_X/2 and yp% > yofs%+93 and yp% < yofs%+95+SIZE_Y/2 then
          sprite show #4,xp%,yp%,1
        end if
      loop
    else
      xp% = xofs%-15+SIZE_X/4
      yp% = yofs%+95+SIZE_Y/4
      sprite show #4,xp%,yp%,1
      do while k$ <> "o"
        k$ = inkey$
        if k$ = chr$(128) then
          if yp% > yofs%+93 then
            yp% = yp% - 5 
            sprite show #4,xp%,yp%,1
          end if
        end if    
        if k$ = chr$(129) then
          if yp% < yofs%+95+SIZE_Y/2 then
            yp% = yp% + 5 
            sprite show #4,xp%,yp%,1
          end if
        end if    
        if k$ = chr$(130) then
          if xp% > xofs%-15 then
            xp% = xp% - 5 
            sprite show #4,xp%,yp%,1
          end if
        end if    
        if k$ = chr$(131) then
          if xp% < xofs%-75+SIZE_X/2 then
            xp% = xp% + 5 
            sprite show #4,xp%,yp%,1
          end if
        end if    
        
      loop
    end if

    sprite hide #4
    text 10,mm.vres-26,"                                         ",L,,,RGB(102,51,51),RGB(102,51,51)

    image resize xp%,yp%,SIZE_X/2,SIZE_Y/2,xofs%-15,yofs%+95,SIZE_X,SIZE_Y
    if havemouse then
      GUI CURSOR SHOW
    end if
end sub

sub lbutton 


  if files_flag% = 0 then
    ' buttons
    if xp% > mm.hres-130 and xp% < mm.hres-130+80 then
      if yp% > 25 and yp% < 50 then       'auto
        flash_BUTTON (mm.hres-130,25,80,25,"Auto",1) 
        auto
        seedrow
        draw
      end if
      
      if yp% > 125 and yp% < 150 then     'refresh
        flash_button (mm.hres-130,125,80,25,"reFresh",3)
        seedrow
        draw
      end if

      if yp% > 225 and yp% < 250 then     'random
        flash_BUTTON (mm.hres-130,225,80,25,"Random",1)
        random
        draw
      end if

      if yp% > 325 and yp% < 350 then     'more
        flash_BUTTON (mm.hres-130,325,80,25,"More",1)
        draw
      end if

      if yp% > 425 and yp% < 475 then     'files
        flash_BUTTON (mm.hres-130,425,80,25,"fIles",2)
        files_flag% = not files_flag%
      end if
    
      if yp% > 525 and yp% < 550 then     ' quit
        flash_BUTTON (mm.hres-130,525,80,25,"Quit",1)
        GUI CURSOR OFF
        controller mouse close
        CLS 
        credits
        CLS
        end
      end if
    end if

    if yp% > 15 and yp% < 45 then
      code_seed_handler
    end if


    ' update position
    if yp% > 75 and yp% < 105 then
      p$ = "-1"
      if xp% > 510 and xp% < 570 then
        type_in_position
      end if
    end if

    ' type in update of seed
    if yp% > 15 and yp% < 45 then
      if xp% > 510 and xp% < 570 then
        type_in_seed
      end if
    end if
  else   'end of if not files_flag
    if xp% > mm.hres-130 and xp% < mm.hres-130+80 then    
      if yp% > 425 and yp% < 475 then     'files
        flash_BUTTON (mm.hres-130,425,80,25,"fIles",2)
        files_flag% = 0
      end if
    end if

    if xp% > mm.hres-220 and xp% < mm.hres-220+80 then    
      if yp% > 410 and yp% < 435 then     'files
        flash_BUTTON (mm.hres-220,410,80,25,"Load",1)
        files_flag% = 3
      end if
    end if

    if xp% > mm.hres-220 and xp% < mm.hres-220+80 then    
      if yp% > 440 and yp% < 465 then     'files
        flash_BUTTON (mm.hres-220,440,80,25,"Save",1)
        files_flag% = 2          
      end if
    end if

  end if
  
  
end sub

sub type_in_position

      playsounds 5,8000,8000,3000,3,1,2,3,25,25

      p$ = "0"
      do while val(p$) < 7 or val(p$) > 492
        text xofs%+9*40+30+55,78,"   ",L,3,,BLACK,RGB(96,96,96)
        text xofs%+9*40+30+60,83,"",L,3,,BLACK,RGB(96,96,96)
        input "",p$
      loop
      position% = val(p$)
      if position% > 9 then
        text xofs%+9*40+30+55,78,str$(position%),L,3,,BLACK,RGB(96,96,96)
      else
        text xofs%+9*40+30+55,78,str$(position%)+" ",L,3,,BLACK,RGB(96,96,96)
      end if
end sub

sub type_in_seed

    playsounds 5,8000,8000,3000,3,1,2,3,25,25

    p$ = "-1"
      do while val(p$) < 0 or val(p$) > 255
        text xofs%+9*40+30+55,18,"   ",L,3,,BLACK,RGB(96,96,96)
        text xofs%+9*40+30+60,23,"",L,3,,BLACK,RGB(96,96,96)
        input "",p$
      loop
      seed% = val(p$)
      text xofs%+9*40+30+55,18,str$(seed%),L,3,,BLACK,RGB(96,96,96)
end sub

sub rbutton

  ' buttons
  if xp% > mm.hres-130 and xp% < mm.hres-130+80 then
    if yp% > 25 and yp% < 50 then       'auto
      autohelp
    end if
    if yp% > 125 and yp% < 150 then     'refresh
      refreshhelp
    end if
    if yp% > 225 and yp% < 250 then     'random
      randomhelp
    end if
    if yp% > 325 and yp% < 350 then     'more
      morehelp
    end if

    if yp% > 425 and yp% < 475 then     'files
      fileshelp
    end if
    
    if yp% > 525 and yp% < 550 then     ' quit
      QUITHELP
    end if
  end if

  if yp% > 15 and yp% < 45 then
     if xp% > xofs%+(0*40) and xp% < xofs%+(9*40)+30 then
        codehelp
     end if
  end if


  ' update position
  if yp% > 75 and yp% < 105 then
    if xp% > xofs%+435 and xp% < xofs%+515 then
      positionhelp
    end if
  end if

  ' type in update of seed
  if yp% > 15 and yp% < 45 then
    if xp% > xofs%+435 and xp% < xofs%+515+30 then
      seedhelp
    end if
  end if  

end sub

sub code_seed_handler

    if xp% < xofs%+400 then
      playsounds 5,8000,8000,3000,3,1,2,3,25,25
    end if

    if xp% > xofs%+(0*40) and xp% < xofs%+(0*40)+30 then
      inc code%(0)
      if code%(0) > 3 then
        code%(0) = 0
      end if
      text xofs%+7+0*40,18,str$(code%(0)),L,3,,colors(code%(0)),rgb(96,96,96)
    end if
    
    if xp% > xofs%+(1*40) and xp% < xofs%+(1*40)+30 then
      inc code%(1)
      if code%(1) > 3 then
        code%(1) = 0
      end if
      text xofs%+7+1*40,18,str$(code%(1)),L,3,,colors(code%(1)),rgb(96,96,96)
    end if
    
    if xp% > xofs%+(2*40) and xp% < xofs%+(2*40)+30 then
      inc code%(2)
      if code%(2) > 3 then
        code%(2) = 0
      end if
      text xofs%+7+2*40,18,str$(code%(2)),L,3,,colors(code%(2)),rgb(96,96,96)
    end if

    if xp% > xofs%+(3*40) and xp% < xofs%+(3*40)+30 then
      inc code%(3)
      if code%(3) > 3 then
        code%(3) = 0
      end if
      text xofs%+7+3*40,18,str$(code%(3)),L,3,,colors(code%(3)),rgb(96,96,96)
    end if

    if xp% > xofs%+(4*40) and xp% < xofs%+(4*40)+30 then
      inc code%(4)
      if code%(4) > 3 then
        code%(4) = 0
      end if
      text xofs%+7+4*40,18,str$(code%(4)),L,3,,colors(code%(4)),rgb(96,96,96)
    end if
    
    if xp% > xofs%+(5*40) and xp% < xofs%+(5*40)+30 then
      inc code%(5)
      if code%(5) > 3 then
        code%(5) = 0
      end if
      text xofs%+7+5*40,18,str$(code%(5)),L,3,,colors(code%(5)),rgb(96,96,96)
    end if

    if xp% > xofs%+(6*40) and xp% < xofs%+(6*40)+30 then
      inc code%(6)
      if code%(6) > 3 then
        code%(6) = 0
      end if
      text xofs%+7+6*40,18,str$(code%(6)),L,3,,colors(code%(6)),rgb(96,96,96)
    end if

    if xp% > xofs%+(7*40) and xp% < xofs%+(7*40)+30 then
      inc code%(7)
      if code%(7) > 3 then
        code%(7) = 0
      end if
      text xofs%+7+7*40,18,str$(code%(7)),L,3,,colors(code%(7)),rgb(96,96,96)
    end if

    if xp% > xofs%+(8*40) and xp% < xofs%+(8*40)+30 then
      inc code%(8)
      if code%(8) > 3 then
        code%(8) = 0
      end if
      text xofs%+7+8*40,18,str$(code%(8)),L,3,,colors(code%(8)),rgb(96,96,96)
    end if

    if xp% > xofs%+(9*40) and xp% < xofs%+(9*40)+30 then
      inc code%(9)
      if code%(9) > 3 then
        code%(9) = 0
      end if
      text xofs%+7+9*40,18,str$(code%(9)),L,3,,colors(code%(9)),rgb(96,96,96)
    end if


    'seed increment/decrement
    if xp% > xofs%+515 and xp% < xofs%+515+30 then
      if yp% > 10 and yp% < 29 then
        inc seed%
        flash_arrow
        if seed% > 255 then
          seed% = 0
          text xofs%+9*40+30+55,18,str$(seed%)+"  ",L,3,,BLACK,RGB(96,96,96)  
        end if
        text xofs%+9*40+30+55,18,str$(seed%),L,3,,BLACK,RGB(96,96,96)  
      end if



      if yp% > 29 and yp% < 50 then
        inc seed%,-1
        flash_arrow
        if seed% < 100 then
          text xofs%+9*40+30+55,18,str$(seed%)+" ",L,3,,BLACK,RGB(96,96,96)  
        else if seed% < 10 then
          text xofs%+9*40+30+55,18,str$(seed%)+"  ",L,3,,BLACK,RGB(96,96,96)  
        end if
        if seed% < 0 then
          seed% = 255
        end if
        text xofs%+9*40+30+55,18,str$(seed%),L,3,,BLACK,RGB(96,96,96)  
      end if
    end if

end sub


sub loadsave
   static k1$
 
    if files_flag% then  
      page copy 0 to 1,I
    end if

    BUTTON (mm.hres-220,410,80,25,"Load",1)
    BUTTON (mm.hres-220,440,80,25,"Save",1)

    k1$ = ""

    do while k1$ = "" and files_flag% = 1
      if HaveMouse then
        xp% = mouse(x)
        yp% = mouse(y)
        wb% = mouse(w)
        if xp% <> oldxp% or yp% <> oldyp% then
          GUI CURSOR xp%,yp%
        end if
        oldxp% = xp%
        oldyp% = yp%
      end if


      k1$ = inkey$

    loop

    if k1$ = "i" or k$ = "I" then
      flash_BUTTON (mm.hres-130,425,80,25,"fIles",2)
      files_flag% = not files_flag%
    end if

    if k1$ = "s" or k1$ = "S" then
        flash_BUTTON (mm.hres-220,440,80,25,"Save",1)
        files_flag% = 2          
    end if

    if k1$ = "l" or k1$ = "L" then
        flash_BUTTON (mm.hres-220,410,80,25,"Load",1)
        files_flag% = 3
    end if

    if files_flag% = 0 then
      page copy 1 to 0,I
    end if

    if files_flag% = 2 then 'save
      save_file
      page copy 1 to 0,I
    end if

    if files_flag% = 3 then 'load
      load_file
      page copy 1 to 0,I

      update_params
    end if

    
end sub

sub update_params
  local i%

  if STATE$ = "R" then
     random
     draw
  else
     seedrow
     draw
  end if

  for i% = 0 to 9
    text xofs%+7+i%*40,18,str$(code%(i%)),L,3,,colors(code%(i%)),rgb(96,96,96)
  next
  text xofs%+9*40+30+55,18,str$(seed%),L,3,,BLACK,RGB(96,96,96)  
  text xofs%+9*40+30+55,78,str$(position%),L,3,,BLACK,RGB(96,96,96)

end sub


sub save_file
  local i%,OldFileName$="pattern",Filename$
  
    files_flag% = 0

      text 8,MM.VRES-26,"File Name to Save: "+FileName$,L,,,BLACK,RGB(102,51,51)
      text 8+160,MM.VRES-26,"",L,,,BLACK,RGB(102,51,51)


      Input "",FileName$
      if FileName$ = "" Then FileName$ = OldFileName$
      If Instr(1,FileName$,".") = 0 Then FileName$ = FileName$ + ".Dat"
      On Error Skip 1
        Open FileName$ for Output As #1
      If  MM.ERRNO = 0 Then
        text 8,MM.VRES-26,"Saving: "+FileName$+"                     ",L,,,BLACK,RGB(102,51,51)
        for i% = 0 to 9
          print #1,code%(i%)
        next
        Print #1,seed%
        Print #1,position%
        print #1,STATE$
        Close #1
      Else
        Print "File Error: ";MM.ERRNO
        Pause 2000
      End IF        
      pause 2000
end sub

sub load_file
  local i%,OldFileName$="pattern",Filename$
    files_flag% = 0

      Filename$ = Getfilename(15,"*.dat")
      if Filename$ = "" then
        exit sub
      end if

      OldFileName$ = FileName$
        Open FileName$ for Input As #1
      If MM.ERRNO = 0 Then
        text 8,MM.VRES-26,"Loading: "+Filename$,L,,,BLACK,RGB(102,51,51)
        for i% = 0 to 9
          input #1,code%(i%)
        next
        input #1,seed%
        input #1,position%
         input #1,STATE$
        Close #1
      End if

end sub

sub type_in_codes
  local i%

    playsounds 5,8000,8000,3000,3,1,2,3,25,25

    for i% = 0 to 9
      get_codes i%
    next
    
end sub

sub get_codes c%

      p$ = "-1"
      do while val(p$) < 0 or val(p$) > 3
        text xofs%+7+c%*40,18," ",L,3,,colors(code%(c%)),rgb(96,96,96)
        text xofs%+7+c%*40,23,"",L,3,,BLACK,rgb(96,96,96)
        input "",p$
      loop
      code%(c%) = val(p$)
      box xofs%+c%*40,15,30,30,,RGB(64,64,64),RGB(96,96,96)
      text xofs%+7+c%*40,18,str$(code%(c%)),L,3,,colors(code%(c%)),rgb(96,96,96)

end sub



sub BUTTON (xpos%,ypos%,width%,height%,title$,acc%)

  rbox xpos%+5,ypos%+5,width%,height%,5,Shadow,Shadow
  rbox xpos%,ypos%,width%,height%,5,Grey,Grey
  text xpos%+5,ypos%+5,title$,L,4,,WHITE,Grey
  text xpos%+5+(acc%-1)*10,ypos%+5,mid$(title$,acc%,1),L,4,,RED,Grey
  
end sub

sub FLASH_BUTTON (xpos%,ypos%,width%,height%,title$,acc%)

  rbox xpos%+5,ypos%+5,width%,height%,5,Shadow,Shadow
  rbox xpos%,ypos%,width%,height%,5,WHITE,WHITE
  text xpos%+5,ypos%+5,title$,L,4,,GREY,WHITE
  text xpos%+5+(acc%-1)*10,ypos%+5,mid$(title$,acc%,1),L,4,,Grey,RED

  playsounds 6,300,2400,200,3,1,1,3,25,10

  rbox xpos%+5,ypos%+5,width%,height%,5,Shadow,Shadow
  rbox xpos%,ypos%,width%,height%,5,Grey,Grey
  text xpos%+5,ypos%+5,title$,L,4,,WHITE,Grey
  text xpos%+5+(acc%-1)*10,ypos%+5,mid$(title$,acc%,1),L,4,,RED,Grey

  play stop  
  
end sub

sub flash_arrow

  playsounds 1,300,2000,500,20,2,1,5,25,10

  play stop  
  
end sub


sub splash

    page copy 0 to 1,I
    rbox 100,100,600,400,10,&h202040,&h202080
    rbox 110,110,580,380,10,&h202080,&h202040
    text 120,120,"While many people are familiar with Conway's Game of life, there are ",L,,,RGB(WHITE),&h202040
    text 120,132,"other types of Cellular Automata, this program is an example of one of",L,,,RGB(WHITE),&h202040
    text 120,144,"them. Like 'Life', there are rules of inheritance for adjoining cells",L,,,RGB(WHITE),&h202040
    text 120,156,"but instead of 2 dimensional, 360 degree inheritance, each line or ",L,,,RGB(WHITE),&h202040
    text 120,168,"generation, inherits from the previous one, based on rules. The",L,,,RGB(WHITE),&h202040
    text 120,180,"rules in this case are: each cell inherits from the 3 cells directly",L,,,RGB(WHITE),&h202040
    text 120,192,"above, above left & above right. The sums of the values contained in",L,,,RGB(WHITE),&h202040
    text 120,204,"these 'ancestor' cells are an index into a inheritance rule or code ",L,,,RGB(WHITE),&h202040
    text 120,216,"and the new cell 'inherits' that state or value, each new line or   ",L,,,RGB(WHITE),&h202040
    text 120,228,"generation, inheriting from the one before. Initial generations can be",L,,,RGB(WHITE),&h202040
    text 120,240,"randomly generated or can be selectively placed by using a 'seed'",L,,,RGB(WHITE),&h202040
    text 120,252,"positioned at certain locations along the first row/generation.",L,,,RGB(WHITE),&h202040
    text 120,264,"A seemingly limitless number of intersting and often, colorful",L,,,RGB(WHITE),&h202040
    text 120,276,"patterns result, by changing the inheritance rules and starting",L,,,RGB(WHITE),&h202040
    text 120,288,"conditions.",L,,,RGB(WHITE),&h202040
    text 120,312,"Program functionality is pretty straightforward, left click to activate",L,,,RGB(WHITE),&h202040
    text 120,324,"or right click on a UI object for help, right click again to dismiss.",L,,,RGB(WHITE),&h202040
    text 120,348,"Keyboard only users may use Key commands, UI object names contain an",L,,,RGB(WHITE),&h202040
    text 120,360,"accelerator key that denotes the command character. To get help in ",L,,,RGB(WHITE),&h202040
    text 120,372,"keyboard mode, press the -H- key, then press the accelerator key,",L,,,RGB(WHITE),&h202040
    text 120,384,"any other key will dismiss or exit HELP mode.",L,,,RGB(WHITE),&h202040
    text 120,408,"This program was inspired by an article/program in Transactor Magazine",L,,,RGB(WHITE),&h202040
    text 120,420,"Volume 8, Issue 6 (May 1988),for the Commodore 64 & 128.",L,,,RGB(WHITE),&h202040
    text 120,444,"Press any key to continue...",L,,,RGB(YELLOW),&h22080

    playsounds 12,2200,1500,400,20,1,1,6,25,10



    do while inkey$ = ""
    loop
    
    page copy 1 to 0,I
  
end sub

sub credits

    playsounds 12,2200,1500,400,20,1,1,6,25,10

    CLS

    rbox 90,100,620,400,10,&h202040,&h202080
    rbox 100,110,600,380,10,&h202080,&h202040
    text 110,120,"This Cellular Automata Explorer for the Color Maximite 2 was created  ",L,,,RGB(WHITE),&h202040
    text 110,132,"by yock1960.",L,,,RGB(WHITE),&h202040
    text 110,144,"",L,,,RGB(WHITE),&h202040
    text 110,156,"Many thanks to Geoff and Peter for creating this system and also thanks",L,,,RGB(WHITE),&h202040
    text 110,168,"the community over at TheBackShed.com! Special thanks to users: vegipete,",L,,,RGB(WHITE),&h202040
    text 110,180,"(GetFileDialog), capsikin (Chirps) and Sasquatch (for letting me cut my ",L,,,RGB(WHITE),&h202040
    text 110,192,"teeth on modding his Mandelbrot16 app!",L,,,RGB(WHITE),&h202040
    text 120,444,"Press any key to continue...",L,,,RGB(YELLOW),&h22080

    do while inkey$ = ""
    loop


end sub


sub help
    local k$

      page copy 0 to 1,I

      
      do while k$ <> "h" or k$ <> "H"
        k$ = inkey$
      loop
      
      page copy 1 to 0,I

end sub

SUB quithelp
    static qhflag%

    if not qhflag% then
      qhflag% = 1
      page copy 0 to 1,I
      RBOX 475,520,175,30,5,BLACK,BLUE
      text 485,530,"Terminates program.",L,,,BLACK,BLUE
      if not havemouse then
        do while inkey$ = ""
        loop
        qhflag% = 0
        page copy 1 to 0,I
      end if
    else if qhflag% = 1 then
      qhflag% = 0
      page copy 1 to 0,I
    end if
end sub

sub autohelp
    static ahflag%

    if not ahflag% then
      ahflag% = 1
      page copy 0 to 1,I
      RBOX 450,20,200,70,5,BLACK,BLUE
      text 460,28,"Generates a new, random",L,,,BLACK,BLUE
      text 460,40,"inheritance 'Code' and",L,,,BLACK,BLUE
      text 460,52,"plot it using current",L,,,BLACK,BLUE
      text 460,64,"seed and position.",L,,,BLACK,BLUE
      if not havemouse then
        do while inkey$ = ""
        loop
        ahflag% = 0
        page copy 1 to 0,I
      end if
    else if ahflag% = 1 then
      ahflag% = 0
      page copy 1 to 0,I
    end if

end sub

sub randomhelp
  static rhflag%

    if not rhflag% then
      rhflag% = 1
      page copy 0 to 1,I
      RBOX 400,200,250,80,5,BLACK,BLUE
      text 410,210,"Generates a random 1st row",L,,,BLACK,BLUE
      text 410,222,"or generation, independant" ,L,,,BLACK,BLUE
      text 410,234,"of 'rules' and then plots",L,,,BLACK,BLUE
      text 410,246,"298 generations, according",L,,,BLACK,BLUE
      text 410,258,"existing inheritance code.",L,,,BLACK,BLUE
      if not havemouse then
        do while inkey$ = ""
        loop
        rhflag% = 0
        page copy 1 to 0,I
      end if
    else if rhflag% = 1 then
      rhflag% = 0
      page copy 1 to 0,I
    end if
end sub

sub morehelp
  static mhflag%

    if not mhflag% then
      mhflag% = 1
      page copy 0 to 1,I
      RBOX 425,300,225,70,5,BLACK,BLUE
      text 435,310,"Generates an additional",L,,,BLACK,BLUE
      text 435,322,"298 generations, starting" ,L,,,BLACK,BLUE
      text 435,334,"with the last generation,",L,,,BLACK,BLUE
      text 435,346,"using the existing code.",L,,,BLACK,BLUE
      if not havemouse then
        do while inkey$ = ""
        loop
        mhflag% = 0
        page copy 1 to 0,I
      end if
    else if mhflag% = 1 then
      mhflag% = 0
      page copy 1 to 0,I
    end if
end sub

sub positionhelp
  static phflag%

    if not phflag% then
      phflag% = 1
      page copy 0 to 1,I
      RBOX 280,70,225,60,5,BLACK,BLUE
      text 290,80,"Position in 1st row to ",L,,,RGB(YELLOW),BLUE
      text 290,92,"place the initial 'seed'" ,L,,,RGB(YELLOW),BLUE
      text 290,104,"values.",L,,,RGB(YELLOW),BLUE
      if not havemouse then
        do while inkey$ = ""
        loop
        phflag% = 0
        page copy 1 to 0,I
      end if
    else if phflag% = 1 then
      phflag% = 0
      page copy 1 to 0,I
    end if
end sub

sub seedhelp
  static shflag%

    if not shflag% then
      shflag% = 1
      page copy 0 to 1,I
      RBOX 280,20,225,70,5,BLACK,BLUE
      text 290,30,"Seed values turn on/off",L,,,RGB(YELLOW),BLUE
      text 290,42,"4 cells in 1st row, based" ,L,,,RGB(YELLOW),BLUE
      text 290,54,"on the 4 bit pairs in this",L,,,RGB(YELLOW),BLUE
      text 290,66,"8 bit number.",L,,,RGB(YELLOW),BLUE

      if not havemouse then
        do while inkey$ = ""
        loop
        shflag% = 0
        page copy 1 to 0,I
      end if
    else if shflag% = 1 then
      shflag% = 0
      page copy 1 to 0,I
    end if
end sub

sub codehelp
  static chflag%

    if not chflag% then
      chflag% = 1
      page copy 0 to 1,I
      RBOX 80,80,270,120,5,BLACK,BLUE
      text 90,92,"Each digit (0-3) in the code",L,,,RGB(YELLOW),BLUE
      text 90,104,"represent colors: black, green" ,L,,,RGB(YELLOW),BLUE
      text 90,116,"red and blue. The 3 parent cells",L,,,RGB(YELLOW),BLUE
      text 90,128,"above-left,center and right,",L,,,RGB(YELLOW),BLUE
      text 90,140,"are summed and used as an index",L,,,RGB(YELLOW),BLUE
      text 90,152,"into the code, to determine",L,,,RGB(YELLOW),BLUE
      text 90,164,"the descendant cell's color.",L,,,RGB(YELLOW),BLUE

      if not havemouse then
        do while inkey$ = ""
        loop
        chflag% = 0
        page copy 1 to 0,I
      end if
    else if chflag% = 1 then
      chflag% = 0
      page copy 1 to 0,I
    end if
end sub


sub refreshhelp
    static fhflag%

    if not fhflag% then
      fhflag% = 1
      page copy 0 to 1,I
      RBOX 450,100,200,60,5,BLACK,BLUE
      text 457,110,"Refreshes plot using",L,,,BLACK,BLUE
      text 457,122,"the current inheritance",L,,,BLACK,BLUE
      text 457,134,"code, seed and position.",L,,,BLACK,BLUE
      if not havemouse then
        do while inkey$ = ""
        loop
        fhflag% = 0
        page copy 1 to 0,I
      end if
    else if fhflag% = 1 then
      fhflag% = 0
      page copy 1 to 0,I
    end if

end sub

sub fileshelp
    static ihflag%

    if not ihflag% then
      ihflag% = 1
      page copy 0 to 1,I
      RBOX 450,400,200,80,5,BLACK,BLUE
      text 457,410,"Loads or saves codes",L,,,BLACK,BLUE
      text 457,422,"seed, position and",L,,,BLACK,BLUE
      text 457,434,"seeded or random,",L,,,BLACK,BLUE
      text 457,446,"for easy recall!",L,,,BLACK,BLUE
      
      if not havemouse then
        do while inkey$ = ""
        loop
        ihflag% = 0
        page copy 1 to 0,I
      end if
    else if ihflag% = 1 then
      ihflag% = 0
      page copy 1 to 0,I
    end if

end sub



sub checkmouse
    xp% = mouse(x)
    yp% = mouse(y)
    wb% = mouse(w)
    if xp% <> oldxp% or yp% <> oldyp% then
      GUI CURSOR xp%,yp%
    end if
    oldxp% = xp%
    oldyp% = yp%
end sub

 
