' Chipsound library routimes by "capsikin"
' modified by yock1960 for inclusion in other programs.
' see the Welcome tape /sound/chirps/chirps-ui.bas
' for use as a 'sound designer', plug in values for bleeps, chirps, etc.
'
dim steps
dim f1
dim f2
dim v1
dim v2
dim steptime
dim ft
dim rfn

dim sets
dim f3


dim max_freq!=20000
dim min_freq=1
dim max_param=max_freq!

dim max_vol=25
dim min_vol=1


'playsounds 6,200,2900,1500,8,1,1,2,25,10
'pause(50)
'playsounds 6,300,2400,200,3,1,1,3,25,10
'playsounds 12,2200,1500,400,20,1,1,6,25,10


sub playsounds steps,f1,f2,f3,steptime,ft,rfn,sets,v1,v2
  local j, i

  static transitions=steps-1

  steps=MAX(1,steps)
  sets=MAX(1,sets)

  local fs(steps)
  local vs(steps)
  local f_comp(steps)

  local fss(sets,steps)
  local fss_comp(sets,steps)

'  v1=MAX(1,v1)
'  v2=MAX(1,v2)

'  v1=MIN(max_vol,v1)
'  v2=MIN(max_vol,v2)


  interpolate vs(),v1,v2,steps

'  f1=MAX(1,f1)
'  f2=MAX(1,f2)
'  f3=MAX(1,f3)

if ft=3 then
  interpolate f_comp(),1/f1,1/f2,steps
  for i=1 to steps
    fs(i)=1/f_comp(i)
  next
else if ft=2 then
  interpolate f_comp(),LOG(f1),LOG(f2),steps
  for i=1 to steps
    fs(i)=EXP(f_comp(i))
  next
else
  interpolate fs(),f1,f2,steps
end if

  static  f_comp1
  static  f_comp2
  static  f_comp3

'f1=MIN(max_freq,f1)
'f2=MIN(max_freq,f2)
'f3=MIN(max_freq,f3)

if ft=3 then
  f_comp1=1/f1
  f_comp2=1/f2
  f_comp3=1/f3
else if ft=2 then
  f_comp1=LOG(f1)
  f_comp2=LOG(f2)
  f_comp3=LOG(f3)
else
  f_comp1=f1
  f_comp2=f2
  f_comp3=f3
end if

'no, change with f_comp1
interpolate2 fss_comp(),f_comp1,f_comp2,f_comp3,steps,sets

for j=1 to sets
  for i=1 to steps
    if ft=3 then
      if fss_comp(j,i) < 1/max_freq! then
        fss_comp(j,i) = 1/max_freq!
      endif

      fss(j,i)=1/fss_comp(j,i)

    else if ft=2 then
      fss(j,i)=EXP(fss_comp(j,i))
    else if ft=1 then
      fss(j,i)=fss_comp(j,i)
    else
      print "ft unknown";ft
    end if
    fss(j,i)=MAX(1,fss(j,i))
    fss(j,i)=MIN(max_freq!,fss(j,i))
  next
next

if rfn=1 then
  for i=1 to steps
    fs(i)=fixcycles(fs(i),steptime)
  next
end if

if rfn=1 then
  for j=1 to sets
    for i=1 to steps
      fss(j,i)=fixcycles(fss(j,i),steptime)
    next
  next
end if


for j=1 to sets
  for i=1 to steps
    play sound 1,B,q,fss(j,i),vs(i)
    pause steptime
  next
next

play sound 1,B,O,300

end sub


function fixcycles(freq,t)
  'new value for freq that gives a whole number of cycles in time t.
  'integer number of cycles
  local cycles%
 
  cycles% = freq * t / 1000
  if cycles% < 1 then cycles%=1
  fixcycles=cycles% * 1000 / t
end function

sub interpolate a(),val1,val2,num
  local transitions, i

  transitions=num-1
  if transitions > 0 then local dval=(val2-val1)/transitions
  for i=0 to transitions
    a(i+1)=val1+dval*i
  next
end sub

sub interpolate2 a(),val1,val2,val3,num,num2
  local transitions, transitions2, j, i

  transitions=num-1
  transitions2=num2-1

  if transitions > 0 then local dval=(val2-val1)/transitions
  if transitions2 > 0 then local dval2=(val3-val1)/transitions2
  for j=0 to transitions2
    for i=0 to transitions
      a(j+1,i+1)=val1+dval*i+dval2*j
    next
  next
end sub
