' ThatDiceGame.bas - coded by yock1960, 2021, for the CMM2
'
' otherwise known as Yhatzee in the USA, unknown names worldwide. Players roll 5 dice
' and try to make poker like combos, such as full house, small & large straights. 3 & 4 of a kind
' and the 'impossible in poker' 5 of a kind or 'Yahtzee!'.
'
'
#include "chirps.inc"

option explicit
option base 0
option default integer

const TRUE = 1
const FALSE = 0

CONST GREY = RGB(128,128,128)
CONST SHADOW = RGB(61,54,61)
CONST WHITE = RGB(255,255,255)
CONST BLACK = RGB(BLACK)
CONST BLUE = RGB(BLUE)
CONST GREEN = RGB(GREEN)
CONST CYAN = RGB(CYAN)
CONST RED = RGB(RED)

const COMPUTER = 0
const PLAYER1 = 1
const PLAYER2 = 2

'top scores
const UPPER = 0
const ONES = 1
const TWOS = 2
const THREES = 3
const FOURS = 4
const FIVES = 5
const SIXES = 6
const UPPER_SUB = 7
'top bonus if goal is reached
const BONUS = 8
const UPPER_TOT = 9
const LOWER = 10
'bottom scores
const KIND3 = 11
const KIND4 = 12
const FHOUSE = 13
const SSTRAIGHT = 14
const LSTRAIGHT = 15
const YAHTZEE = 16
const CHANCE = 17
const BINGO_BONUS = 18
const LOWER_SUB = 19
const UPPER_T2 = 20
const GRAND_TOT = 21
const bingo_count = 22

const BONUS_GOAL = 63

const UNUSED = -1
const ROUNDS = 12

DIM HaveMouse = FALSE
dim HaveClassic = FALSE
dim HaveNunchuk = FALSE
dim Keyboard = FALSE
dim channel = UNUSED
dim errno

dim player = PLAYER1           'player is always PLAYER1
dim opponent = COMPUTER        'PLAYER2 for two human players

dim scores(PLAYER2,bingo_count)      'scores(2,22) last score is number of Bingos
dim tmpscores(PLAYER2,bingo_count)   'storage for potential score values
dim total(PLAYER2)                   'totals(2)
dim topscore(PLAYER2)
dim whosturn
dim round = 0
dim roll = 1
dim scorethat(CHANCE)
dim wastethat(CHANCE)
dim score_flg = FALSE
dim qr_flag = FALSE

' TRUE means roll that die on next throw, FALSE means do not roll
dim DIE_1 = TRUE
dim DIE_2 = TRUE
dim DIE_3 = TRUE
dim DIE_4 = TRUE
dim DIE_5 = TRUE

dim Bingo_flg = FALSE
dim KIND4_flg = FALSE
dim KIND3_flg = FALSE
dim FULL_flg = FALSE

' array to track whether die is to be rolled or not
dim dice(4) = (DIE_1,DIE_2,DIE_3,DIE_4,DIE_5)
' actual die roll values
dim dice_roll(4) = (0,0,0,0,0)
' array to store sorted die values
dim sorted(4) 
' value of lowest die rolled
dim low_die, alldie
dim nxt_low_die
dim low_die_three
dim row_headings$(24)
dim wb%,xp%,yp%,oldxp%,oldyp%
dim XMax = MM.HRES - 1
dim YMax = MM.VRES - 1
dim xchuk,ychuk
dim key$

xp% = 100
yp% = 100

headings:
data "Player","Upper Section","Ones","Twos","Threes","Fours","Fives","Sixes","Sub Total","Bonus"
data "Upper Total","Lower Section","3 of a kind","4 of a kind","Full House","Sm. Straight"
data "Lg. Straight","Bingo","Chance","Bingo Bonus","Lower Total","Upper Total","Grand Total"


mode 1,16


MMDEBUG OFF

check_firmware

main

sub main()
  local i,j

  draw_dice

  AskPlayers

  NewGame

  draw_new_sheet

  SelectInputDevice   

  GUI CURSOR LOAD "MOUSE3.SPR"
  GUI CURSOR ON 2
  
  do 

  key$ = inkey$ 
  
   if HaveMouse then
      xp% = mouse(x,channel)
      yp% = mouse(y,channel)
      wb% = mouse(w,channel)
   end If

   
' update cursor, mouse only, Wii Classic handled in sub pollclassic
  if havemouse or keyboard then
    if xp% <> oldxp% or yp% <> oldyp% then
      GUI CURSOR xp%,yp% 
    end if
    oldxp% = xp%
    oldyp% = yp%
  end if

  if key$ = "q" or key$ = "Q" then 
    if havemouse then
      controller mouse close
    else if haveclassic then
      controller classic close
    end if
    end
  end if

  if Keyboard then


    if whosturn = PLAYER1 then
      j = 0
    else 
      j = 400
    end if


    select case key$

      case "r","R"
        xp% = 95+j
        yp% = 130
        lbutton
      case "s","S"
        xp% = 95+j
        yp% = 130
        lbutton
      case "1","2","3","4","5"
        if roll > 1 then
          i = val(key$)*50
          xp% = 118+j+i
          yp% = 140
          lbutton
        end if
      case "u","U"
        if score_flg then
          xp% = 221+j
          yp% = 265  
        end if
      case "l","L"
        if score_flg then
          xp% = 221+j
          yp% = 460        
        end if
      case chr$(129)
        yp% = yp% + 20
        if yp% > mm.vres then 
          yp% = mm.vres
        end if
      case chr$(128)
        yp% = yp% - 20
        if yp% < 0 then 
          yp% = 0
        end if
      case chr$(131)
        xp% = xp% + 20
        if xp% > mm.hres then 
          xp% = mm.hres
        end if
      case chr$(130)
        xp% = xp% - 20
        if xp% < 0 then 
          xp% = 0
        end if
      case chr$(32)
        lbutton

  end select

end if

  if key$ = "h" or key$ = "H" then
    show_help
  end if
  


  loop

  
end sub

sub SelectInputDevice
  local i,d

  for i = 0 to 3
    on error skip
    controller mouse open i,lbutton,rbutton
    if mm.errno > 0 then
      next
    else
      channel = i
      HaveMouse = TRUE
      exit for
    end if

  if channel > -1 then exit sub

  for i = 0  to 3
    on error skip
    controller nunchuk open i,lbutton,rbutton  
    if mm.errno > 0 then
      next
    else
      on error skip
      errno = nunchuk(t,i)
      if errno <> &Ha4200000 then
          HaveClassic = TRUE
          controller nunchuk close
          controller classic open i,cbutton
          settick 7,pollclassic,1
          channel = i
          exit for
      else if errno = &ha4200000 then
        channel = i
        HaveNunchuk = TRUE
        settick 7,pollclassic,1
        exit for     
      end if
    end if

  if channel > -1 then exit sub

  keyboard = TRUE

end sub


     



sub show_help
    gui cursor hide
    page copy 0 to 1

    MakeBox(120,150,520,290)

      text 170,170,"Each player gets 3 rolls of the dice per turn, select",L,,,RGB(WHITE),&h202080
      text 170,182,"the dice that you wish to re-roll by clicking on those",L,,,RGB(WHITE),&h202080
      text 170,194,"dice. After the 3rd roll or whenever you choose, select",L,,,RGB(WHITE),&h202080
      text 170,208,"an individual 'score' box, then click score to record",L,,,RGB(WHITE),&h202080
      text 170,220,"and end turn. Re-clicking a 'score' box de-selects it.",L,,,RGB(WHITE),&h202080
      text 170,232,"Red 'score' boxes are for recording a 'zero', when you",L,,,RGB(WHITE),&h202080
      text 170,244,"have no other choice, or want to waste a score to keep",L,,,RGB(WHITE),&h202080
      text 170,256,"another 'score' available.",L,,,RGB(WHITE),&h202080
      text 170,278,"Having a score >= 63 in the upper section earns an",L,,,RGB(WHITE),&h202080
      text 170,290,"additional 'bonus' of 35 points and is important!",L,,,RGB(WHITE),&h202080
      text 170,302,"A roll of 5 identical dice is a BINGO, AKA Yahtzee",L,,,RGB(WHITE),&h202080
      text 170,314,"and earns 50 points, each additional BINGO that can",L,,,RGB(WHITE),&h202080
      text 170,326,"be played in another place, earns an additional bonus",L,,,RGB(WHITE),&h202080
      text 170,338,"of 100 points, up to 3 additionl times....so don't",L,,,RGB(WHITE),&h202080
      text 170,350,"waste your BINGO too soon, as once it's 'wasted'",L,,,RGB(WHITE),&h202080
      text 170,362,"no bonus can be earned!",L,,,RGB(WHITE),&h202080
      text 170,386,"Press any key to continue...",L,,,RGB(WHITE),&h202080

    do while inkey$ = ""
    loop

    page copy 1 to 0

    MakeBox(120,150,520,290)

      text 170,170,"If you are using the keyboard to control play, press",L,,,RGB(WHITE),&h202080
      text 170,182,"the 'r' key to roll. After rolling, the number keys,",L,,,RGB(WHITE),&h202080
      text 170,194,"1 thru 5, select/deselect dice to be re-rolled.",L,,,RGB(WHITE),&h202080
      text 170,206,"After 3 rolls (ie. the 'Score' button is showing),",L,,,RGB(WHITE),&h202080
      text 170,218,"Pressing the 'U' key will move the cursor to the upper",L,,,RGB(WHITE),&h202080
      text 170,230,"section score boxes and the cursor keys can then be",L,,,RGB(WHITE),&h202080
      text 170,242,"used to move to the desired score, then press the",L,,,RGB(WHITE),&h202080
      text 170,254,"spacebar to select/deselect it. The 'L' key will move",L,,,RGB(WHITE),&h202080
      text 170,266,"the cursor to the lower section. Once the desired",L,,,RGB(WHITE),&h202080
      text 170,278,"score has been selected, pressing the 'S' key will",L,,,RGB(WHITE),&h202080
      text 170,290,"record the score and 'hand' the dice over to the",L,,,RGB(WHITE),&h202080
      text 170,302,"other player!",L,,,RGB(WHITE),&h202080
      text 170,386,"Press any key to dismiss...",L,,,RGB(WHITE),&h202080

    do while inkey$ = ""
    loop


    page copy 1 to 0
    gui cursor show

end sub
  

sub cbutton

' Wii Classic B button
  if classic(B) and 8192 then
    lbutton
  end if

' A button
  if classic(B) and 2048 then
    rbutton
  end if

end sub

sub game_over_handler()

  if scores(player,grand_tot) > scores(opponent,grand_tot) then
    play tts "pleher whun whihns",64,72
    MakeBox(30,345,200,60)
    text 50,365,"Winner!",L,5,,RGB(RED),&h202080
  else
    play tts "pleher tu whihns",64,72
    MakeBox(430,345,200,60)
    text 450,365,"Winner!",L,5,,RGB(RED),&h202080
  end if  
  gui cursor hide
  button (90,127,50,22,"Rematch",1,7)
  gui cursor show
  button (490,127,50,22,"Quit",1,1)
  MakeBox(120,225,550,55)
  text 290,245,"Use right button to choose",L,,,RGB(WHITE), &h202080
  
  qr_flag = TRUE        
  
end sub

sub pollclassic
      if HaveClassic then
          xchuk = classic(lx)
          ychuk = classic(ly)
       else
        xchuk = nunchuk(jx)
        ychuk = nunchuk(jy)
      end if

     If XChuk > 140 Then 
      xp% = xp% + ((XChuk - 140) / 250) + 1
     end if
     If xp% > XMax Then xp% = XMax
     If XChuk < 116 Then xp% = (xp% - (116 - XChuk) / 250) - 1
     If xp% < 0 Then xp% = 0
     If YChuk > 140 Then yp% = yp% - ((YChuk - 140) / 250) - 1
     If yp% < 0 Then yp% = 0
     If YChuk < 115 Then yp% = yp% + ((115 - YChuk) / 250) + 1
     If yp% > YMax Then yp% = YMax
     If xp% <> oldxp% or yp% <> oldyp% Then
       oldxp% = xp% : oldyp% = yp%
       GUI CURSOR XP%,YP%
     end if

end sub

sub pollkeyboard
     If xp% <> oldxp% or yp% <> oldyp% Then
       oldxp% = xp% : oldyp% = yp%
'       GUI CURSOR XP%,YP%
    end if
end sub

sub lbutton
  local i,j,n,what

  if whosturn = PLAYER1 then
    i = 0
  else 
    i = 400
  end if


  if whosturn = computer then
  end if

  if qr_flag then
    exit sub
  end if
  

' handle Roll and Score buttons 
  if xp% > 90+i and xp% < 140+i then
    if yp% > 127 and yp% < 149 then
      what = check_selected()
      if what = -1 then
        what = check_wasted()
      end if
      if score_flg and what <> -1 then
         for n = 1 to 17
          text 160+i,(n+1)*20+139,"    ",L,,,RGB(NOTBLACK),RGB(GREEN)
          box 155+i+60,(n+1)*20+139,10,10,,RGB(GREEN),RGB(GREEN)
          box 300+i+60,(n+1)*20+139,10,10,,RGB(GREEN),RGB(GREEN)
         next
         
         if what = YAHTZEE then
            scores(whosturn,bingo_count) = scores(whosturn,bingo_count) + 1
         else if bingo_flg and scores(whosturn,YAHTZEE) = 50 then
            scores(whosturn,bingo_count) = scores(whosturn,bingo_count) + 1
         end if


  
         updatescore(whosturn,what)                   

         if whosturn = PLAYER1 then 
           round = round + 1
           if round > 13 then   'game over
             game_over_handler()
             exit sub
           end if
         end if
 
         blit write #13,90+i,127
         blit write #12,155+i,127 

         if whosturn = PLAYER1 then
            whosturn = opponent
            i = 400
         else
            whosturn = PLAYER1
            i = 0
         end if
         roll = 1
         score_flg = FALSE
         button (90+i,127,50,22,"Roll",1,4)
         for j = 0 to 4
          dice(j) = TRUE
         next 
      else if score_flg and what = -1 then
         flash_button (90+i,127,50,22,"Score",1,1)
      else
      ' roll button pushed
        flash_button (90+i,127,50,22,"Roll",1,4)
         for n = 1 to 17
          if scores(whosturn,n) = -1 then
            text 160+i,(n+1)*20+139,"    ",L,,,RGB(NOTBLACK),RGB(GREEN)
            box 155+i+60,(n+1)*20+139,10,10,,RGB(GREEN),RGB(GREEN)
          end if
         next

        if roll <= 3 then
          roll_die
          inc roll,1
          if roll > 3 then
            score_flg = TRUE
          end if
          CheckPossibleScores()
          if roll > 3 then
             gui cursor hide 
             button (90+i,127,50,22,"Score",1,1)
             gui cursor show
             SetWaste()
          end if
        end if
      end if
    end if
  end if


' handle die roll selection & check boxes    


  if yp% > 127 and yp% < 154 then

    if xp% > 155+i and xp% < 182+i then  '183,198
      die_box_handler(0,i)
    end if

    if xp% > 205+i and xp% < 232+i then
      die_box_handler(1,i)
    end if

    if xp% > 255+i and xp% < 282+i then
      die_box_handler(2,i)
    end if

    if xp% > 305+i and xp% < 332+i then
      die_box_handler(3,i)
    end if

    if xp% > 355+i and xp% < 382+i then
      die_box_handler(4,i)
    end if

  end if

' handle possible score checkboxes
  if xp% > 145+i+60 and xp% < 165+i+60+10 then
    if yp% > (ONES+1)*20+134 and yp% < (ONES+1)*20+144+10 and tmpscores(whosturn,ONES) > 0 then 
      score_box_handler(ones,i)        
    end if 'yp% ones

    if yp% > (TWOS+1)*20+134 and yp% < (TWOS+1)*20+144+10 and tmpscores(whosturn,TWOS) > 0 then 
      score_box_handler(twos,i)  
    end if  'yp% twos

    if yp% > (THREES+1)*20+134 and yp% < (THREES+1)*20+144+10 and tmpscores(whosturn,THREES) > 0 then 
      score_box_handler(threes,i)  
    end if  'yp% tHREEs

    if yp% > (FOURS+1)*20+134 and yp% < (FOURS+1)*20+144+10 and tmpscores(whosturn,FOURS) > 0 then 
      score_box_handler(fours,i)  
    end if  'yp% FOURS

    if yp% > (FIVES+1)*20+134 and yp% < (FIVES+1)*20+144+10 and tmpscores(whosturn,FIVES) > 0 then 
      score_box_handler(fives,i)  
    end if  'yp% FIVES

    if yp% > (SIXES+1)*20+134 and yp% < (SIXES+1)*20+144+10 and tmpscores(whosturn,SIXES) > 0 then 
      score_box_handler(sixes,i)  
    end if  'yp% SIXES

    if yp% > (KIND3+1)*20+134 and yp% < (KIND3+1)*20+144+10 and tmpscores(whosturn,KIND3) > 0 then 
      score_box_handler(kind3,i)  
    end if  'yp% KIND3

    if yp% > (KIND4+1)*20+134 and yp% < (KIND4+1)*20+144+10 and tmpscores(whosturn,KIND4) > 0 then 
      score_box_handler(kind4,i)  
    end if  'yp% KIND4

    if yp% > (FHOUSE+1)*20+134 and yp% < (FHOUSE+1)*20+144+10 and tmpscores(whosturn,FHOUSE) > 0 then 
      score_box_handler(fhouse,i)  
    end if  'yp% FHOUSE

    if yp% > (SSTRAIGHT+1)*20+134 and yp% < (SSTRAIGHT+1)*20+144+10 and tmpscores(whosturn,SSTRAIGHT) > 0 then 
      score_box_handler(sstraight,i)  
    end if  'yp% SSTRAIGHT

    if yp% > (LSTRAIGHT+1)*20+134 and yp% < (LSTRAIGHT+1)*20+144+10 and tmpscores(whosturn,LSTRAIGHT) > 0 then 
      score_box_handler(lstraight,i)  
    end if  'yp% LSTRAIGHT

    if yp% > (YAHTZEE+1)*20+134 and yp% < (YAHTZEE+1)*20+144+10 and tmpscores(whosturn,YAHTZEE) > 0 then 
      score_box_handler(yahtzee,i)  
    end if  'yp% BINGO

    if yp% > (CHANCE+1)*20+134 and yp% < (CHANCE+1)*20+144+10 and tmpscores(whosturn,CHANCE) > 0 then 
      score_box_handler(CHANCE,i)  
    end if  'yp% CHANCE
  end if 'xp%




' handle waste score checkboxes
  if xp% > 300+i+60 and xp% < 300+i+60+10 then
    if yp% > (ONES+1)*20+134 and yp% < (ONES+1)*20+144+10 and scores(whosturn,ONES) = -1 then 
       waste_box_handler(ONES,i)
    end if 'yp% ones

    if yp% > (TWOS+1)*20+134 and yp% < (TWOS+1)*20+144+10 and scores(whosturn,TWOS) = -1 then 
       waste_box_handler(TWOS,i)
    end if  'yp% twos

    if yp% > (THREES+1)*20+134 and yp% < (THREES+1)*20+144+10 and scores(whosturn,THREES) = -1 then 
       waste_box_handler(THREES,i)
    end if  'yp% tHREEs

    if yp% > (FOURS+1)*20+134 and yp% < (FOURS+1)*20+144+10 and scores(whosturn,FOURS) = -1 then 
       waste_box_handler(FOURS,i)
    end if  'yp% FOURS

    if yp% > (FIVES+1)*20+134 and yp% < (FIVES+1)*20+144+10 and scores(whosturn,FIVES) = -1 then 
       waste_box_handler(FIVES,i)
    end if  'yp% FIVES

    if yp% > (SIXES+1)*20+134 and yp% < (SIXES+1)*20+144+10 and scores(whosturn,SIXES) = -1 then 
       waste_box_handler(SIXES,i)
    end if  'yp% SIXES

    if yp% > (KIND3+1)*20+134 and yp% < (KIND3+1)*20+144+10 and scores(whosturn,KIND3) = -1 then 
       waste_box_handler(KIND3,i)
    end if  'yp% KIND3

    if yp% > (KIND4+1)*20+134 and yp% < (KIND4+1)*20+144+10 and scores(whosturn,KIND4) = -1 then 
       waste_box_handler(KIND4,i)
    end if  'yp% KIND4

    if yp% > (FHOUSE+1)*20+134 and yp% < (FHOUSE+1)*20+144+10 and scores(whosturn,FHOUSE) = -1 then 
       waste_box_handler(FHOUSE,i)
    end if  'yp% FHOUSE

    if yp% > (SSTRAIGHT+1)*20+134 and yp% < (SSTRAIGHT+1)*20+144+10 and scores(whosturn,SSTRAIGHT) = -1 then 
       waste_box_handler(SSTRAIGHT,i)
    end if  'yp% SSTRAIGHT

    if yp% > (LSTRAIGHT+1)*20+134 and yp% < (LSTRAIGHT+1)*20+144+10 and scores(whosturn,LSTRAIGHT) = -1 then 
       waste_box_handler(LSTRAIGHT,i)
    end if  'yp% LSTRAIGHT

    if yp% > (YAHTZEE+1)*20+134 and yp% < (YAHTZEE+1)*20+144+10 and scores(whosturn,YAHTZEE) = -1 then 
       waste_box_handler(YAHTZEE,i)
    end if  'yp% BINGO

    if yp% > (CHANCE+1)*20+134 and yp% < (CHANCE+1)*20+144+10 and scores(whosturn,CHANCE) = -1 then 
       waste_box_handler(CHANCE,i)
    end if  'yp% CHANCE
  end if 'xp%


  
  
end sub

sub die_box_handler(what,where)

      if dice(what) = FALSE then
        dice(what) = TRUE
        box 155+where+what*50+30,127,10,10,,RGB(NOTBLACK),RGB(NOTBLACK)
      else
        dice(what) = FALSE
        box 155+where+what*50+30,127,10,10,,RGB(NOTBLACK),RGB(GREEN)
      end if

end sub

sub waste_box_handler(what,where)

        wastethat(what) = NOT wastethat(what)
        if wastethat(what) then
          box 300+where+60,(what+1)*20+139,10,10,,RGB(RED),RGB(RED)
          tmpscores(whosturn,what) = 0            
          check_checked_wasted(what)
          ' uncheck any previously selected score checkboxes
          check_checked(99)
        else
          box 300+where+60,(what+1)*20+139,10,10,,RGB(RED),RGB(GREEN)
          tmpscores(whosturn,what) = -1
        end if
end sub

sub score_box_handler(what,where)

        scorethat(what) = NOT scorethat(what)
        if scorethat(what) then
          box 155+where+60,(what+1)*20+139,10,10,,RGB(NOTBLACK),RGB(NOTBLACK)
          check_checked(what)

          ' uncheck any previously selected waste checkboxes
          check_checked_wasted(99)
          
          gui cursor hide
          button (90+where,127,50,22,"Score",1,1)
          gui cursor show
          score_flg = TRUE
        else
          box 155+where+60,(what+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
          button (90+where,127,50,22,"Roll",1,4)
          score_flg = FALSE
        end if
end sub


function check_selected()
  local i,j

   for j = ONES-1 to CHANCE
    if scorethat(j) then
      check_selected = j
      exit for
    else
      check_selected = -1   'none selected!
    end if
  next

end function

function check_wasted()
  local i,j

   for j = ONES-1 to CHANCE
    if wastethat(j) then
      check_wasted = j
      exit for
    else
      check_wasted = -1   'none selected!
    end if
  next

end function




' unselect any previously selected score select boxea
sub check_checked(except)
  local i,j


  if whosturn = PLAYER1 then
    i = 0
  else 
    i = 400
  end if


  for j = ONES-1 to CHANCE-1
    if j <> except then
      if scorethat(j) then
          scorethat(j) = NOT scorethat(j)
          box 155+i+60,(j+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
      end if
    end if
  next

end sub



sub check_checked_wasted(except)
  local i,j


  if whosturn = PLAYER1 then
    i = 0
  else 
    i = 400
  end if


  for j = ONES-1 to CHANCE-1
    if j <> except then
      if wastethat(j) then
          wastethat(j) = NOT wastethat(j)
          box 355+i+60,(j+1)*20+139,10,10,,RGB(RED),RGB(GREEN)
      end if
    end if
  next

end sub



sub rbutton
  if qr_flag then
    if xp% > 90 and xp% < 140 then
      if yp% > 127 and yp% < 149 then
        NewGame

        draw_new_sheet
      end if
    end if
      
    if xp% > 490 and xp% < 540 then
      if yp% > 127 and yp% < 149 then
        if havemouse then
          controller mouse close
        else
          controller classic close
        end if
        end
      end if
    end if
  end if
end sub

sub NewGame
  local i,n

  for i = 0 to 2
    for n = ONES to bingo_count
      if n = 7 or n = 9 or n = 19 or n = 21 then
        scores(i,n) = 0
    else if n = 20 then
        scores(i,n) = scores(i,9)
    else
      scores(i,n) = UNUSED
      tmpscores(i,n) = UNUSED
    end if
    next
  next

  dice(0) = TRUE
  dice(1) = TRUE
  dice(2) = TRUE
  dice(3) = TRUE
  dice(4) = TRUE

  round = 1
  roll = 1
  whosturn = opponent
  score_flg = FALSE
  qr_flag = FALSE

end sub

sub updatescore(who,what)
  local i,n,tot

  tot = 0
  if who = PLAYER then
    i = 0
  else
    i = 400
  end if

    scores(whosturn,what) = tmpscores(whosturn,what)
mmdebug    text 5,5,"scores(who,what)= "+str$(scores(whosturn,what)),L,,,RGB(BLACK),RGB(BLUE)
mmdebug    text 5,17,"who= "+str$(whosturn),L,,,RGB(BLACK),RGB(BLUE)
mmdebug    text 5,29,"what= "+str$(what)+"  ",L,,,RGB(BLACK),RGB(BLUE)



    for n = 1 to 6
      if scores(whosturn,n) >= 0 then
        tot = tot + scores(whosturn,n)
      end if
    next

    scores(who,UPPER_SUB) = tot
    if scores(whosturn,UPPER_SUB) >= 63 then
      scores(whosturn,bonus) = 35
    else
      scores(whosturn,BONUS) = 0
    end if
    
    scores(whosturn,UPPER_TOT) = scores(whosturn,UPPER_SUB) + scores(whosturn,BONUS)
      
  tot = 0

  if scores(whosturn,bingo_count) > 0 then
    scores(whosturn,BINGO_BONUS) = scores(whosturn,bingo_count) * 100
  end if

  for n = KIND3 to BINGO_BONUS
    if scores(whosturn,n) >= 0 then
      tot = tot + scores(whosturn,n)
    end if
  next
  scores(whosturn,LOWER_SUB) = tot
  scores(whosturn,GRAND_TOT) = scores(whosturn,UPPER_TOT) + scores(whosturn,LOWER_SUB)

  for n = 1 to 9
    if scores(whosturn,n) >= 0 then
      if n > SIXES then
        text 160+i,(n+1)*20+139,str$(scores(whosturn,n)),L,,,RGB(NOTBLACK),RGB(GREEN)
      else 'if n <= SIXES
        text 160+i,(n+1)*20+139,str$(scores(whosturn,n)),L,,,RGB(GREEN),RGB(NOTBLACK)
      end if
    end if
  next

  for n = 11 to 21
    if scores(whosturn,n) >= 0 then
      if n >= LOWER_SUB then
        text 160+i,(n+1)*20+139,str$(scores(whosturn,n)),L,,,RGB(NOTBLACK),RGB(GREEN)
      else
        text 160+i,(n+1)*20+139,str$(scores(whosturn,n)),L,,,RGB(GREEN),RGB(NOTBLACK)
      end if
    end if
  next
  text 160+i,(20+1)*20+139,str$(scores(whosturn,UPPER_TOT)),L,,,RGB(NOTBLACK),RGB(GREEN)


end sub


sub draw_new_sheet
  local i,j

  if whosturn = PLAYER1 then
    j = 0
  else 
    j = 400
  end if
  

  CLS
  load png "./assets/banner4.png",0,0
  box 0,126,799,473,,RGB(GREEN),RGB(GREEN)
' to blank out individual dice
  blit read #11,155,127,27,27
' to blank out all die
  blit read #12,155,127,240,27
' to blank out button
  blit read #13,90,127,55,27 


  
  line 150,126,150,599,2,RGB(NOTBLACK)
  line 549,126,549,599,2,RGB(NOTBLACK)
  line 399,126,399,599,6,RGB(NOTBLACK)

  text 5,108,"Press -H- for help",L,7,,RGB(BLACK),pixel(5,90,0)
  text 695,108,"Press -Q- to quit",L,7,,RGB(BLACK),pixel(5,90,0)


  restore headings

  for i = 0 to 21
    select case i
      case 0,1,7,8,9,10,11,18,19,20,21
        line 0,155+i*20,799,155+i*20,2,RGB(NOTBLACK)
      case else
        line 0,155+i*20,799,155+i*20,,RGB(NOTBLACK)
    end select
      read row_headings$(i)
      select case i
        case 0
          text 5,139+i*20,row_headings$(i)+" 1",L,4,,RGB(BLACK),RGB(GREEN)
          if opponent = PLAYER2 then
            text 410,139+i*20,row_headings$(i)+" 2",L,4,,RGB(BLACK),RGB(GREEN)
          else
            text 410,139+i*20,"Computer",L,4,,RGB(BLACK),RGB(GREEN)
          end if
        case 2,3,4,5,6,7,12,13,14,15,16,18
          text 5,139+i*20,row_headings$(i),L,4,,RGB(BLUE),RGB(GREEN)
          text 410,139+i*20,row_headings$(i),L,4,,RGB(BLUE),RGB(GREEN)
        case 9,17,19
          text 5,139+i*20,row_headings$(i),L,4,,RGB(RED),RGB(GREEN)
          text 410,139+i*20,row_headings$(i),L,4,,RGB(RED),RGB(GREEN)
        case else
          text 5,139+i*20,row_headings$(i),L,4,,RGB(BLACK),RGB(GREEN)
          text 410,139+i*20,row_headings$(i),L,4,,RGB(BLACK),RGB(GREEN)
      end select
  next
  text 5,139+i*20,row_headings$(i+1),L,4,,RGB(BLACK),RGB(GREEN)
  text 410,139+i*20,row_headings$(i+1),L,4,,RGB(BLACK),RGB(GREEN)
  read row_headings$(i+2)
  text 5,135+i*20+3,row_headings$(i+2),L,2,,RGB(BLACK),RGB(GREEN)
  text 410,135+i*20+3,row_headings$(i+2),L,2,,RGB(BLACK),RGB(GREEN)


' draw roll button
  button (90+j,127,50,22,"Roll",1,4)

end sub

sub draw_dice



' one
  rbox 5,5,27,27,3,RGB(NOTBLACK),RGB(WHITE)
  circle 18,18,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
' two
  rbox 35,35,27,27,3,RGB(NOTBLACK),RGB(WHITE)
  circle 53,43,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 43,53,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
' three
  rbox 65,65,27,27,3,RGB(NOTBLACK),RGB(WHITE)
  circle 84,72,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 78,78,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 72,84,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
' four
  rbox 95,95,27,27,3,RGB(NOTBLACK),RGB(WHITE)
  circle 114,102,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 114,114,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 102,102,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 102,114,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
' five
  rbox 125,125,27,27,3,RGB(NOTBLACK),RGB(WHITE)
  circle 144,132,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 144,144,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 138,138,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 132,132,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 132,144,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
' six
  rbox 155,155,27,27,3,RGB(NOTBLACK),RGB(WHITE)
  circle 173,161,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 173,175,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 173,168,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 163,161,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 163,175,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
  circle 163,168,2,,,RGB(NOTBLACK),RGB(NOTBLACK)
 

  blit read #1,5,5,27,27
  blit read #2,35,35,27,27
  blit read #3,65,65,27,27
  blit read #4,95,95,27,27
  blit read #5,125,125,27,27
  blit read #6,155,155,27,27


CLS
  
end sub

sub BUTTON (xpos%,ypos%,width%,height%,title$,acc%,fnt%)

  rbox xpos%+5,ypos%+5,width%,height%,5,RGB(NOTBLACK),RGB(NOTBLACK)
  rbox xpos%,ypos%,width%,height%,5,Grey,Grey
  text xpos%+5,ypos%+5,title$,L,fnt%,,WHITE,Grey
  text xpos%+5+(acc%-1)*10,ypos%+5,mid$(title$,acc%,1),L,fnt%,,RED,Grey
  
end sub

sub FLASH_BUTTON (xpos%,ypos%,width%,height%,title$,acc%,fnt%)

  play stop
  if not keyboard then gui cursor hide

  rbox xpos%+5,ypos%+5,width%,height%,5,Shadow,Shadow
  rbox xpos%,ypos%,width%,height%,5,WHITE,WHITE
  text xpos%+5,ypos%+5,title$,L,fnt%,,GREY,WHITE
  text xpos%+5+(acc%-1)*10,ypos%+5,mid$(title$,acc%,1),L,fnt%,,Grey,RED

  playsounds 6,300,2400,200,3,1,1,3,25,10

  rbox xpos%+5,ypos%+5,width%,height%,5,Shadow,Shadow
  rbox xpos%,ypos%,width%,height%,5,Grey,Grey
  text xpos%+5,ypos%+5,title$,L,4,,WHITE,Grey
  text xpos%+5+(acc%-1)*10,ypos%+5,mid$(title$,acc%,1),L,4,,RED,Grey

  play stop  
  if not keyboard then gui cursor show
  
end sub


sub SortDice
  local i
  low_die = 0
  nxt_low_die = 0
  low_die_three = 0

  
  math scale dice_roll(),1,sorted()
  sort sorted()
  low_die = sorted(0)
  for i = 1 to 4
    if sorted(i) > low_die then
      if nxt_low_die = 0 then
        nxt_low_die = sorted(i)
      end if
    end if
    if nxt_low_die then
      if sorted(i) > nxt_low_die then
        if low_die_three = 0 then
          low_die_three = sorted(i)
        end if
      end if
    end if
  next

end sub

' setup check boxes to use to waste a score ie. a zero score
sub SetWaste()
  local i,j,n

  if whosturn = PLAYER1 then
    j = 0
  else
    j = 400    
  end if

  for n = 1 to 6
    if scores(whosturn,n) = -1 then
      if tmpscores(whosturn,n) = 0 then
        box 300+j+60,(n+1)*20+139,10,10,,RGB(RED),RGB(GREEN)
      end if
    end if
  next

  for n = 11 to 17
    if scores(whosturn,n) = -1 then
      if tmpscores(whosturn,n) = 0 then
        box 300+j+60,(n+1)*20+139,10,10,,RGB(RED),RGB(GREEN)
      end if
    end if
  next

end sub


sub CheckPossibleScores()
  local i,tmp,j

  if whosturn = PLAYER1 then
    j = 0
  else 
    j = 400
  end if
  
  for i = 0 to YAHTZEE+1
    tmpscores(whosturn,i) = 0
    scorethat(i) = 0
    wastethat(i) = 0
  next


  for i = 1 to 6
    tmp = CheckNum(i)
    if tmp > 0 and scores(whosturn,i) = -1 then
      text 160+j,(i+1)*20+139,str$(tmp),L,,,RGB(NOTBLACK),RGB(GREEN)
      box 155+j+60,(i+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
      tmpscores(whosturn,i) = tmp
    end if

      if Bingo_Flg = TRUE then
        play stop
        playsounds 3,1000,4000,2000,20,2,1,6,10,15
        pause 100

        if scores(whosturn,YAHTZEE) = -1 then
          tmpscores(whosturn,YAHTZEE) = 50
          text 160+j,(YAHTZEE+1)*20+139,str$(tmpscores(whosturn,YAHTZEE)),L,,,RGB(NOTBLACK),RGB(GREEN)
          box 155+j+60,(YAHTZEE+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
        end if
      end if

      if Full_Flg = TRUE and scores(whosturn,FHOUSE) = -1 then
        tmpscores(whosturn,FHOUSE) = 25
        text 160+j,(FHOUSE+1)*20+139,str$(tmpscores(whosturn,FHOUSE)),L,,,RGB(NOTBLACK),RGB(GREEN)
        box 155+j+60,(FHOUSE+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
      end if

      if Kind3_Flg = TRUE and scores(whosturn,KIND3) = -1 then
        tmpscores(whosturn,KIND3) = alldie
        text 160+j,(KIND3+1)*20+139,str$(tmpscores(whosturn,KIND3)),L,,,RGB(NOTBLACK),RGB(GREEN)
        box 155+j+60,(KIND3+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
      end if

      if Kind4_Flg = TRUE and scores(whosturn,KIND4) = -1 then
        tmpscores(whosturn,KIND4) = alldie
        text 160+j,(KIND4+1)*20+139,str$(tmpscores(whosturn,KIND4)),L,,,RGB(NOTBLACK),RGB(GREEN)
        box 155+j+60,(KIND4+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
      end if
    end if
  next


  tmp = CheckStraight()
    if tmp > 0 then
      if tmp = 30 and scores(whosturn,SSTRAIGHT) = UNUSED then
        tmpscores(whosturn,SSTRAIGHT) = 30
        text 160+j,(SSTRAIGHT+1)*20+139,str$(tmpscores(whosturn,SSTRAIGHT)),L,,,RGB(NOTBLACK),RGB(GREEN)
        box 155+j+60,(SSTRAIGHT+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
      else if tmp > 30 then
        if scores(whosturn,LSTRAIGHT) = UNUSED then
          tmpscores(whosturn,LSTRAIGHT) = 40
          text 160+j,(LSTRAIGHT+1)*20+139,str$(tmpscores(whosturn,LSTRAIGHT)),L,,,RGB(NOTBLACK),RGB(GREEN)
          box 155+j+60,(LSTRAIGHT+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
        end if
        if scores(whosturn,SSTRAIGHT) = UNUSED then
          tmpscores(whosturn,SSTRAIGHT) = 30
          text 160+j,(SSTRAIGHT+1)*20+139,str$(tmpscores(whosturn,SSTRAIGHT)),L,,,RGB(NOTBLACK),RGB(GREEN)
          box 155+j+60,(SSTRAIGHT+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
        end if
      end if
    end if
  

  tmpscores(whosturn,CHANCE) = alldie
  if scores(whosturn,CHANCE) = UNUSED then
    text 160+j,(CHANCE+1)*20+139,str$(tmpscores(whosturn,CHANCE)),L,,,RGB(NOTBLACK),RGB(GREEN)
    box 155+j+60,(CHANCE+1)*20+139,10,10,,RGB(NOTBLACK),RGB(GREEN)
  end if
    
end sub
       

function CheckStraight()
  local i,scr

  
  select case low_die
    case 1
      if sorted(1) = 2 and sorted(2) = 3 and sorted(3) = 4 and sorted(4) = 5 then
        CheckStraight = 40
      else if sorted(1) = 3 and sorted(2) = 4 and sorted(3) = 5 and sorted(4) = 6 then
        CheckStraight = 30
      else if sorted(1) = 2 and sorted(2) = 3 and sorted(3) = 4 then
        CheckStraight = 30
      else if sorted(2) = 2 and sorted(3) = 3 and sorted(4) = 4 then
        CheckStraight = 30
      else if sorted(1) = 2 and sorted(2) = 3 and sorted(4) = 4 then
        CheckStraight = 30
      end if
      
    case 2
      if sorted(1) = 3 and sorted(2) = 4 and sorted(3) = 5 and sorted(4) = 6 then
        CheckStraight = 40
      else if sorted(1) = 3 and sorted(2) = 4 and sorted(3) = 5 then
        CheckStraight = 30
      else if sorted(1) = 2 and sorted(2) = 3 and sorted(3) = 4 and sorted(4) = 5 then
        CheckStraight = 30
      else if sorted(1) = 3 and sorted(2) = 3 and sorted(3) = 4 and sorted(4) = 5 then
        CheckStraight = 30
      else if sorted(1) = 3 and sorted(2) = 4 and sorted(3) = 4 and sorted(4) = 5 then
        CheckStraight = 30
      end if
      
    case 3
      if sorted(1) = 4 and sorted(2) = 5 and sorted(3) = 6 then
        CheckStraight = 30
      else if sorted(2) = 4 and sorted(3) = 5 and sorted(4) = 6 then
        CheckStraight = 30
      else if sorted(1) = 4 and sorted(2) = 5 and sorted(3) = 5 and sorted(4) = 6 then
        CheckStraight = 30
      end if
    
    case else
        CheckStraight = 0   
  end select
        
end function

function CheckNum(num)
  local tmp,tmp1,cnt,cnt2,i,cnt3
  
  tmp = 0
  tmp1 = 0
  cnt = 0
  cnt2 = 0
  cnt3 = 0
  alldie = 0
  Bingo_flg = FALSE
  KIND3_flg = FALSE
  KIND4_flg = FALSE
  FULL_flg = FALSE
  
  for i = 0 to 4
    alldie = alldie + sorted(i)
    ' total value of all num values found eg. 1's,2's,3's,4's,5's,6's
    if sorted(i) = num then
      tmp = tmp + num
    end if
    
    ' setup check for full house, 3,4 of a kind or YAHTZEE conditions
    if sorted(i) = low_die then
      cnt = cnt + 1
    end if
    
    if sorted(i) = nxt_low_die then
      cnt2 = cnt2 + 1
    end if

    if sorted(i) = low_die_three then
      cnt3 = cnt3 + 1
    end if
  next
    
  if cnt = 5 then
    Bingo_flg = TRUE
    KIND3_flg = TRUE
    KIND4_flg = TRUE
  else if cnt >= 4 then
    KIND4_flg = TRUE
    KIND3_flg = TRUE
  else if cnt >= 3 then
    KIND3_flg = TRUE
    if cnt2 = 2 then
      FULL_flg = TRUE
    end if
  elseif cnt = 2 then
    if cnt2 = 3 then
      FULL_flg = TRUE
      KIND3_flg = TRUE
    end if
  end if
  if cnt2 = 3 then
    KIND3_flg = TRUE
  else if cnt2 > 3 then
    KIND4_flg = TRUE
    KIND3_flg = TRUE
  end if
  if cnt3 = 3 then
    KIND3_flg = TRUE
  end if
  
  CheckNum = tmp

mmdebug  text 5,5,"cnt= "+str$(cnt),l,,,RGB(WHITE),RGB(NOTBLACK)
mmdebug  text 5,17,"cnt2= "+str$(cnt2),l,,,RGB(WHITE),RGB(NOTBLACK)
mmdebug  text 5,29,"cnt3= "+str$(cnt3),l,,,RGB(WHITE),RGB(NOTBLACK)
  
end function

      

' roll dice, based on dice array elements being TRUE or FALSE
sub roll_die
  local j,i,cnt

  if whosturn = PLAYER1 then
    i = 0
  else 
    i = 400
  end if

  cnt = 0

  for j = 0 to 4
    if dice(j) then
      cnt = cnt + 1
    end if
  next


  select case cnt
    case 1,2
       play mp3 "./assets/2die.mp3"

    case 3,4,5
      play mp3 "./assets/5die.mp3"
  end select

  pause 700




  for j = 0 to 4
    if dice(j) then
      dice_roll(j) = rnd*5+1
      dice(j) = FALSE

      box 155+i+j*50+30,127,10,10,,RGB(NOTBLACK),RGB(GREEN)

      select case dice_roll(j)
        case 1              
           blit write #1,155+i+j*50,127

        case 2
           blit write #2,155+i+j*50,127

        case 3
           blit write #3,155+i+j*50,127

        case 4
           blit write #4,155+i+j*50,127

        case 5
           blit write #5,155+i+j*50,127

        case 6
           blit write #6,155+i+j*50,127
      end select            
      

  end if
  next

  sortdice

end sub

sub grade_roll (roll_no)

  if roll_no = 1 then
    sort dice_roll()
  end if

    if dice_roll(0) = 1 then
      GOT_ONES = TRUE

end sub      



' Draw a pleasant box on the screen. Background is not saved!
sub MakeBox(x,y,w,h)
  rbox x    , y    , w     , h     , 10,  &h4040E0, &h4040E0  ' frame
  rbox x + 5, y + 5, w - 10, h - 10,  5,  &h202080, &h202080  ' text area
end sub


sub AskPlayers
  local control$
  
  MakeBox(220,295,380,60)
  text 290,315,"Press 1 for Human Vs. Computer",L,,,RGB(WHITE), &h202080
  text 290,327,"Press 2 for Human Vs. Human",L,,,RGB(WHITE), &h202080

  pause 1000  
  play tts phonetic "shaxll whiy3 pleh eheh3 geh5mmm4",64,72
'   PLAY TTS "SHALL WE PLAY A GAME",64,72

  do while control$ <> "1" and control$ <> "2"
    control$ = inkey$ 
  loop 

  if control$ = "1" then
    opponent = COMPUTER
    whosturn = COMPUTER
    play tts "gud luh4q hu4mehn",64,72
'   PLAY TTS "GOOD LUCK HUMAN",64,72
  else if control$ = "2" then
    opponent = PLAYER2
    whosturn = PLAYER2
  end if
  
end sub


sub check_firmware
  local vers!

    CLS
    vers! = mm.info(version)
    
    MakeBox(120,100,500,90)

    if vers! >= 5.06 then
      text 150,120,"This program is known to work with FW 5.06.00 or",L,,,BLACK,&h202080
      text 150,132,"higher. Other versions of firmware may not be compatible.",L,,,BLACK,&h202080
      text 150,158,"press a key to continue",L,,,BLACK,&h202080
    else
      text 150,120,"This program requires FW 5.06.00 or later.",L,,,BLACK,&h202080
      text 150,132,"Please update your firmware to run.",L,,,BLACK,&h202080
      text 150,158,"press a key to continue",L,,,BLACK,&h202080
    end if

    do while inkey$ = ""
    loop
    if vers! < 5.06 then
      CLS
      end
    end if      
end sub
