
'CMM2 Qbert
'
'developed by yock1960 - 2021
'
'
#include "playfield.inc"
#include "levels.inc"
 
const TRUE = 1
const FALSE = 0
const DEAD = FALSE
const LIVE = TRUE
const EGG = -1
const QBERT = 1       '1,2
const REDEGG = 3      '3-10
const GREENEGG = 11   '11,12
const COILYEGG = 13   '13,14
const COILY = 15      '15,16
const DOH = 17
const WRONGWAY = 23   '23,24
const UGG = 31        '31,32
const SAM = 39        '39,40
const DISC = 47       '47-54
const UPRIGHT = 0 
const UPLEFT = 2
const DNRIGHT = 4
const DNLEFT = 6
const PLYRTXT = 55
'sound constants
const JUMP = 1
const LIFT= 2
const TUNE = 3
const TUNE2 = 4
const FALL = 5
const EGGDROP = 6
const COILYFALL = 7
const UGGSPEECH = 8
const WRONGWAYSPEECH = 9
const QBERTDIES = 10
const PRIZE = 11
const COILYJUMP = 12
const COINDROP = 13 'does not exist yet
'cube definition
dim c%(2) = (4,4,4)
dim x%(12) = (224,240,256,240, 224,224,240,240, 240,240,256,256,240)
dim y%(12) = (100,92,100,108, 100,120,128,108, 108,128,120,100,108)
dim nxstartcolor%(2)
dim nxfinishcolor%(2) 
dim startcolor%(2)
dim finishcolor%(2) 
dim nextx%(12),nexty%(12)
dim playfield%(8,14)
dim qbert_location!(1)
dim coily_location!(1)
dim redegg_location!(3,1)
dim elev_location!(1)
dim qhx = 122
dim nz
dim qhy = 20+28
dim side%
dim kb$

dim disc_pairs(14,1)
dim sdisc!(7,2)

'to change color of tops of cubes
dim c1% = (4)
dim x1%(3) = (224,240,256,240)
dim y1%(3) = (100,92,100,108)
dim fc1% = (rgb(183,175,64))
dim flg% = FALSE
'used in make playfield
dim nextx1%(3),nexty1%(3)
dim k% = 6
dim s% = DISC
dim p% = 0
dim q% = 0
dim l%,m%
dim vec!
dim tx!,ty!
dim r%
dim t%
dim base_spr%,cur_spr%,b_spr%,c_cur_spr%
dim level% = 1
dim round% = 1
dim field%(14,8)
dim HaveClassic = FALSE
dim HaveNunchuk = FALSE
dim qstate = LIVE
dim cstate = DEAD
dim restate = DEAD
dim score% = 25
dim cube_cnt% = 0
dim newlevel = TRUE
dim level_colr%
dim round_colr%
'mainloop timer
dim mltimer%
'timer for timing coily drop in
dim ctimer%,ct%
dim fg%,e%
dim c_cnt%
dim pawsed = FALSE
dim discnt%
dim flag% = FALSE
dim cf% = FALSE

tx! = 14.5
ty! = 8
 
#MMDEBUG Off

ls_pairs:
data -.5,7.2,.5,6.2,1.5,5.2,2.5,4.2,3.5,3.2,4.5,2.2,5.5,1.2
rs_pairs:
data 14.5,7.2,13.5,6.2,12.5,5.2,11.5,4.2,10.5,3.2,9.5,2.2,8.5,1.2


restore playfield
for l% = 0 to 8
  for m% = 0 to 14
    read field%(m%,l%)
  next
next
math scale field%(),1,playfield%()

restore ls_pairs
for l% = 1 to 7
  read disc_pairs(l%,0)
  read disc_pairs(l%,1)
next
restore rs_pairs
for l% = 8 to 14
  read disc_pairs(l%,0)
  read disc_pairs(l%,1)
next  
calc_discs(1,1)

mode 4,12,RGB(BLACK),screen_refresh

cls
page write 3
cls
load png "./assets/qbert_creatures.png",0,0,15
load png "./assets/qbert_cubes_level1.png",129,0,15
load png "./assets/qbert_player_scroll.png",240,0,15
load png "./assets/qbert - misc_text.png",347,0,15
load png "./assets/qbert_spinning_discs.png",0,160,5
load png "./assets/qbert_alphanumeric.png",0,225,15
load png "./assets/qbert_doh.png",0,256,15
play modfile "./assets/qbert_sounds.mod",22050

'qbert 1-8
'sprite read QBERT+UPRIGHT,   0,0,16,16,3
'sprite read QBERT+UPRIGHT+1,16,0,16,16,3
'sprite read QBERT+UPLEFT,   32,0,16,16,3
'sprite read QBERT+UPLEFT+1, 48,0,16,16,3
'sprite read QBERT+DNRIGHT,  64,0,16,16,3
'sprite read QBERT+DNRIGHT+1,80,0,16,16,3
'sprite read QBERT+DNLEFT,   96,0,16,16,3
'sprite read QBERT+DNLEFT+1,112,0,16,16,3



'red egg 3-10
sprite read REDEGG,  16,16,16,16,3
sprite read REDEGG+1, 0,16,16,16,3
sprite copy REDEGG,REDEGG+2,1
sprite copy REDEGG+1,REDEGG+2+1,1
sprite copy REDEGG,REDEGG+4,1
sprite copy REDEGG+1,REDEGG+4+1,1
sprite copy REDEGG,REDEGG+6,1
sprite copy REDEGG+1,REDEGG+6+1,1


'green ball 11-12
sprite read GREENEGG,  48,16,16,16,3
sprite read GREENEGG+1,32,16,16,16,3


'coily egg 13-14
sprite read COILYEGG,  80,16,16,16,3
sprite read COILYEGG+1,64,16,16,16,3

'coily 15-22
'sprite read COILY+UPRIGHT,   0,32,16,32,3
'sprite read COILY+UPRIGHT+1,16,32,16,32,3
'sprite read COILY+UPLEFT,   32,32,16,32,3
'sprite read COILY+UPLEFT+1, 48,32,16,32,3
'sprite read COILY+DNRIGHT,  64,32,16,32,3
'sprite read COILY+DNRIGHT+1,80,32,16,32,3
'sprite read COILY+DNLEFT,   96,32,16,32,3
'sprite read COILY+DNLEFT+1,112,32,16,32,3

'wrongway 23-30
sprite read WRONGWAY+UPRIGHT,   0,32,16,32,3
sprite read WRONGWAY+UPRIGHT+1,16,32,16,32,3
sprite read WRONGWAY+UPLEFT,   32,32,16,32,3
sprite read WRONGWAY+UPLEFT+1, 48,32,16,32,3
sprite read WRONGWAY+DNRIGHT,  64,32,16,32,3
sprite read WRONGWAY+DNRIGHT+1,80,32,16,32,3
sprite read WRONGWAY+DNLEFT,   96,32,16,32,3
sprite read WRONGWAY+DNLEFT+1,112,32,16,32,3

'ugg 31-38
sprite read UGG+UPRIGHT,   0,32,16,32,3
sprite read UGG+UPRIGHT+1,16,32,16,32,3
sprite read UGG+UPLEFT,   32,32,16,32,3
sprite read UGG+UPLEFT+1, 48,32,16,32,3
sprite read UGG+DNRIGHT,  64,32,16,32,3
sprite read UGG+DNRIGHT+1,80,32,16,32,3
sprite read UGG+DNLEFT,   96,32,16,32,3
sprite read UGG+DNLEFT+1,112,32,16,32,3

'sam 39-46
sprite read SAM+UPRIGHT,   0,32,16,32,3
sprite read SAM+UPRIGHT+1,16,32,16,32,3
sprite read SAM+UPLEFT,   32,32,16,32,3
sprite read SAM+UPLEFT+1, 48,32,16,32,3
sprite read SAM+DNRIGHT,  64,32,16,32,3
sprite read SAM+DNRIGHT+1,80,32,16,32,3
sprite read SAM+DNLEFT,   96,32,16,32,3
sprite read SAM+DNLEFT+1,112,32,16,32,3


'disc
sprite read DISC,129,193,16,16,3
sprite read DISC+1,145,193,16,16,3
sprite read DISC+2,161,193,16,16,3
sprite read DISC+3,177,193,16,16,3
'disc with qbert on board
sprite read DISC+4,0,181,16,21,3
sprite read DISC+5,16,181,16,21,3
sprite read DISC+6,32,181,16,21,3
sprite read DISC+7,48,181,16,21,3

sprite read DOH,0,256,50,27,3

'player number
blit read  62,347,0,8,12,3
'level text
blit read  61,347,12,30,8,3
'round text
blit read  60,347,20,30,8,3
'chage to text
blit read  59,347,28,50,8,3
'right arrow
blit read  58,347+24,0,8,8,3
'left arrow
blit read  57,347+32,0,8,8,3

page write 0



' used for cube flashing
blit read 64,120,89,9*28,9*28
blit read 63,120,89,9*28,9*28,5




l% = l% - 1
flg% = TRUE

qbert_location(0) = 7
qbert_location(1) = 1

selectinputdevice(1) 

  cls

  timer = 0

  flg% = TRUE


  ' player numer
  blit write 62,68,8
  'level
  blit write 61,340,80
  level_colr% = pixel(343,85)


  'round
  blit write 60,340,90
  round_colr% = pixel(340,95)


  'change to
  blit write 59,10,50


'  reset playfield
  math scale playfield%(),1,field%()
  calc_discs(level%,round%)

draw_cubes(FALSE)

pause 2000

play modsample TUNE,1,64,22050   'tune.wav  all tunes on channel 1

drop_in


'sprite show COILY+UPRIGHT+1,(7*16)+qhx,qhy-8+(28*5),1 



base_spr% = QBERT
cur_spr% = QBERT

ctimer% = timer

mltimer% = timer
settick 3000,coilly,1
settick 6000,redeg,4

'main loop
'do while inkey$ <> "q"

do while kb$ <> "q" 

kb$ = inkey$ 
'mltimer% = timer

if kb$ = "p" and not pawsed then
  pawsed = TRUE
  settick 0,coilly,1
  settick 0,redeg,4
else if kb$ = "p" and pawsed then
  pawsed = FALSE
  settick 1250,coilly,1
  settick 1350,redeg,4
end if


if qstate = DEAD then
  qstate = LIVE
  qbert_location(0) = 7
  qbert_location(1) = 1

  if CSTATE <> DEAD then
    sprite hide c_cur_spr%    
    cstate = DEAD
    ct% = 0
    settick 150,coilly,1
  end if

'  pause 2000

  drop_in

end if



loop

sub collision
  local  spn%,sp2%,n


  cf% = TRUE

  sprite nointerrupt
  c_activated% = FALSE

'    spn% = sprite(C,cur_spr%)
    sp2% = sprite(C,cur_spr%)
  'text 100,30,"sprite# = "+str$(sp2%)+" ",L,,,RGB(WHITE)

    
     if coily_location!(0) = qbert_location!(0) then
       if coily_location!(1) = qbert_location!(1) then      
          cflag%=TRUE

          settick 0,coilly,1
          settick 0,redeg,4
          play modsample QBERTDIES,2,64,22050   'swear.wav  all qbert sounds on channel 2
          qstate = DEAD
          cstate = DEAD
          restate = DEAD
          
          sprite show DOH,qhx+(qbert_location!(0)*16)+5,qhy+(qbert_location!(1)*28)-20,1
          redegg_location!(0,0)=0
          redegg_location!(0,1)=0

          coily_location!(0)=0
          coily_location!(1)=0
          PAUSE 1000          
          sprite hide DOH
          sprite hide safe cur_spr%
          sprite hide safe c_cur_spr%
mmdebug   on error skip
           if re_cur_spr% > 0 then
            sprite hide safe re_cur_spr%
           end if
'          settick 20,coilly,1
'          settick 40,redeg,4
       end if
     else if redegg_location!(0,0) = qbert_location!(0) then
       if redegg_location!(0,1) = qbert_location!(1) then      
          cflag%=TRUE
          settick 0,coilly,1
          settick 0,redeg,4
          play modsample QBERTDIES,2,64,22050   'swear.wav  all qbert sounds on channel 2
          qstate = DEAD
          cstate = DEAD
          restate = DEAD
          sprite show DOH,qhx+(qbert_location!(0)*16)+5,qhy+(qbert_location!(1)*28)-20,1
          coily_location!(0)=0
          coily_location!(1)=0

          redegg_location!(0,0)=0
          redegg_location!(0,1)=0
          PAUSE 1000          
          sprite hide DOH
          sprite hide safe cur_spr%
          sprite hide safe c_cur_spr%
          sprite hide safe re_cur_spr%
'          settick 20,coilly,1
'          settick 40,redeg,4
       end if
    end if

    if not c_activated% then
      sprite interrupt collision
      c_activated% = TRUE
    end if
    
    cf% = FALSE    
end sub

sub redeg
  local hd%,vd%  

  if cflag% then 
    settick 2000,coilly,1
    settick 4000,redeg,4
    cflag% = FALSE
    exit sub
  end if


  if restate = DEAD then  'if red egg is not on playfield
      settick 0,redeg,4
      redeg_dropin(0)
      restate = EGG
    end if
  end if

  vd% = 1

  if restate = EGG then
    select case redegg_location!(0,1)
      case 1
        hd% = rnd*2+1
        if hd% = 2 then hd% = -1
          red_egg_drop(0,hd%,vd%)
        exit sub

      case 2
        hd% = rnd*2+1
        if hd% = 2 then hd% = -1
          red_egg_drop(0,hd%,vd%)
        exit sub

      case 3
        if redegg_location!(0,0) = 5 then
          hd% = 1
        else if redegg_location!(0,0) = 9 then
          hd% = -1
        else
          hd% = rnd*2+1
          if hd% = 2 then hd% = -1
        end if
        red_egg_drop(0,hd%,vd%)
        exit sub

      case 4
        if redegg_location!(0,0) = 4 then
          hd% = 1
        else if redegg_location!(0,0) = 10 then
          hd% = -1
        else
          hd% = rnd*2+1
          if hd% = 2 then hd% = -1
        end if
        red_egg_drop(0,hd%,vd%)
        exit sub

      case 5
        if redegg_location!(0,0) = 3 then
          hd% = 1
        else if redegg_location!(0,0) = 11 then
          hd% = -1
        else
          hd% = rnd*2+1
          if hd% = 2 then hd% = -1
        end if
        red_egg_drop(0,hd%,vd%)
        exit sub

      case 6
        if redegg_location!(0,0) = 2 then
          hd% = 1
        else if redegg_location!(0,0) = 12 then
          hd% = -1
        else
          hd% = rnd*2+1
          if hd% = 2 then hd% = -1
        end if
        red_egg_drop(0,hd%,vd%)
        exit sub

      case 7
        restate = DEAD
        sprite hide safe REDEGG+1
'        sprite show REDEGG,((redegg_location!(0,0))*16)+qhx,qhy+8+(28*(redegg_location!(0,1)-1)+14),1
        re_cur_spr% = REDEGG
        settick 3000,redeg,4
        exit sub

    end select

  end if    


end sub   'redeg



sub coilly
  local hd%,vd%,ct1%,ct2%  


  if cflag% then 
    settick 2000,coilly,1
    settick 4000,redeg,4
    cflag% = FALSE
    exit sub
  end if
   
  ct1% = timer
  if cstate = DEAD then
'    ct% = ct% + timer
'    if ct% - ctimer% >= 3000 then
      settick 0,coilly,1   
      coily_dropin
      cstate = EGG
'      pause 500
      'coily_location!(0) = 7
      'coily_location!(1) = 1    
'      settick 1000,coilly,1
'      ctimer% = timer
'    end if
    end if
  end if

  vd% = 1

  if cstate = EGG then
'    ct% = ct% + timer
'    if ct% - ctimer% < 1000 then 
'      exit sub
'    else
'      ctimer% = timer
'    end if

    if not c_activated%  then
      sprite interrupt collision    
      c_activated% = TRUE
    end if

    select case coily_location!(1)
      case 1
        hd% = rnd*2+1
        if hd% >= 2 then 
          hd% = -1
        end if
        egg_drop(COILYEGG,hd%,vd%)
        exit sub
        
      case 2
        hd% = rnd*2+1
        if hd% = 2 then 
          hd% = -1
        end if
        egg_drop(COILYEGG,hd%,vd%)
        exit sub

      case 3
        if coily_location!(0) = 5 then
          hd% = 1
        else if coily_location!(0) = 9 then
          hd% = -1
        else
          hd% = rnd*2+1
          if hd% = 2 then hd% = -1
        end if
        egg_drop(COILYEGG,hd%,vd%)
        exit sub

      case 4
        if coily_location!(0) = 4 then
          hd% = 1
        else if coily_location!(0) = 10 then
          hd% = -1
        else
          hd% = rnd*2+1
          if hd% = 2 then hd% = -1
        end if
        egg_drop(COILYEGG,hd%,vd%)
        exit sub

      case 5
        if coily_location!(0) = 3 then
          hd% = 1
        else if coily_location!(0) = 11 then
          hd% = -1
        else
          hd% = rnd*2+1
          if hd% = 2 then hd% = -1
        end if
        egg_drop(COILYEGG,hd%,vd%)
        exit sub

      case 6
        if coily_location!(0) = 2 then
          hd% = 1
        else if coily_location!(0) = 12 then
          hd% = -1
        else
          hd% = rnd*2+1
          if hd% = 2 then hd% = -1
        end if
        egg_drop(COILYEGG,hd%,vd%)
        exit sub

      case 7
        cstate = LIVE
mmdebug on error skip
        sprite hide COILYEGG+1

        sprite read COILY,   0,32,16,32,3     'UPRIGHT
        sprite read COILY+1,16,32,16,32,3     

mmdebug on error skip
        sprite show COILY,((coily_location!(0))*16)+qhx,qhy+8+(28*(coily_location!(1)-1)+14),1
        c_cur_spr% = COILY
        settick 1250,coilly,1
        exit sub
    end select
  end if    


  if cstate = LIVE then
    kill_vector
    coily_hop(kvh%,kvv%)
  end if    
  ct2% = timer

  text 200,30,str$(ct2%-ct1%),L,,,RGB(WHITE)

'end if


end sub

sub kill_vector

  kvh% = qbert_location!(0) - coily_location!(0)
  if kvh% < 0 then 
    kvh% = -1
  else
    kvh% = 1
  end if

  kvv% = qbert_location!(1) - coily_location!(1)
  if kvv% > 0 then
    kvv% = 1
  else
    kvv% = -1
  end if
  'text 100,40,"vector = "+str$(kvh%)+","+str$(kvv%)+" ",L,,,RGB(WHITE)


end sub



' flash all the cube tops at level completed
sub cube_flash
 local l%
  sprite hide safe cur_spr%
  play modsample TUNE2,1,64,22050   'tune-2.wav  all tune sounds on channel 1



  for l% = 1 to 10
    if l% = 1 or l% = 3 or l% = 5 or l% = 7 or l% = 9 then
      blit write 64,120,89
    else
      blit write 63,120,89
    end if
    pause 125
  next

  pause 1000


  if round% < 4 then
    inc round%
    settick 2000,coilly,1
    settick 4000,redeg,4
    ctimer% = timer
    ct% = timer
    cstate = DEAD
    restate = DEAD
  else
    round% = 1
    inc level%
    newlevel = TRUE
    settick 2000,coilly,1
    settick 4000,redeg,4
    ctimer% = timer
    ct% = timer
    cstate = DEAD
    restate = DEAD
  end if

  drop_in
    
end sub

sub screen_refresh
  static t3%
  local t1%,t2%


  if flg% = FALSE then exit sub

  t2% = timer
  if t2% >= 120 then
    discs
    t3% = t3% + t2%
    timer = 0
  end if
  if t3% >= 360 then
    arrows
    t3% = 0
  end if


  text 380,80,str$(level%)+" ",L,7,,level_colr%
  text 380,90,str$(round%)+" ",L,7,,round_colr%


  if score% > 0 then
    text 20,27,str$(score%),L,,,RGB(RED)
  end if
end sub

sub discs
  local i%

  s% = s% + 1
  p% = p% + 1


  if s% > DISC+3 then s% = DISC
  if p% > 6 then p% = 1


  sprite read PLYRTXT,240,0+p%*8,53,8,3

  for i% = 1 to 7
    if sdisc!(i%,0) = TRUE then
      blit write s%,sdisc!(i%,1)*16+qhx,sdisc!(i%,2)*28+qhy
    end if
  next

' player
   blit write PLYRTXT,10,10
end sub


sub arrows
  q% = q% + 1
  if q% = 3 then q% = 0

  if q% = 0 then

    box 70,50,17,10,,RGB(black),RGB(black)
    box 110,50,20,10,,RGB(black),RGB(black)

    if pawsed then
      text 150,30,"Game Paused",L,3,,RGB(RED)
    else
      text 150,30,"           ",L,3,,RGB(RED)
    end if
  
  else if q% = 1 then
    blit write 57,120,50
    blit write 58,70,50
  else if q% = 2 then
    blit write 57,110,50
    blit write 58,80,50
    if pawsed then
      text 150,30,"           ",L,3,,RGB(RED)
    end if

  end if
end sub  



sub elevator(lift,dr)
  local m%,r%,fg%,rloop%


  sdisc!(lift,0) = FALSE

  elev_location!(0) = sdisc!(lift,1)
  elev_location!(1) = sdisc!(lift,2)

'blank out used disc
  box sdisc!(lift,1)*16+qhx,sdisc!(lift,2)*28+qhy,16,16,,RGB(BLACK),RGB(BLACK) 


' choose sprite based on direction
  if dr = 1 then
    sprite read DISC+4,0,181,16,21,3
    sprite read DISC+5,16,181,16,21,3
    sprite read DISC+6,32,181,16,21,3
    sprite read DISC+7,48,181,16,21,3
  else
    sprite read DISC+4,0,160,16,21,3
    sprite read DISC+5,16,160,16,21,3
    sprite read DISC+6,32,160,16,21,3
    sprite read DISC+7,48,160,16,21,3
  end if


  ehv% = dr


  fg% = FALSE


  e% = DISC+4

  settick 300,lift_hop,2

end sub


sub lift_hop

' fg% = FALSE

    for r% = 1 to 16

      if e% = DISC+8 then 
         e% = DISC+4
      end if
      if e% > DISC+4 and e% <= DISC+7 then
        sprite hide safe e% - 1
        pause 7
      end if

      if ehv% = -1 then
        sprite show e%,((elev_location!(0)*16)+qhx)-r%,(elev_location!(1)*28+qhy-5)-r%*1.8,1
        pause 10
      else
        sprite show e%,((elev_location!(0)*16)+qhx)+r%,(elev_location!(1)*28+qhy-5)-r%*1.8,1
        pause 10
      end if
      inc e%

    next

    fg% = TRUE


  if ehv% = -1 then
    inc elev_location!(0),-1
  else
    inc elev_location!(0),1
  end if

  inc elev_location!(1),-1

  if ehv% = 1 then  
    if elev_location!(0) >= 6.5 then
mmdebug on error skip
      sprite hide safe e%-1
      settick 0,lift_hop,2
      settick 1250,coilly,1
      drop_in
    end if
  end if
  if ehv% = -1 then  
    if elev_location!(0) <= 7.5 then
mmdebug on error skip
      sprite hide safe e%-1
      settick 0,lift_hop,2
      settick 1250,coilly,1
      drop_in
    end if
  end if
    
  end if

end sub


sub drop_in
  local m%

'  if cf% then exit sub

  if cflag% then 
    settick 2000,coilly,1
    settick 4000,redeg,4
    cflag% = FALSE
'    exit sub
  end if

  if newlevel = TRUE then 
    c_cnt% = 0
    if c_cnt% = 0 then
      inc cube_cnt%
      c_cnt% = 1
      newlevel = FALSE  
      'text 100,10,"cube count = "+str$(cube_cnt%)+" ",L,,,RGB(WHITE)

    end if
  end if

 qbert_location!(0) = 7
 qbert_location!(1) = 1


' math add x1%(),(qbert_location!(0)-7)*16,nextx1%()
' math add y1%(),(qbert_location!(1)-1)*28,nexty1%()
' polygon c1%,nextx1%(),nexty1%(),finishcolor%(0),finishcolor%(0)


'  on error skip
'  sprite hide QBERT+DNRIGHT+1


   sprite read QBERT,  64,0,16,16,3  'DNRIGHT
   sprite read QBERT+1,80,0,16,16,3
   pause 25

  cur_spr% = QBERT+1

  for m% = 1 to 20
on error skip
    sprite show QBERT+1,7*16+qhx,qhy+(28-13)+m%,1
    pause 10
  next

mmdebug on error skip
 if sprite(X,QBERT+1) <> 10000 then
   sprite hide QBERT+1
 end if

 math add x1%(),(qbert_location!(0)-7)*16,nextx1%()
 math add y1%(),(qbert_location!(1)-1)*28,nexty1%()
 polygon c1%,nextx1%(),nexty1%(),finishcolor%(0),finishcolor%(0)

mmdebug on error skip
 sprite show QBERT,7*16+qhx,28+qhy+10,1

  if field%(qbert_location!(0),qbert_location!(1)) = 0 then
    inc field%(qbert_location!(0),qbert_location!(1))
  end if
  cur_spr% = QBERT


end sub   'drop in


sub redeg_dropin(eggno%)
  local m%

  if restate = DEAD then
      restate = EGG


      side% = rnd*2 '+1
      if side% > 1 then 
        side% = -1
      else
        side% = 1
      end if
  end if
  'text 200,10,"side ="+str$((7+side%)*16+qhx)+" ",L,,,RGB(WHITE)

  for m% = 1 to 40
'    sprite show safe COILYEGG+1,((7+side%)*16)+qhx,qhy+((28*2)-13)+m%,1,0
mmdebug on error skip
    sprite show safe REDEGG+eggno%,((7+side%)*16)+qhx,qhy+((28*2)-33)+m%,1,0
    re_cur_spr% = REDEGG+eggno%
    pause 2
  next
mmdebug on error skip
  sprite hide REDEGG+eggno%



' sprite show COILYEGG,(7+side%)*16+qhx,(28*2)+qhy+10,1
 'text 200,30,"side ="+str$((7+side%)*16+qhx)+" ",L,,,RGB(WHITE)


  sprite show REDEGG+1+eggno%,((7+side%)*16)+qhx,qhy+((28*2)-13)+m%,1,0
  re_cur_spr% = REDEGG+eggno%+1

  settick 1350,redeg,4
 
  redegg_location!(eggno%,0) = 7+side%
  redegg_location!(eggno%,1) = 2

'diagnostic to understand where program returns after a sprite collision
 cf% = FALSE


end sub   'redeg_dropin




sub coily_dropin
  local m%

  if cf% then exit sub

  if cstate = DEAD then
      cstate = EGG


      side% = rnd*2 '+1
      if side% > 1 then 
        side% = -1
      else
        side% = 1
      end if
  end if
  'text 200,10,"side ="+str$((7+side%)*16+qhx)+" ",L,,,RGB(WHITE)

  for m% = 1 to 40
'    sprite show safe COILYEGG+1,((7+side%)*16)+qhx,qhy+((28*2)-13)+m%,1,0
mmdebug on error skip
    sprite show safe COILYEGG,((7+side%)*16)+qhx,qhy+((28*1))+m%,1,0
    c_cur_spr% = COILYEGG
    pause 2
  next
mmdebug on error skip
  sprite hide COILYEGG



' sprite show COILYEGG,(7+side%)*16+qhx,(28*2)+qhy+10,1
 'text 200,30,"side ="+str$((7+side%)*16+qhx)+" ",L,,,RGB(WHITE)


  sprite show COILYEGG+1,((7+side%)*16)+qhx,qhy+((28*1)-0)+m%,1,0
  c_cur_spr% = COILYEGG+1
  settick 1250,coilly,1
 
  coily_location!(0) = 7+side%
  coily_location!(1) = 2


end sub


sub red_egg_drop(spr%,horz%,vert%)   'spr% 0=1st egg, 1=2nd egg, 2=3rd egg, 3=4th egg
' local b_spr%
 local tmp_loc!(1),n
 static f% = 1

  play modsample EGGDROP,1,64,22050   'jump-3.wav  all egg sounds on channel 1, shared with tunes

mmdebug on error skip
' sprite hide spr% 
 sprite hide safe REDEGG+(2*spr%)+1


'  if spr% = REDEGG then
 
    re_cur_spr% = (2*spr%)+REDEGG
    if horz% = 1 then
      tmp_loc!(0) = redegg_location!(spr%,0) + 1
    else
      tmp_loc!(0) = redegg_location!(spr%,0) - 1
    end if
    tmp_loc!(1) = redegg_location!(spr%,1) + 1




  if horz% = 1 then
mmdebug on error skip
    sprite show safe REDEGG+(2*spr%),((tmp_loc!(0)-1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1)-5),1 
    re_cur_spr% = REDEGG+(2*spr%)
  else
mmdebug on error skip
    sprite show safe REDEGG+(2*spr%),((tmp_loc!(0)+1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1)-5),1 
    re_cur_spr% = REDEGG+(2*spr%)
  end if
  pause 30
mmdebug on error skip
  sprite show safe REDEGG+(2*spr%),((tmp_loc!(0)+0)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-0)-5),1 
  pause 30

  sprite hide safe REDEGG+(2*spr%)

mmdebug on error skip
  sprite show safe REDEGG+(2*spr%)+1,((tmp_loc!(0)+0)*16)+qhx,qhy+8+(28*(tmp_loc!(1))),1 
  re_cur_spr% = REDEGG+(2*spr%)+1

  pause 30


    redegg_location!(spr%,0) = tmp_loc!(0)
    redegg_location!(spr%,1) = tmp_loc!(1)
 
'diagnostic to understand where program returns after a sprite collision
 cf% = FALSE


end sub   'redegg drop





sub egg_drop(spr%,horz%,vert%)
' local b_spr%
 local tmp_loc!(1),n
 static f% = 1

play modsample EGGDROP,1,64,22050   'jump-3.wav  all egg sounds on channel 1

mmdebug on error skip
' sprite hide spr% 
 sprite hide safe spr%+1


  if spr% = COILYEGG then
    c_cur_spr% = spr%
    if horz% = 1 then
      tmp_loc!(0) = coily_location!(0) + 1
    else
      tmp_loc!(0) = coily_location!(0) - 1
    end if
    tmp_loc!(1) = coily_location!(1) + 1
  end if




  if horz% = 1 then
mmdebug on error skip
    sprite show safe spr%,((tmp_loc!(0)-1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1)-5),1 
    c_cur_spr% = spr%
  else
mmdebug on error skip
    sprite show safe spr%,((tmp_loc!(0)+1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1)-5),1 
    c_cur_spr% = spr%
  end if
  pause 30
mmdebug on error skip
  sprite show safe spr%,((tmp_loc!(0)+0)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-0)-5),1 
  pause 30

  sprite hide safe spr%

mmdebug on error skip
  sprite show safe spr%+1,((tmp_loc!(0)+0)*16)+qhx,qhy+8+(28*(tmp_loc!(1))),1 
  c_cur_spr% = spr%+1

  pause 30

  

    coily_location!(0) = tmp_loc!(0)
    coily_location!(1) = tmp_loc!(1)

'diagnostic to understand where program returns after a sprite collision
 cf% = FALSE


end sub



sub coily_hop(horz%,vert%)
 local b_spr%
 local tmp_loc!(1)
 static f% = 1

 play modsample 12,3,64,22050   'jump-4.wav  all coily sounds on channel 3

mmdebug on error skip
 sprite hide safe c_cur_spr% 'what coily sprite is currently showing

    if horz% = 1 then
      tmp_loc!(0) = coily_location!(0) + 1
    else
      tmp_loc!(0) = coily_location!(0) - 1
    end if

    if coily_location!(1) = 7 then vert% = -1
      
    if vert% = 1 then
      tmp_loc!(1) = coily_location!(1) + 1
    else
      tmp_loc!(1) = coily_location!(1) - 1
    end if


    select case field%(tmp_loc!(0),tmp_loc!(1))
      case -1
        play modsample 7,3,64,22050   'snake-fall.wav  all coily sounds on channel 3


        cstate = dead
        exit sub
        
      
    end select


 if horz% = 1 then
  if vert% = 1 then
    sprite read COILY,  64,32,16,32,3 'DNRIGHT
    sprite read COILY+1,80,32,16,32,3
    b_spr% = COILY
  else
    sprite read COILY,   0,32,16,32,3     'UPRIGHT
    sprite read COILY+1,16,32,16,32,3     
    b_spr% = COILY
  end if
 else
  if vert% = 1 then
    sprite read COILY,   96,32,16,32,3 'DNLEFT
    sprite read COILY+1,112,32,16,32,3
    b_spr% = COILY
  else
    sprite read COILY,   32,32,16,32,3  'UPLEFT
    sprite read COILY+1, 48,32,16,32,3
    b_spr% = COILY
  end if
 end if


'        sprite show COILY+UPRIGHT,((coily_location!(0))*16)+qhx,qhy+8+(28*(coily_location!(1)-1)+14),1
mmdebug on error skip 
 sprite show safe b_spr%+1,((tmp_loc!(0)-0)*16)+qhx,qhy+8+(28*(tmp_loc!(1)+0))-14),1 
 c_cur_spr% = b_spr%+1
 pause 50
 sprite hide safe b_spr%+1 

 sprite show safe b_spr%,((tmp_loc!(0)-0)*16)+qhx,qhy+8+(28*(tmp_loc!(1)+0)-14),1 
 c_cur_spr% = b_spr%



    coily_location!(0) = tmp_loc!(0)
    coily_location!(1) = tmp_loc!(1)
    
'  text 100,30,"location = "+str$(tmp_loc!(0))+","+str$(tmp_loc!(1))+" ",L,,,RGB(WHITE)

  
'diagnostic to understand where program returns after a sprite collision
 cf% = FALSE


end sub




sub hop(horz%,vert%)
 local tmp_spr%,bonus%
 local tmp_loc!(1)
 static f% = 1

  if cf% then exit sub

play modsample 1,2,64,22050   'jump.wav  all qbert sounds on channel 2

  tmp_spr% = cur_spr%

' on error skip
' sprite hide cur_spr% 'QBERT+DNRIGHT

    if horz% = 1 then
      tmp_loc!(0) = qbert_location!(0) + 1
    else
      tmp_loc!(0) = qbert_location!(0) - 1
    end if
    if vert% = 1 then
      tmp_loc!(1) = qbert_location!(1) + 1
    else
      tmp_loc!(1) = qbert_location!(1) - 1
    end if

mmdebug on error skip
    sprite hide tmp_spr%


    select case field%(tmp_loc!(0),tmp_loc!(1))


    case 0,1
       if horz% = 1 then
        if vert% = 1 then
          sprite read QBERT,  64,0,16,16,3  'DNRIGHT
          sprite read QBERT+1,80,0,16,16,3
          b_spr% = 1
        else
          sprite read QBERT,   0,0,16,16,3  'UPRIGHT
          sprite read QBERT+1,16,0,16,16,3
          b_spr% = 1
        end if
      else
        if vert% = 1 then
          sprite read QBERT,   96,0,16,16,3  'DNLEFT
          sprite read QBERT+1,112,0,16,16,3
          b_spr% = 1
        else
          sprite read QBERT,   32,0,16,16,3 'UPLEFT
          sprite read QBERT+1, 48,0,16,16,3
          b_spr% = 1
        end if
      end if


mmdebug on error skip
      sprite show b_spr%+1,((tmp_loc!(0)+0)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1)-5+14),1 'QBERT+DNRIGHT+1
      cur_spr% = b_spr%+1

      if field%(tmp_loc!(0),tmp_loc!(1)) = 0 then
        math add x1%(),(tmp_loc!(0)-7)*16,nextx1%()
        math add y1%(),(tmp_loc!(1)-1)*28,nexty1%()
        polygon c1%,nextx1%(),nexty1%(),finishcolor%(0),finishcolor%(0)
    
        inc field%(tmp_loc!(0),tmp_loc!(1))
        score% = score% + 25
        inc cube_cnt%
        'text 100,10,"cube count = "+str$(cube_cnt%)+" ",L,,,RGB(WHITE)
      end if

      pause 30
mmdebug on error skip
      sprite hide b_spr%+1 'QBERT+DNRIGHT+1 

      'fix top on top cube from original background resotored
      if qbert_location!(0) = 7 then
        math add x1%(),(qbert_location!(0)-7)*16,nextx1%()
        math add y1%(),(qbert_location!(1)-1)*28,nexty1%()
        polygon c1%,nextx1%(),nexty1%(),finishcolor%(0),finishcolor%(0)
      end if

mmdebug on error skip
      sprite show b_spr%,((tmp_loc!(0)+0)*16)+qhx,qhy+8+(28*(tmp_loc!(1)+0)),1 'QBERT+DNRIGHT
      cur_spr% = b_spr%
'  text 100,30,"location = "+str$(tmp_loc!(0))+","+str$(tmp_loc!(1))+" ",L,,,RGB(WHITE)


      qbert_location!(0) = tmp_loc!(0)
      qbert_location!(1) = tmp_loc!(1)
    
  
      if cube_cnt% = 28 then   'round complete
        cube_flash
mmdebug on error skip
        sprite hide cur_spr%
mmdebug on error skip
        sprite hide c_cur_spr%
        select case round%
          case 1
            bonus% = 1000
          case 2
            bonus% = 1250
          case 3
            bonus% = 1500
          case 4
            bonus% = 1750
        end select
        bonus% = bonus% * level%
        score% = score% + bonus%
        score% = score% + discnt% * 50
        cube_cnt% = 1
        draw_cubes(TRUE)
        qbert_location(0) = 7
        qbert_location(1) = 1
        drop_in
       end if
       exit sub

      case -1
        play modsample 5,2,64,22050   'fall.wav  all qbert sounds on channel 2

        qstate = dead
'        sprite hide cur_spr%        
        exit sub
      
      case 255
       qbert_location!(0) = sdisc!(1,1)
       qbert_location!(1) = sdisc!(1,2)    
       'text 100,30,"location = "+str$(tmp_loc!(0))+","+str$(tmp_loc!(1))+" ",L,,,RGB(WHITE)
'        sprite hide cur_spr%


       sprite show b_spr%+1,((tmp_loc!(0)-1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1))-5,1 'QBERT+DNRIGHT+1
       cur_spr% = b_spr%+1
       pause 10
       sprite hide b_spr%+1 'QBERT+DNRIGHT+1

       pause 2

       play modsample 2,2,64,22050   'lift.wav  all qbert sounds on channel 2


        
        elevator(1,1)
        inc disccnt%,-1

        field%(tmp_loc!(0),tmp_loc!(1)) = -1
        settick 500,coilly,1
        exit sub
  
      case 254
        qbert_location!(0) = sdisc!(2,1)
        qbert_location!(1) = sdisc!(2,2)    
        'text 100,30,"location = "+str$(tmp_loc!(0))+","+str$(tmp_loc!(1))+" ",L,,,RGB(WHITE)

'        sprite hide b_spr%


        sprite show b_spr%+1,((tmp_loc!(0)-1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1))-5,1 'QBERT+DNRIGHT+1
        cur_spr% = b_spr%+1
        pause 10
        sprite hide b_spr%+1 'QBERT+DNRIGHT+1

        pause 2

        play modsample 2,2,64,22050   'lift.wav  all qbert sounds on channel 2



        elevator(2,-1)
        inc disccnt%,-1

        field%(tmp_loc!(0),tmp_loc!(1)) = -1
'        cur_spr% = QBERT+1
        settick 500,coilly,1
        exit sub
      
      case 253
        qbert_location!(0) = sdisc!(3,1)
        qbert_location!(1) = sdisc!(3,2)    
'        sprite hide b_spr%

        
        sprite show b_spr%+1,((tmp_loc!(0)-1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1))-5,1 'QBERT+DNRIGHT+1
        cur_spr% = b_spr%+1
        pause 10
        sprite hide b_spr%+1 'QBERT+DNRIGHT+1

        pause 2

        play modsample 2,2,64,22050   'lift.wav  all qbert sounds on channel 2


        elevator(3,1)
        inc disccnt%,-1

'        cur_spr% = QBERT+1
        field%(tmp_loc!(0),tmp_loc!(1)) = -1
        exit sub

      case 252
        qbert_location!(0) = sdisc!(4,1)
        qbert_location!(1) = sdisc!(4,2)    
'        sprite hide b_spr%

        sprite show b_spr%+1,((tmp_loc!(0)-1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1))-5,1 'QBERT+DNRIGHT+1
        cur_spr% = b_spr%+1
        pause 10
        sprite hide b_spr%+1 'QBERT+DNRIGHT+1

        pause 2

        play modsample 2,2,64,22050   'lift.wav  all qbert sounds on channel 2


        elevator(4,-1)
        inc disccnt%,-1

        field%(tmp_loc!(0),tmp_loc!(1)) = -1
'        cur_spr% = QBERT+1
        exit sub

      case 251
        qbert_location!(0) = sdisc!(5,1)
        qbert_location!(1) = sdisc!(5,2)    
'        sprite hide b_spr%

        sprite show b_spr%+1,((tmp_loc!(0)-1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1))-5,1 'QBERT+DNRIGHT+1
        cur_spr% = b_spr%+1
        pause 10
        sprite hide b_spr%+1 'QBERT+DNRIGHT+1

        pause 2

        play modsample 2,2,64,22050   'lift.wav  all qbert sounds on channel 2


        elevator(5,1)
        inc disccnt%,-1

        field%(tmp_loc!(0),tmp_loc!(1)) = -1
'        cur_spr% = QBERT+1
        exit sub

      case 250
        qbert_location!(0) = sdisc!(6,1)
        qbert_location!(1) = sdisc!(6,2)    
'        sprite hide b_spr%

        sprite show b_spr%+1,((tmp_loc!(0)-1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1))-5,1 'QBERT+DNRIGHT+1
        cur_spr% = b_spr%+1
        pause 10
        sprite hide b_spr%+1 'QBERT+DNRIGHT+1

        pause 2

        play modsample 2,2,64,22050   'lift.wav  all qbert sounds on channel 2

        elevator(6,-1)
        inc disccnt%,-1

        field%(tmp_loc!(0),tmp_loc!(1)) = -1
'        cur_spr% = QBERT+1
        exit sub

      case 249
        qbert_location!(0) = sdisc!(7,1)
        qbert_location!(1) = sdisc!(7,2)    
'        sprite hide b_spr%

        sprite show b_spr%+1,((tmp_loc!(0)-1)*16)+qhx,qhy+8+(28*(tmp_loc!(1)-1))-5,1 'QBERT+DNRIGHT+1
        cur_spr% = b_spr%+1
        pause 10
        sprite hide b_spr%+1 'QBERT+DNRIGHT+1

        pause 2

        play modsample 2,2,64,22050   'lift.wav  all qbert sounds on channel 2


        elevator(7,1)
        inc disccnt%,-1

        field%(tmp_loc!(0),tmp_loc!(1)) = -1
'        cur_spr% = QBERT+1
        exit sub            
    end select

'diagnostic to understand where program returns after a sprite collision
 cf% = FALSE


end sub


sub calc_discs(l%,r%)
  local d%,i%,idx%,numdiscs%

  if l% = 1 then numdiscs% = 2
  if l% = 2 then
    numdiscs% = 3
    if round% = 3 then numdiscs% = 2
  end if
  if l% = 3 then
    numdiscs% = 4
    if round% = 3 then numdiscs% = 3
  end if
  
  discnt% = numdiscs%


  i% = 1 
  if i% <= numdiscs% then
    idx% = cint(rnd*6)+1
    sdisc!(i%,0)  = TRUE
    sdisc!(i%,1) =  disc_pairs(idx%,0)
    sdisc!(i%,2) =  disc_pairs(idx%,1)
    field%(disc_pairs(idx%,0)+.5,disc_pairs(idx%,1)-1.2) = 255
  end if

  i% = i% + 1 '2
  if i% <= numdiscs% then
    sdisc!(i%,0)  = TRUE
    idx% = cint(rnd*6)+1
    sdisc!(i%,1) =  disc_pairs(idx%+7,0)
    sdisc!(i%,2) =  disc_pairs(idx%+7,1)
    field%(disc_pairs(idx%+7,0)-.5,disc_pairs(idx%+7,1)-1.2) = 254
  end if

  i% = i% + 1 '3
  if i% <= numdiscs% then  
    idx% = cint(rnd*6)+1
    do while disc_pairs(idx%,0) = sdisc(1,1)
      idx% = cint(rnd*6)+1
    loop      
    sdisc!(i%,0)  = TRUE
    sdisc!(i%,1) =  disc_pairs(idx%,0)
    sdisc!(i%,2) =  disc_pairs(idx%,1)
    field%(disc_pairs(idx%,0)+.5,disc_pairs(idx%,1)-1.2) = 253
  else
      sdisc!(i%,0) = FALSE
  end if
  

  i% = i% + 1 '4
  if i% <= numdiscs% then  
    idx% = cint(rnd*6)+1
    do while disc_pairs(idx%+7,0) = sdisc(2,1)
      idx% = cint(rnd*6)+1
    loop      
    sdisc!(i%,0)  = TRUE
    sdisc!(i%,1) =  disc_pairs(idx%+7,0)
    sdisc!(i%,2) =  disc_pairs(idx%+7,1)
    field%(disc_pairs(idx%+7,0)-.5,disc_pairs(idx%+7,1)-1.2) = 252
  else
      sdisc!(i%,0) = FALSE
  end if

  i% = i% + 1 '5
  if i% <= numdiscs% then  
    idx% = cint(rnd*6)+1
    do while disc_pairs(idx%,0) = sdisc(1,1) and disc_pairs(idx%,0) = sdisc(3,1)
      idx% = cint(rnd*6)+1
    loop      
    sdisc!(i%,0)  = TRUE
    sdisc!(i%,1) =  disc_pairs(idx%,0)
    sdisc!(i%,2) =  disc_pairs(idx%,1)
    field%(disc_pairs(idx%,0)+.5,disc_pairs(idx%,1)-1.2) = 251
  else
      sdisc!(i%,0) = FALSE
  end if

  i% = i% + 1 '6
  if i% <= numdiscs% then  
    idx% = cint(rnd*6)+1
    do while disc_pairs(idx%+7,0) = sdisc(2,1) and disc_pairs(idx%+7,0) = sdisc(4,1)
      idx% = cint(rnd*6)+1
    loop      
    sdisc!(i%,0)  = TRUE
    sdisc!(i%,1) =  disc_pairs(idx%+7,0)
    sdisc!(i%,2) =  disc_pairs(idx%+7,1)
    field%(disc_pairs(idx%+7,0)-.5,disc_pairs(idx%+7,1)-1.2) = 250
  else
      sdisc!(i%,0) = FALSE
  end if

  i% = i% + 1 '7
  if i% <= numdiscs% then  
    idx% = cint(rnd*6)+1
    do while disc_pairs(idx%,0) = sdisc(1,1)
      idx% = cint(rnd*6)+1
    loop      
    sdisc!(i%,0)  = TRUE
    sdisc!(i%,1) =  disc_pairs(idx%,0)
    sdisc!(i%,2) =  disc_pairs(idx%,1)
    field%(disc_pairs(idx%,0)+.5,disc_pairs(idx%,1)-1.2) = 249
  else
      sdisc!(i%,0) = FALSE
  end if

end sub


sub SelectInputDevice(skip_device%)
  local i,d

  
  for i = 0  to 3
    on error skip
    controller nunchuk open i
    if mm.errno > 0 then
      next
    else
      on error skip
      errno = nunchuk(t,i)
      if errno <> &Ha4200000 then

         HaveClassic = TRUE
          controller nunchuk close
          controller classic open i,button_pressed,&b111101110
          channel = i
          exit for
      else if errno = &ha4200000 then
        channel = i
        HaveNunchuk = TRUE
'        settick 7,pollclassic,1
        exit for     
      end if
    end if

  if channel > -1 then exit sub

  keyboard = TRUE
  settick 20,pollkeyboard,1
end sub

sub button_pressed
  local pressed

    if qstate = DEAD or cflag% = TRUE then exit sub  

        pressed = classic(b)        
        
        
        select case pressed and &b111111111
          case 2  ' start button

          case 4  ' home button
          
          case 8  ' select button
          
          case 32 ' cursor down
            hop(1,1)
          
          case 64 ' cursor right
            hop(1,-1)  
          
          case 128  'cursor up
            hop(-1,-1)
          
          case 256  'cursor left
            hop(-1,1)
            
         end select

    
end sub

sub pollkeyboard
     If xp% <> oldxp% or yp% <> oldyp% Then
       oldxp% = xp% : oldyp% = yp%
       GUI CURSOR XP%,YP%
    end if
end sub

sub draw_cubes(clflag%)
if clflag% then
  cls

  timer = 0

  flg% = TRUE



  ' player numer
  blit write 62,68,8
  'level
  blit write 61,340,80
  level_colr% = pixel(343,85)


  'round
  blit write 60,340,90
  round_colr% = pixel(340,95)


  'change to
  blit write 59,10,50


'  reset playfield
  math scale playfield%(),1,field%()
  calc_discs(level%,round%)
'  math add y%(),-(3*56),y%()


end if

if level% = 1 then

  select case round%
    case 1
      restore level11
    case 2
      restore level12
  end select

end if

for z = 0 to 2
  read startcolor%(z)
next


polygon c%(),x%(),y%(),startcolor%(),startcolor%()

for l% = 1 to 3
  for i% = 1 to k%
      math add x%(),-(i%*16),nextx%()
      math add y%(),i%*28,nexty%()
      polygon c%(),nextx%(),nexty%(),startcolor%(),startcolor%()
      
      math add x%(),i%*16,nextx%()
      math add y%(),i%*28,nexty%()
      polygon c%(),nextx%(),nexty%(),startcolor%(),startcolor%()

  next

  math add y%(),56,y%()
  polygon c%(),x%(),y%(),startcolor%(),startcolor%()
  k% = k% - 2
next
page copy 0 to 4,b


page write 5
cls
k% = 6

'shift cubes back to the original y position
math add y%(),-(3*56),y%()

for z = 0 to 2
  read finishcolor%(z)
next

polygon c%(),x%(),y%(),finishcolor%(),finishcolor%()

page write 0

image resize 224,92,32,36,90,45,16,18,5


page write 5
for l% = 1 to 3
  for i% = 1 to k%

      math add x%(),-(i%*16),nextx%()
      math add y%(),i%*28,nexty%()
      polygon c%(),nextx%(),nexty%(),finishcolor%(),finishcolor%()
      
      math add x%(),i%*16,nextx%()
      math add y%(),i%*28,nexty%()
      polygon c%(),nextx%(),nexty%(),finishcolor%(),finishcolor%()

  next

  math add y%(),56,y%()
  polygon c%(),x%(),y%(),finishcolor%(),finishcolor%()
  k% = k% - 2
next

  math add y%(),-(3*56),y%()

  k% = 6
page write 0

' used for cube flashing
blit read 64,120,89,9*28,9*28
blit read 63,120,89,9*28,9*28,5




end sub
