
'
'N-BODY SIMULATOR USING Runge-Kutta Method
'adapted from qbasic program found online in a
'paper authored by John Atsu-Swanzy in May 1997 at Rowan University, New Jersey, USA
'adapted/expenaded by yock1960 to the CMM2, March 2021.
'Thanks to vegipete & Epsilon for makebox and the getfile dialogs!


#include "getfile.inc"


CONST MAXB = 10
CONST TRUE = 1
CONST FALSE = 0

dim files_flag% = 0

CONST DIRCOUNT% = 50   ' max number of sub-directories
CONST FILCOUNT% = 255  ' max number of files
CONST NAMELENGTH% = 64
dim dir_dirs$(DIRCOUNT%) length NAMELENGTH%  ' store list of directories
dim dir_fils$(FILCOUNT%) length NAMELENGTH%  ' store list of files
dim dir_hist$(DIRCOUNT%) length 8 ' store directory number visited along path
dim dir_notroot  ' used internally to indicate root directory or not
dim FileName$
dim Fn$

dim sp% = TRUE
dim trails% = TRUE
DIM KEY$
dim G! = 6.67259E-11 ' Universal gravitational constant
dim P% = 2           ' Central force G M m / r^P
dim N% = 6           ' N - number of bodies
dim X!(MAXB)
DIM Y!(MAXB)
DIM VX!(MAXB)
DIM VY!(MAXB)
DIM M!(MAXB)
DIM R!(MAXB)
DIM AX!(MAXB)
DIM AY!(MAXB)
DIM DELTAX!(MAXB)
DIM DELTAY!(MAXB)
DIM DVX!(MAXB)
DIM DVY!(MAXB)
DIM DX!(MAXB)
DIM DY!(MAXB)
DIM VXR!(MAXB)
DIM VYR!(MAXB)
DIM XR!(MAXB)
DIM YR!(MAXB)
DIM AXR!(MAXB)
DIM AYR!(MAXB)
DIM DVXR!(MAXB)
DIM DVYR!(MAXB)
DIM DVXA!(MAXB)
DIM DVYA!(MAXB)
DIM DYA!(MAXB)
DIM DXA!(MAXB)
DIM DXR!(MAXB)
DIM DYR!(MAXB)
DIM PX!
DIM PY!
DIM I%
DIM J%
DIM C!
' Initial time and increment
DIM T! = 0
DIM DT! = 360
'SCREEN RADIUS
'DIM RD! = 10E+10
dim rd! = 4e11
dim name$(MAXB)
dim s%
dim base! = 4e11


'Establish screen parameters
MODE 11,8 '1280*720
'color white,notblack
CLS

load_file
settick 100,pollkeyboard,1
make_sprites
grid

DO WHILE KEY$ <> "Q" 'Loop Until key pressed
  calc_position

  if ucase$(key$) = "H" then
    show_help
    key$ = ""
  end if

  if ucase$(key$) = "P" then
    sp% = not sp%
    if sp% = FALSE then
       cls
       if trails% then
          page or_pixels 0,2,0
       end if       
    end if
     key$ = ""
  end if

  if ucase$(key$) = "C" then
    CLS
    key$ = ""
    grid
  end if

  if ucase$(key$) = "T" then
    trails% = not trails%
    if trails% = FALSE then
      cls
    end if
    key$ = ""
  end if

  if ucase$(key$) = "R" then
    cls
    page write 2
    cls
    page write 0
    re_center
    grid
    key$ = ""
  end if

  'out
  if ucase$(key$) = "O" then
    RD! = RD! * 2    
    if RD! > 8*base! then
      RD! = 8*base!
    end if
    page write 2
    CLS
    page write 0
    cls
    key$ = ""
    grid
  end if
    

  'in
  if ucase$(key$) = "I" then
    RD! = RD! / 2
    if RD! < base!/4 then
      RD! = base!/4
    end if

    page write 2
    CLS
    page write 0
    cls
    key$ = ""
    grid
  end if

  if key$ = "+" then
    if DT! < 23040 then
      DT! = DT! * 2
      key$ = ""
    end if
  end if

  if key$ = "-" then
    if DT! > 360 then
      DT! = DT! / 2
    end if
    key$ = ""
  end if
  
  
  if ucase$(key$) = "L" then
    load_file
    cls
    page write 2
    cls
    page write 0
    key$ = ""
  end if

  if ucase$(key$) = "S" then
    save_file
    cls
    page write 2
    cls
    page write 0
    key$ = ""
  end if
  
loop

settick 0,pollkeyboard,1

end

sub calc_position
  local i%,j%,ts%,t1!,un$="days"
  static tm% = 0
  static flg% = FALSE

  ts% = int(DT!/360)
  
  FOR I% = 1 TO N%
  'Find AX(I) and AY(I) components of acceleratio on I-th mass
    AX(I%) = 0
    AY(I%) = 0
    FOR J% = 1 TO N%
      IF J% <> I% THEN
        DELTAX!(J%) = X!(J%) - X!(I%)
        DELTAY!(J%) = Y!(J%) - Y!(I%)
        R!(J%) = (DELTAX!(J%) ^ 2 + DELTAY!(J%) ^ 2 + soft! ^ 2) ^ .5
        AX!(I%) = AX!(I%) + G! * M!(J%) * DELTAX!(J%) / R!(J%) ^ (P% + 1)
        AY!(I%) = AY!(I%) + G! * M!(J%) * DELTAY!(J%) / R!(J%) ^ (P% + 1)
      END IF
    NEXT 'J%
    'Find dVX, dVY, dX, and dY on the left of our interval
    DVX!(I%) = AX!(I%) * DT!
    DVY!(I%) = AY!(I%) * DT!
    DX!(I%) = VX!(I%) * DT!
    DY!(I%) = VY!(I%) * DT!
    'Estimate VXR - VX on right side of our interval, VYR = etc
    VXR!(I%) = VX!(I%) + DVX!(I%)
    VYR!(I%) = VY!(I%) + DVY!(I%)
    XR!(I%) = X!(I%) + DX!(I%)
    YR!(I%) = Y!(I%) + DY!(I%)
  NEXT 'I%


  FOR I% = 1 TO N%
    AXR!(I%) = 0
    AYR!(I%) = 0
    FOR J% = 1 TO N%
      IF J% <> I% THEN
        DELTAX!(J%) = X!(J%) - X!(I%)
        DELTAY!(J%) = Y!(J%) - Y!(I%)
        R!(J%) = (DELTAX!(J%) ^ 2 + DELTAY!(J%) ^ 2 + soft! ^ 2) ^ .5
        AXR!(I%) = AXR!(I%) + G! * M!(J%) * DELTAX!(J%) / R!(J%) ^ (P% + 1)
        AYR!(I%) = AYR!(I%) + G! * M!(J%) * DELTAY!(J%) / R!(J%) ^ (P% + 1)
      END IF
    NEXT 'J%
  
    DVXR!(I%) = AXR!(I%) * DT!
    DVYR!(I%) = AYR!(I%) * DT!
    DXR!(I%) = VXR!(I%) * DT!
    DYR!(I%) = VYR!(I%) * DT!
  
    IF DT! = 360 then
      DVXA!(I%) = (DVX!(I%) + DVXR!(I%))/2
      DVYA!(I%) = (DVY!(I%) + DVYR!(I%))/2
      DXA!(I%) = (DX!(I%) + DXR!(I%))/2
      DYA!(I%) = (DY!(I%) + DYR!(I%))/2
    else    'this appears to fix the drifting orbit of innermost orbits when time interval is increased > 1
      DVXA!(I%) = (DVX!(I%) + DVXR!(I%))/4
      DVYA!(I%) = (DVY!(I%) + DVYR!(I%))/4
      DXA!(I%) = (DX!(I%) + DXR!(I%))/4
      DYA!(I%) = (DY!(I%) + DYR!(I%))/4
    end if
  
    VX!(I%) = VX!(I%) + DVXA!(I%)
    VY!(I%) = VY!(I%) + DVYA!(I%)
    X!(I%) = X!(I%) + DXA!(I%)
    Y!(I%) = Y!(I%) + DYA!(I%)
  
    scale! = RD!/base!

    select case scale!
      case .5
        PX! = (X!(I%)/RD!)*1280*.5625-(640+160)
        PY! = (Y!(I%)/RD!)*720-(360)
      case 1
        PX! = (X!(I%)/RD!)*1280*.5625-80
        PY! = (Y!(I%)/RD!)*720
      case 2
        PX! = (X!(I%)/RD!)*1280*.5625+280
        PY! = (Y!(I%)/RD!)*720+180
      case 4
        PX! = (X!(I%)/RD!)*1280*.5625+460
        PY! = (Y!(I%)/RD!)*720+270
      case 8
        PX! = (X!(I%)/RD!)*1280*.5625+545
        PY! = (Y!(I%)/RD!)*720+315
      case else
        PX! = (X!(I%)/RD!)*1280*.5625-(1280+960)
        PY! = (Y!(I%)/RD!)*720-(720+360)

    end select


    SELECT CASE I%
      CASE 1
        C! = RGB(YELLOW)
      CASE 2
        C! = RGB(RED)
      CASE 3
        C! = RGB(GREEN)
      CASE 4
        C! = RGB(BLUE)
      CASE 5
        C! = RGB(WHITE)
      CASE 6
        C! = RGB(MAGENTA)
      CASE 7
        C! = RGB(PINK)
      CASE 8
        C! = RGB(GOLD)
      CASE 9
        C! = RGB(SALMON)
    END SELECT


    page write 2
    pixel px!,py!,c!
    page write 0
    

    if sp% then 
      if px! > 0 and px! < mm.hres-2 then
        if py! > 0 and py! < mm.vres-2 then
          sprite show i%,px!-4,py!-4,0
        else
          if sprite(x,i%) <> 10000 then
            sprite hide #i%
          end if
        end if
      else
        if sprite(x,i%) <> 10000 then
          sprite hide #i%
        end if
      end if
    end if

    if tm% - (dt!*100) >= 0 then
      flg% = TRUE 
    end if

    if trails% then
      if flg% = TRUE then
        if TRUE then
          page or_pixels 0,2,0
        end if
        tm% = 0
        flg% = FALSE
      end if
    end if
  
    T! = T! + DT!
    tm% = tm% + DT!
    t1! = T!/86400/20
    if t1! > 365 then
      t1! = t1!/365
      un$ = "years"
    end if
    TEXT 5,MM.VRES-32,"Time = "+STR$(T1!,3,2)+" "+un$,L,,,RGB(WHITE)
    TEXT 5,MM.VRES-16,"Simulation Speed= "+str$(int(DT!/360),2)+"x",L,,,RGB(WHITE)
    TEXT MM.HRES-400,MM.VRES-16,"Filename: "+Fn$+" ",L,,,RGB(WHITE)  
  
  NEXT
  
end sub  
    

sub re_center
  local dx!,dy!,i%

  dx! = 4.0e11 - x!(1)
  dy! = 2.0e11 - y!(1)
  
  for i% = 1 to n%
      x!(i%) = x!(i%) + dx!
      y!(i%) = y!(i%) + dy!
  next
  
end sub
  
sub load_file
  local i%,OldFileName$="pattern",d$
    files_flag% = 0

      Filename$ = Getfilename(15,"*.dat")
      if Filename$ = "" then
        exit sub
      end if

      OldFileName$ = FileName$
        Open FileName$ for Input As #1
      If MM.ERRNO = 0 Then
        text 8,MM.VRES-26,"Loading: "+Filename$,L,,,BLACK,RGB(102,51,51)
        input #1,d$
        sy% = val(d$)
        input #1,d$
        n% = val(d$)
        
        for i% = 1 to n%
          input #1,name$(i%)
          input #1,d$
          m!(i%) = val(d$)
          input #1,d$
          x!(i%) = val(d$)
          input #1,d$
          y!(i%) = val(d$)
          input #1,d$
          vx!(i%) = val(d$)
          input #1,d$
          vy!(i%) = val(d$)
        next
        Close #1
      End if
      CLS
      T! = 0
      Fn$ = right$(Filename$,len(filename$)-instr(4,Filename$,"/"))
end sub


sub save_file
  local i%,OldFileName$="pattern",d$
    files_flag% = 0

      Filename$ = Savefilename(15,"*")
      if Filename$ = "" then
        exit sub
      end if

      OldFileName$ = FileName$
        Open FileName$ for Output As #1
      If MM.ERRNO = 0 Then
        text 8,MM.VRES-26,"Saving: "+Filename$,L,,,BLACK,RGB(102,51,51)
        print #1,str$(sy%)
        print #1,str$(n%)
        
        for i% = 1 to n%
          print #1,name$(i%)
          print #1,str$(m!(i%))
          print #1,str$(x!(i%))
          print #1,str$(y!(i%))
          print #1,str$(vx!(i%))
          print #1,str$(vy!(i%))
        next
        Close #1
      End if
      CLS
      Fn$ = right$(Filename$,len(filename$)-instr(4,Filename$,"/"))

end sub



sub make_sprites
  local i%
  
  page write 2
  cls
  
  for i% = 1 to 10
  
    SELECT CASE I%
      CASE 1
        C! = RGB(YELLOW)
      CASE 2
        C! = RGB(RED)
      CASE 3
        C! = RGB(GREEN)
      CASE 4
        C! = RGB(BLUE)
      CASE 5
        C! = RGB(WHITE)
      CASE 6
        C! = RGB(MAGENTA)
      CASE 7
        C! = RGB(PINK)
      CASE 8
        C! = RGB(GOLD)
      CASE 9
        C! = RGB(SALMON)
    END SELECT

    circle 100,100,3,,,c!,c!
    
    sprite read #i%,96,96,8,8,2
    
  next
  cls
 page write 0
end sub

sub pollkeyboard

  key$ = ucase$(inkey$)

end sub

' Draw a pleasant box on the screen. Background is not saved!
sub MakeBox(x,y,w,h)
  rbox x    , y    , w     , h     , 10,  &h4040E0, &h4040E0  ' frame
  rbox x + 5, y + 5, w - 10, h - 10,  5,  &h202080, &h202080  ' text area
end sub

sub show_help
    page copy 0 to 1

    MakeBox(120,150,720,290)

      text 170,170,"N-Body Simulator for the CMM2 -Help-",L,,,RGB(WHITE),&h202080
      text 170,185,"",L,,,RGB(WHITE),&h202080
      text 170,200,"Pressing the 'P' key toggles 'body' sprites on/off",L,,,RGB(WHITE),&h202080
      text 170,215,"Pressing the 'T' key toggles orbit trails on/off",L,,,RGB(WHITE),&h202080
      text 170,230,"Pressing the 'O' key zooms out. This erases existing trails.",L,,,RGB(WHITE),&h202080
      text 170,245,"Pressing the 'I' key zooms in. This erases existing trails.",L,,,RGB(WHITE),&h202080
      text 170,260,"Pressing the '+' key doubles the apparent simulation speed.",L,,,RGB(WHITE),&h202080
      text 170,275,"Pressing the '-' key halves the apparent simulation speed.",L,,,RGB(WHITE),&h202080
      text 170,290,"Pressing the 'C' key will clean up the display of any 'debris'",L,,,RGB(WHITE),&h202080
      text 170,305,"Pressing the 'H' key displays of this screen.",L,,,RGB(WHITE),&h202080
      text 170,320,"Pressing the 'L' key allows loading a new data set",L,,,RGB(WHITE),&h202080
      text 170,335,"Pressing the 'S' key allows saving the current sim state",L,,,RGB(WHITE),&h202080
      text 170,350,"Pressing the 'R' re-centers the simulation.",L,,,RGB(WHITE),&h202080
      text 170,365,"Pressing the 'Q' key exits the program.",L,,,RGB(WHITE),&h202080
      text 170,386,"Press any key to continue...",L,,,RGB(WHITE),&h202080

    do while inkey$ = ""
    loop

    page copy 1 to 0

end sub


sub grid
  local x%,y%,l%

  for x% = 0 to mm.hres+1 step mm.hres/4
    line x%,0,x%,5,1,RGB(ORANGE)
  next
  for y% = 0 to mm.vres step mm.vres/4
    line mm.hres,y%,mm.hres-5,y%,1,RGB(orange)
  next
  text mm.hres-60,18,str$(rd!),L,1,,RGB(ORANGE)
end sub
